/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlserver;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.exception.ParsingException;
import de.uni_koblenz.jgralab.greql.exception.QuerySourceException;
import de.uni_koblenz.jgralab.greql.serialising.DefaultWriter;
import de.uni_koblenz.jgralab.greql.serialising.HTMLOutputWriter;
import de.uni_koblenz.jgralab.greql.serialising.XMLOutputWriter;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class GReQLConsole {
    private Graph graph = null;
    private boolean verbose = false;

    public GReQLConsole(String string, boolean bl, boolean bl2) {
        this.verbose = bl2;
        try {
            if (bl) {
                if (bl2) {
                    System.out.println("Loading schema from file");
                }
                Schema schema = GraphIO.loadSchemaFromFile(string);
                schema.compile(CodeGeneratorConfiguration.MINIMAL);
            }
            if (string != null) {
                this.graph = GraphIO.loadGraphFromFile(string, bl2 ? new ConsoleProgressFunction("Loading") : null);
            }
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadQueries(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("//--")) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue;
                }
                stringBuilder.append(string + " \n");
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (stringBuilder.length() != 0) {
            string = stringBuilder.toString();
            arrayList.add(string);
        }
        return arrayList;
    }

    private Object performQuery(File file) throws GreqlException {
        Object object = null;
        try {
            for (String string : this.loadQueries(file)) {
                if (this.verbose) {
                    System.out.println("Evaluating query: ");
                    System.out.println(string);
                }
                object = GreqlQuery.createQuery(string).evaluate(this.graph, new GreqlEnvironmentAdapter(), this.verbose ? new ConsoleProgressFunction() : null);
                if (!this.verbose || !(object instanceof Collection)) continue;
                System.out.println("Result size is: " + ((Collection)object).size());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return object;
    }

    private void saveResultToFile(Object object, String string, String string2) throws Exception {
        if (string2 == null || string2.isEmpty()) {
            string2 = "html";
        }
        if (string2.equalsIgnoreCase("html")) {
            HTMLOutputWriter hTMLOutputWriter = new HTMLOutputWriter(this.graph);
            ((DefaultWriter)hTMLOutputWriter).writeValue(object, new File(string));
        } else if (string2.equalsIgnoreCase("xml")) {
            XMLOutputWriter xMLOutputWriter = new XMLOutputWriter(this.graph);
            ((DefaultWriter)xMLOutputWriter).writeValue(object, new File(string));
        } else if (string2.equalsIgnoreCase("txt")) {
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.append(object.toString());
            fileWriter.flush();
            fileWriter.close();
        } else {
            throw new RuntimeException("Unsupported output type " + string + "!");
        }
    }

    public static void main(String[] stringArray) {
        try {
            CommandLine commandLine = GReQLConsole.processCommandLineOptions(stringArray);
            assert (commandLine != null);
            String string = commandLine.getOptionValue("q");
            String string2 = commandLine.getOptionValue("g");
            boolean bl = commandLine.hasOption("s");
            JGraLab.setLogLevel(Level.SEVERE);
            GReQLConsole gReQLConsole = new GReQLConsole(string2, bl, commandLine.hasOption('v'));
            Object object = gReQLConsole.performQuery(new File(string));
            if (commandLine.hasOption("o")) {
                gReQLConsole.saveResultToFile(object, commandLine.getOptionValue("o"), commandLine.getOptionValue('t'));
            } else {
                System.out.println("Result: " + object);
            }
        }
        catch (Exception exception) {
            if (exception instanceof ParsingException) {
                ParsingException parsingException = (ParsingException)exception;
                System.err.println("##exception=ParsingException");
                System.err.println("##offset=" + parsingException.getOffset());
                System.err.println("##length=" + parsingException.getLength());
            } else if (exception instanceof QuerySourceException) {
                QuerySourceException querySourceException = (QuerySourceException)exception;
                System.err.println("##exception=" + querySourceException.getClass().getSimpleName());
                System.err.println("##offset=" + querySourceException.getOffset());
                System.err.println("##length=" + querySourceException.getLength());
            }
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + GReQLConsole.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("q", "queryfile", true, "(required): queryfile which should be executed. May contain many queries separated by //-- on a line");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("g", "graph", true, "(optional): the tg-file of the graph");
        option2.setRequired(false);
        option2.setArgName("file");
        optionHandler.addOption(option2);
        Option option3 = new Option("o", "output", true, "(optional): result file to be generated (see option --output-type, defaults to html)");
        option3.setArgName("file");
        optionHandler.addOption(option3);
        Option option4 = new Option("t", "output-type", true, "(optional): if -o is given, the output type to use (txt, html, or xml)");
        option4.setArgName("type");
        optionHandler.addOption(option4);
        Option option5 = new Option("s", "loadschema", false, "(optional): Loads also the schema from the file");
        optionHandler.addOption(option5);
        Option option6 = new Option("v", "verbose", false, "(optional): Produce verbose output");
        optionHandler.addOption(option6);
        return optionHandler.parse(stringArray);
    }
}

