/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.rsa2tg;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.BooleanDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.DoubleDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.IntegerDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.LongDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.StringDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.EndsAt;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2schemagraph.Schema2SchemaGraph;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;

public class SchemaGraph2XMI {
    private final TreeSet<Domain> typesToBeDeclaredAtTheEnd = new TreeSet();
    private boolean isBidirectional = false;

    public static void main(String[] stringArray) throws GraphIOException {
        System.out.println("SchemaGraph to XMI");
        System.out.println("==================");
        SchemaGraph2XMI schemaGraph2XMI = new SchemaGraph2XMI();
        CommandLine commandLine = SchemaGraph2XMI.processCommandLineOptions(stringArray);
        assert (commandLine != null) : "No CommandLine object has been generated!";
        schemaGraph2XMI.isBidirectional = commandLine.hasOption("b");
        String string = commandLine.getOptionValue("o");
        try {
            if (commandLine.hasOption("ig")) {
                schemaGraph2XMI.process(GrumlSchema.instance().loadSchemaGraph(commandLine.getOptionValue("ig")), string);
            } else {
                schemaGraph2XMI.process(new Schema2SchemaGraph().convert2SchemaGraph(GraphIO.loadSchemaFromFile(commandLine.getOptionValue("i"))), string);
            }
        }
        catch (Exception exception) {
            System.err.println("An Exception occured while processing " + (commandLine.hasOption("i") ? commandLine.getOptionValue("i") : commandLine.getOptionValue("ig")) + ".");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            exception.printStackTrace();
        }
        System.out.println("Fini.");
    }

    public static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + SchemaGraph2XMI.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("o", "output", true, "(required): the output xmi file name");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("ig", "inputSchemaGraph", true, "(required or -i):if set, the schemaGraph is converted into a xmi.");
        option2.setRequired(false);
        option2.setArgs(0);
        option.setArgName("file");
        optionHandler.addOption(option2);
        Option option3 = new Option("i", "inputSchema", true, "(required or -ig): TG-file of the schema which should be converted into a xmi.");
        option3.setRequired(false);
        option3.setArgName("file");
        optionHandler.addOption(option3);
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(option2);
        optionGroup.addOption(option3);
        optionGroup.setRequired(true);
        optionHandler.addOptionGroup(optionGroup);
        Option option4 = new Option("b", "bidirectional", false, "(optional): If set the EdgeClasses are created as bidirectional associations.");
        option4.setRequired(false);
        optionHandler.addOption(option4);
        return optionHandler.parse(stringArray);
    }

    public void process(SchemaGraph schemaGraph, String string) throws XMLStreamException, IOException {
        this.createXMI(string, schemaGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXMI(String string, SchemaGraph schemaGraph) throws XMLStreamException, IOException {
        Writer writer = null;
        XMLStreamWriter xMLStreamWriter = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(writer);
            xMLStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.createRootElement(xMLStreamWriter, schemaGraph);
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            writer.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (xMLStreamWriter != null) {
                xMLStreamWriter.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void createRootElement(XMLStreamWriter xMLStreamWriter, SchemaGraph schemaGraph) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("xmi", "XMI", "http://schema.omg.org/spec/XMI/2.1");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "version", "2.1");
        xMLStreamWriter.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xMLStreamWriter.setPrefix("Ecore", "http://www.eclipse.org/uml2/schemas/Ecore/5");
        xMLStreamWriter.setPrefix("ecore", "http://www.eclipse.org/emf/2002/Ecore");
        xMLStreamWriter.setPrefix("uml", "http://schema.omg.org/spec/UML/2.1.1");
        xMLStreamWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.eclipse.org/uml2/schemas/Ecore/5 pathmap://UML_PROFILES/Ecore.profile.uml#_z1OFcHjqEdy8S4Cr8Rc_NA http://schema.omg.org/spec/UML/2.1.1 http://www.eclipse.org/uml2/2.1.0/UML");
        this.createModelElement(xMLStreamWriter, schemaGraph);
        xMLStreamWriter.writeEndElement();
    }

    private void createModelElement(XMLStreamWriter xMLStreamWriter, SchemaGraph schemaGraph) throws XMLStreamException {
        Schema schema = schemaGraph.getFirstSchema();
        xMLStreamWriter.writeStartElement("http://schema.omg.org/spec/UML/2.1.1", "Model");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", schema.get_packagePrefix() + "." + schema.get_name());
        xMLStreamWriter.writeAttribute("name", schema.get_packagePrefix() + "." + schema.get_name());
        this.createAttributedElementClass(xMLStreamWriter, schemaGraph.getFirstGraphClass());
        this.createPackage(xMLStreamWriter, (Package)schemaGraph.getFirstSchema().getFirstContainsDefaultPackageIncidence().getThat());
        if (!this.typesToBeDeclaredAtTheEnd.isEmpty()) {
            this.createTypes(xMLStreamWriter);
        }
        this.createProfileApplication(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    private void createPackage(XMLStreamWriter xMLStreamWriter, Package package_) throws XMLStreamException {
        boolean bl = false;
        if (!this.isPackageEmpty(package_)) {
            NamedElement namedElement;
            if (!package_.get_qualifiedName().equals("")) {
                boolean bl2 = bl = package_.getFirstAnnotatesIncidence() != null || package_.getFirstContainsDomainIncidence() != null || package_.getFirstContainsGraphElementClassIncidence() != null || package_.getFirstContainsSubPackageIncidence(EdgeDirection.OUT) != null;
                if (bl) {
                    xMLStreamWriter.writeStartElement("packagedElement");
                } else {
                    xMLStreamWriter.writeEmptyElement("packagedElement");
                }
                xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Package");
                xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", package_.get_qualifiedName());
                xMLStreamWriter.writeAttribute("name", this.extractSimpleName(package_.get_qualifiedName()));
            }
            this.createComments(xMLStreamWriter, package_);
            for (ContainsDomain edge : package_.getContainsDomainIncidences()) {
                namedElement = (Domain)edge.getThat();
                if (namedElement.get_qualifiedName().equals("Boolean") || namedElement.get_qualifiedName().equals("Double") || namedElement.get_qualifiedName().equals("Integer") || namedElement.get_qualifiedName().equals("Long") || namedElement.get_qualifiedName().equals("String")) continue;
                if (namedElement instanceof EnumDomain) {
                    this.createEnum(xMLStreamWriter, (EnumDomain)namedElement);
                    continue;
                }
                if (!(namedElement instanceof RecordDomain)) continue;
                this.createRecordDomain(xMLStreamWriter, (RecordDomain)namedElement);
            }
            for (ContainsGraphElementClass containsGraphElementClass : package_.getContainsGraphElementClassIncidences()) {
                namedElement = (GraphElementClass)containsGraphElementClass.getThat();
                this.createAttributedElementClass(xMLStreamWriter, (AttributedElementClass)namedElement);
            }
            for (ContainsSubPackage containsSubPackage : package_.getContainsSubPackageIncidences(EdgeDirection.OUT)) {
                this.createPackage(xMLStreamWriter, (Package)containsSubPackage.getThat());
            }
            if (bl) {
                xMLStreamWriter.writeEndElement();
            }
        }
    }

    private boolean isPackageEmpty(Package package_) {
        boolean bl;
        boolean bl2 = bl = package_.getFirstAnnotatesIncidence() == null && package_.getFirstContainsDomainIncidence() == null && package_.getFirstContainsGraphElementClassIncidence() == null;
        if (!bl) {
            return false;
        }
        for (ContainsSubPackage containsSubPackage : package_.getContainsSubPackageIncidences(EdgeDirection.OUT)) {
            if (this.isPackageEmpty((Package)containsSubPackage.getThat())) continue;
            return false;
        }
        return true;
    }

    private void createRecordDomain(XMLStreamWriter xMLStreamWriter, RecordDomain recordDomain) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("packagedElement");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Class");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", recordDomain.get_qualifiedName());
        xMLStreamWriter.writeAttribute("name", this.extractSimpleName(recordDomain.get_qualifiedName()));
        this.createExtension(xMLStreamWriter, recordDomain, "record");
        this.createComments(xMLStreamWriter, recordDomain);
        for (HasRecordDomainComponent hasRecordDomainComponent : recordDomain.getHasRecordDomainComponentIncidences(EdgeDirection.OUT)) {
            this.createAttribute(xMLStreamWriter, hasRecordDomainComponent.get_name(), null, (Domain)hasRecordDomainComponent.getThat(), recordDomain.get_qualifiedName() + "_" + hasRecordDomainComponent.get_name());
        }
        xMLStreamWriter.writeEndElement();
    }

    private void createEnum(XMLStreamWriter xMLStreamWriter, EnumDomain enumDomain) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("packagedElement");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Enumeration");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", enumDomain.get_qualifiedName());
        xMLStreamWriter.writeAttribute("name", this.extractSimpleName(enumDomain.get_qualifiedName()));
        this.createComments(xMLStreamWriter, enumDomain);
        for (String string : enumDomain.get_enumConstants()) {
            xMLStreamWriter.writeEmptyElement("ownedLiteral");
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:EnumerationLiteral");
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", enumDomain.get_qualifiedName() + "_" + string);
            xMLStreamWriter.writeAttribute("name", string);
            xMLStreamWriter.writeAttribute("classifier", enumDomain.get_qualifiedName());
        }
        xMLStreamWriter.writeEndElement();
    }

    private void createProfileApplication(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("profileApplication");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:ProfileApplication");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", "profileApplication" + System.currentTimeMillis());
        this.createExtension(xMLStreamWriter, null, null);
        xMLStreamWriter.writeEmptyElement("appliedProfile");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Profile");
        xMLStreamWriter.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/StandardProfileL2.xmi#_0");
        xMLStreamWriter.writeEndElement();
    }

    private void createTypes(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("packagedElement");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Package");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", "PrimitiveTypes");
        xMLStreamWriter.writeAttribute("name", "PrimitiveTypes");
        for (Domain domain : this.typesToBeDeclaredAtTheEnd) {
            xMLStreamWriter.writeEmptyElement("packagedElement");
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", domain.get_qualifiedName().replaceAll("\\s", "").replaceAll("<", "_").replaceAll(">", "_"));
            xMLStreamWriter.writeAttribute("name", this.extractSimpleName(domain.get_qualifiedName()));
        }
        xMLStreamWriter.writeEndElement();
    }

    private void createAttributedElementClass(XMLStreamWriter xMLStreamWriter, AttributedElementClass attributedElementClass) throws XMLStreamException {
        boolean bl;
        boolean bl2 = bl = attributedElementClass.getFirstAnnotatesIncidence() == null && attributedElementClass.getFirstHasAttributeIncidence() == null && attributedElementClass.getFirstHasConstraintIncidence() == null && attributedElementClass instanceof GraphElementClass && !((GraphElementClass)attributedElementClass).is_abstract() && (attributedElementClass instanceof VertexClass && ((VertexClass)attributedElementClass).getFirstSpecializesVertexClassIncidence(EdgeDirection.OUT) == null && !this.hasChildIncidence((VertexClass)attributedElementClass) || attributedElementClass instanceof EdgeClass && ((EdgeClass)attributedElementClass).getFirstSpecializesEdgeClassIncidence(EdgeDirection.OUT) == null && this.isBidirectional);
        if (bl) {
            xMLStreamWriter.writeEmptyElement("packagedElement");
        } else {
            xMLStreamWriter.writeStartElement("packagedElement");
        }
        if (attributedElementClass instanceof EdgeClass) {
            if (attributedElementClass.getFirstHasAttributeIncidence() == null) {
                xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Association");
            } else {
                xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:AssociationClass");
            }
        } else {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Class");
        }
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", attributedElementClass.get_qualifiedName());
        xMLStreamWriter.writeAttribute("name", this.extractSimpleName(attributedElementClass.get_qualifiedName()));
        if (attributedElementClass instanceof EdgeClass) {
            Iterator<SpecializesEdgeClass> iterator = (EdgeClass)attributedElementClass;
            xMLStreamWriter.writeAttribute("memberEnd", ((VertexClass)((IncidenceClass)iterator.getFirstComesFromIncidence().getThat()).getFirstEndsAtIncidence().getThat()).get_qualifiedName() + "_incidence_" + iterator.get_qualifiedName() + "_from " + ((VertexClass)((IncidenceClass)iterator.getFirstGoesToIncidence().getThat()).getFirstEndsAtIncidence().getThat()).get_qualifiedName() + "_incidence_" + iterator.get_qualifiedName() + "_to");
        }
        if (attributedElementClass instanceof GraphElementClass && ((GraphElementClass)attributedElementClass).is_abstract()) {
            xMLStreamWriter.writeAttribute("isAbstract", "true");
            this.createExtension(xMLStreamWriter, attributedElementClass, "abstract");
        }
        if (attributedElementClass instanceof GraphClass) {
            this.createExtension(xMLStreamWriter, attributedElementClass, "graphclass");
        }
        this.createComments(xMLStreamWriter, attributedElementClass);
        this.createConstraints(xMLStreamWriter, attributedElementClass);
        if (attributedElementClass instanceof VertexClass) {
            for (SpecializesVertexClass specializesVertexClass : ((VertexClass)attributedElementClass).getSpecializesVertexClassIncidences(EdgeDirection.OUT)) {
                this.createGeneralization(xMLStreamWriter, "generalization_" + attributedElementClass.get_qualifiedName(), ((VertexClass)specializesVertexClass.getThat()).get_qualifiedName());
            }
        } else if (attributedElementClass instanceof EdgeClass) {
            for (SpecializesEdgeClass specializesEdgeClass : ((EdgeClass)attributedElementClass).getSpecializesEdgeClassIncidences(EdgeDirection.OUT)) {
                this.createGeneralization(xMLStreamWriter, "generalization_" + attributedElementClass.get_qualifiedName(), ((EdgeClass)specializesEdgeClass.getThat()).get_qualifiedName());
            }
        }
        this.createAttributes(xMLStreamWriter, attributedElementClass);
        if (attributedElementClass instanceof VertexClass) {
            this.createIncidences(xMLStreamWriter, (VertexClass)attributedElementClass);
        } else if (attributedElementClass instanceof EdgeClass) {
            this.createIncidences(xMLStreamWriter, (EdgeClass)attributedElementClass);
        }
        if (!bl) {
            xMLStreamWriter.writeEndElement();
        }
    }

    private boolean hasChildIncidence(VertexClass vertexClass) {
        if (vertexClass.getFirstEndsAtIncidence() == null) {
            return false;
        }
        for (EndsAt endsAt : vertexClass.getEndsAtIncidences()) {
            IncidenceClass incidenceClass = (IncidenceClass)endsAt.getThat();
            if (!this.hasToBeCreatedAtVertex(incidenceClass)) continue;
            return true;
        }
        return false;
    }

    private boolean hasToBeCreatedAtVertex(IncidenceClass incidenceClass) {
        boolean bl;
        boolean bl2 = bl = incidenceClass.getFirstComesFromIncidence() != null;
        if (this.isBidirectional) {
            return true;
        }
        return bl;
    }

    private void createIncidences(XMLStreamWriter xMLStreamWriter, EdgeClass edgeClass) throws XMLStreamException {
        IncidenceClass incidenceClass = (IncidenceClass)edgeClass.getFirstComesFromIncidence().getThat();
        IncidenceClass incidenceClass2 = (IncidenceClass)edgeClass.getFirstGoesToIncidence().getThat();
        VertexClass vertexClass = (VertexClass)incidenceClass.getFirstEndsAtIncidence().getThat();
        VertexClass vertexClass2 = (VertexClass)incidenceClass2.getFirstEndsAtIncidence().getThat();
        if (!this.hasToBeCreatedAtVertex(incidenceClass)) {
            this.createIncidence(xMLStreamWriter, incidenceClass2, edgeClass, incidenceClass, vertexClass2, vertexClass.get_qualifiedName(), true);
        }
        if (!this.hasToBeCreatedAtVertex(incidenceClass2)) {
            this.createIncidence(xMLStreamWriter, incidenceClass, edgeClass, incidenceClass2, vertexClass, vertexClass2.get_qualifiedName(), true);
        }
    }

    private void createIncidences(XMLStreamWriter xMLStreamWriter, VertexClass vertexClass) throws XMLStreamException {
        for (EndsAt endsAt : vertexClass.getEndsAtIncidences()) {
            IncidenceClass incidenceClass = (IncidenceClass)endsAt.getThat();
            if (!this.hasToBeCreatedAtVertex(incidenceClass)) continue;
            boolean bl = incidenceClass.getFirstComesFromIncidence() != null;
            EdgeClass edgeClass = (EdgeClass)(bl ? incidenceClass.getFirstComesFromIncidence() : incidenceClass.getFirstGoesToIncidence()).getThat();
            IncidenceClass incidenceClass2 = (IncidenceClass)(bl ? edgeClass.getFirstGoesToIncidence() : edgeClass.getFirstComesFromIncidence()).getThat();
            VertexClass vertexClass2 = (VertexClass)incidenceClass2.getFirstEndsAtIncidence().getThat();
            this.createIncidence(xMLStreamWriter, incidenceClass2, edgeClass, incidenceClass, vertexClass2, vertexClass.get_qualifiedName(), false);
        }
    }

    private void createIncidence(XMLStreamWriter xMLStreamWriter, IncidenceClass incidenceClass, EdgeClass edgeClass, IncidenceClass incidenceClass2, VertexClass vertexClass, String string, boolean bl) throws XMLStreamException {
        String string2 = string + "_incidence_" + edgeClass.get_qualifiedName() + (incidenceClass2.getFirstComesFromIncidence() != null ? "_from" : "_to");
        xMLStreamWriter.writeStartElement(bl ? "ownedEnd" : "ownedAttribute");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Property");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string2);
        if (incidenceClass.get_roleName() != null && !incidenceClass.get_roleName().isEmpty()) {
            xMLStreamWriter.writeAttribute("name", incidenceClass.get_roleName());
        } else if (this.isRoleNameNecessary(edgeClass, vertexClass.get_qualifiedName())) {
            String string3 = this.createNewUniqueRoleName(vertexClass);
            xMLStreamWriter.writeAttribute("name", string3);
            incidenceClass.set_roleName(string3);
        }
        xMLStreamWriter.writeAttribute("visibility", "private");
        xMLStreamWriter.writeAttribute("type", vertexClass.get_qualifiedName());
        if (incidenceClass.get_aggregation() == AggregationKind.SHARED) {
            xMLStreamWriter.writeAttribute("aggregation", "shared");
        } else if (incidenceClass.get_aggregation() == AggregationKind.COMPOSITE) {
            xMLStreamWriter.writeAttribute("aggregation", "composite");
        }
        xMLStreamWriter.writeAttribute("association", edgeClass.get_qualifiedName());
        xMLStreamWriter.writeEmptyElement("upperValue");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralUnlimitedNatural");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string2 + "_uppervalue");
        xMLStreamWriter.writeAttribute("value", incidenceClass.get_max() == Integer.MAX_VALUE ? "*" : Integer.toString(incidenceClass.get_max()));
        xMLStreamWriter.writeEmptyElement("lowerValue");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralInteger");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string2 + "_lowervalue");
        xMLStreamWriter.writeAttribute("value", incidenceClass2.get_min() == Integer.MAX_VALUE ? "*" : Integer.toString(incidenceClass.get_min()));
        xMLStreamWriter.writeEndElement();
    }

    private String createNewUniqueRoleName(VertexClass vertexClass) {
        GreqlEnvironmentAdapter greqlEnvironmentAdapter;
        GreqlQuery greqlQuery;
        Object object;
        String string = vertexClass.get_qualifiedName().replaceAll(Pattern.quote("."), "_");
        if (Character.isUpperCase(string.charAt(0))) {
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("start", vertexClass);
        int n = 0;
        do {
            greqlQuery = GreqlQuery.createQuery("using start:exists ic:start<->{structure.SpecializesVertexClass}*<->{structure.EndsAt}<->{structure.ComesFrom,structure.GoesTo}^2@ic.roleName=\"" + string + (++n == 1 ? "" : Integer.valueOf(n)) + "\"");
            greqlEnvironmentAdapter = new GreqlEnvironmentAdapter(hashMap);
        } while ((object = greqlQuery.evaluate(vertexClass.getGraph(), greqlEnvironmentAdapter)) instanceof Boolean && ((Boolean)object).booleanValue());
        return string + (n == 1 ? "" : Integer.valueOf(n));
    }

    private boolean isRoleNameNecessary(EdgeClass edgeClass, String string) {
        if (this.isBidirectional) {
            return true;
        }
        return ((VertexClass)((IncidenceClass)edgeClass.getFirstGoesToIncidence().getThat()).getFirstEndsAtIncidence().getThat()).get_qualifiedName().equals(string);
    }

    private void createGeneralization(XMLStreamWriter xMLStreamWriter, String string, String string2) throws XMLStreamException {
        xMLStreamWriter.writeEmptyElement("generalization");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Generalization");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string);
        xMLStreamWriter.writeAttribute("general", string2);
    }

    private void createExtension(XMLStreamWriter xMLStreamWriter, NamedElement namedElement, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("http://schema.omg.org/spec/XMI/2.1", "Extension");
        xMLStreamWriter.writeAttribute("extender", "http://www.eclipse.org/emf/2002/Ecore");
        xMLStreamWriter.writeStartElement("eAnnotations");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "ecore:EAnnotation");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", namedElement != null ? namedElement.get_qualifiedName() + "_" + "eAnnotations" : "eAnnotations" + System.currentTimeMillis());
        xMLStreamWriter.writeAttribute("source", "http://www.eclipse.org/uml2/2.0.0/UML");
        if (namedElement != null) {
            xMLStreamWriter.writeEmptyElement("details");
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "ecore:EStringToStringMapEntry");
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", namedElement.get_qualifiedName() + "_" + "details");
            xMLStreamWriter.writeAttribute("key", string);
        } else {
            xMLStreamWriter.writeEmptyElement("references");
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "ecore:EPackage");
            xMLStreamWriter.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/StandardProfileL2.xmi#_yzU58YinEdqtvbnfB2L_5w");
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void createAttributes(XMLStreamWriter xMLStreamWriter, AttributedElementClass attributedElementClass) throws XMLStreamException {
        for (HasAttribute hasAttribute : attributedElementClass.getHasAttributeIncidences()) {
            Attribute attribute = (Attribute)hasAttribute.getThat();
            this.createAttribute(xMLStreamWriter, attribute.get_name(), attribute.get_defaultValue(), (Domain)attribute.getFirstHasDomainIncidence().getThat(), attributedElementClass.get_qualifiedName() + "_" + ((Attribute)hasAttribute.getThat()).get_name());
        }
    }

    private void createAttribute(XMLStreamWriter xMLStreamWriter, String string, String string2, Domain domain, String string3) throws XMLStreamException {
        boolean bl;
        boolean bl2 = bl = string2 != null && !string2.isEmpty();
        if (!(bl || domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof StringDomain)) {
            xMLStreamWriter.writeEmptyElement("ownedAttribute");
        } else {
            xMLStreamWriter.writeStartElement("ownedAttribute");
        }
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Property");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string3);
        xMLStreamWriter.writeAttribute("name", string);
        xMLStreamWriter.writeAttribute("visibility", "private");
        if (domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof StringDomain) {
            this.createType(xMLStreamWriter, domain);
        } else {
            xMLStreamWriter.writeAttribute("type", domain.get_qualifiedName().replaceAll("\\s", "").replaceAll("<", "_").replaceAll(">", "_"));
        }
        if (bl) {
            this.createDefaultValue(xMLStreamWriter, string2, string3, domain);
        }
        if (bl || domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof StringDomain) {
            xMLStreamWriter.writeEndElement();
        }
        if (domain instanceof LongDomain || domain instanceof DoubleDomain || domain instanceof CollectionDomain || domain instanceof MapDomain) {
            this.typesToBeDeclaredAtTheEnd.add(domain);
        }
    }

    private void createDefaultValue(XMLStreamWriter xMLStreamWriter, String string, String string2, Domain domain) throws XMLStreamException {
        if (domain instanceof LongDomain || domain instanceof EnumDomain) {
            xMLStreamWriter.writeEmptyElement("defaultValue");
        } else {
            xMLStreamWriter.writeStartElement("defaultValue");
        }
        if (domain instanceof BooleanDomain) {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralBoolean");
        } else if (domain instanceof IntegerDomain || domain instanceof LongDomain) {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:LiteralInteger");
        } else if (domain instanceof EnumDomain) {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:InstanceValue");
        } else {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:OpaqueExpression");
        }
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string2 + "_defaultValue");
        if (domain instanceof BooleanDomain || domain instanceof IntegerDomain || domain instanceof LongDomain || domain instanceof EnumDomain) {
            if (domain instanceof BooleanDomain) {
                xMLStreamWriter.writeAttribute("value", string.equals("t") ? "true" : "false");
            } else if (domain instanceof EnumDomain) {
                xMLStreamWriter.writeAttribute("name", string);
                xMLStreamWriter.writeAttribute("type", domain.get_qualifiedName());
                xMLStreamWriter.writeAttribute("instance", domain.get_qualifiedName() + "_" + string);
            } else {
                xMLStreamWriter.writeAttribute("value", string);
            }
            if (domain instanceof BooleanDomain || domain instanceof IntegerDomain) {
                this.createType(xMLStreamWriter, domain);
            }
        } else {
            if (domain instanceof StringDomain) {
                this.createType(xMLStreamWriter, domain);
            } else {
                xMLStreamWriter.writeAttribute("type", domain.get_qualifiedName().replaceAll("\\s", "").replaceAll("<", "_").replaceAll(">", "_"));
            }
            xMLStreamWriter.writeStartElement("body");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        if (!(domain instanceof LongDomain) && !(domain instanceof EnumDomain)) {
            xMLStreamWriter.writeEndElement();
        }
    }

    private void createType(XMLStreamWriter xMLStreamWriter, Domain domain) throws XMLStreamException {
        xMLStreamWriter.writeEmptyElement("type");
        if (domain instanceof BooleanDomain) {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            xMLStreamWriter.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/uml.xml#Boolean");
        } else if (domain instanceof IntegerDomain) {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            xMLStreamWriter.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/uml.xml#Integer");
        } else {
            xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:PrimitiveType");
            xMLStreamWriter.writeAttribute("href", "http://schema.omg.org/spec/UML/2.1.1/uml.xml#String");
        }
    }

    private void createConstraints(XMLStreamWriter xMLStreamWriter, AttributedElementClass attributedElementClass) throws XMLStreamException {
        int n = 0;
        for (HasConstraint hasConstraint : attributedElementClass.getHasConstraintIncidences()) {
            this.createConstraint(xMLStreamWriter, (Constraint)hasConstraint.getThat(), attributedElementClass.get_qualifiedName() + "_" + "ownedRule" + n++, attributedElementClass.get_qualifiedName());
        }
    }

    private void createConstraint(XMLStreamWriter xMLStreamWriter, Constraint constraint, String string, String string2) throws XMLStreamException {
        this.createConstraint(xMLStreamWriter, "\"" + constraint.get_message() + "\" \"" + constraint.get_predicateQuery() + "\" \"" + constraint.get_offendingElementsQuery() + "\"", string, string2);
    }

    private void createConstraint(XMLStreamWriter xMLStreamWriter, String string, String string2, String string3) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("ownedRule");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Constraint");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string2);
        xMLStreamWriter.writeAttribute("constrainedElement", string3);
        xMLStreamWriter.writeStartElement("specification");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:OpaqueExpression");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string2 + "_" + "specification");
        xMLStreamWriter.writeStartElement("language");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("body");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void createComments(XMLStreamWriter xMLStreamWriter, NamedElement namedElement) throws XMLStreamException {
        int n = 0;
        for (Annotates annotates : namedElement.getAnnotatesIncidences()) {
            this.createComment(xMLStreamWriter, (Comment)annotates.getThat(), namedElement.get_qualifiedName() + "_" + "ownedComment" + n++, namedElement.get_qualifiedName());
        }
    }

    private void createComment(XMLStreamWriter xMLStreamWriter, Comment comment, String string, String string2) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("ownedComment");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "type", "uml:Comment");
        xMLStreamWriter.writeAttribute("http://schema.omg.org/spec/XMI/2.1", "id", string);
        xMLStreamWriter.writeAttribute("annotatedElement", string2);
        xMLStreamWriter.writeStartElement("body");
        xMLStreamWriter.writeCharacters("<p>\r\n\t" + comment.get_text().replaceAll(Pattern.quote("\n"), "\r\n</p>\r\n<p>\r\n\t") + "\r\n</p>");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private String extractSimpleName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }
}

