/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.ElementDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.TypeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GraphLayout {
    Map<VertexClass, TypeDefinition> vertexTypeDefinitions;
    Map<EdgeClass, TypeDefinition> edgeTypeDefinitions;
    List<ElementDefinition> elementDefinitions;
    Collection<AttributedElement<?, ?>> attributedElementsDefinedByElementDefinitions;
    Map<String, String> globalVariables;
    private Schema schema;

    public GraphLayout() {
        this.initiateDataStructures();
    }

    private void initiateDataStructures() {
        this.vertexTypeDefinitions = new HashMap<VertexClass, TypeDefinition>();
        this.edgeTypeDefinitions = new HashMap<EdgeClass, TypeDefinition>();
        this.elementDefinitions = new ArrayList<ElementDefinition>();
        this.attributedElementsDefinedByElementDefinitions = new HashSet();
        this.globalVariables = new HashMap<String, String>();
    }

    void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Map<VertexClass, TypeDefinition> getVertexTypeDefinitions() {
        return this.vertexTypeDefinitions;
    }

    public Map<EdgeClass, TypeDefinition> getEdgeTypeDefinitions() {
        return this.edgeTypeDefinitions;
    }

    public List<ElementDefinition> getElementDefinitions() {
        return this.elementDefinitions;
    }

    public Collection<AttributedElement<?, ?>> getAttributedElementsDefinedByElementDefinitions() {
        return this.attributedElementsDefinedByElementDefinitions;
    }

    public TypeDefinition getTypeDefinition(AttributedElement<?, ?> attributedElement) {
        return this.getTypeDefinition((AttributedElementClass<?, ?>)attributedElement.getAttributedElementClass());
    }

    public TypeDefinition getTypeDefinition(String string) {
        if (string.compareTo("Vertex") == 0) {
            return this.getTypeDefinition(this.schema.getGraphClass().getDefaultVertexClass());
        }
        if (string.compareTo("Edge") == 0) {
            return this.getTypeDefinition(this.schema.getGraphClass().getDefaultEdgeClass());
        }
        return this.getTypeDefinition((AttributedElementClass<?, ?>)this.schema.getAttributedElementClass(string));
    }

    public TypeDefinition getTypeDefinition(AttributedElementClass<?, ?> attributedElementClass) {
        TypeDefinition typeDefinition = this.vertexTypeDefinitions.get(attributedElementClass);
        if (typeDefinition == null) {
            typeDefinition = this.edgeTypeDefinitions.get(attributedElementClass);
        }
        return typeDefinition;
    }

    public TypeDefinition getTypeDefinition(Vertex vertex) {
        return this.vertexTypeDefinitions.get(vertex.getAttributedElementClass());
    }

    public TypeDefinition getTypeDefinition(Edge edge) {
        return this.edgeTypeDefinitions.get(edge.getAttributedElementClass());
    }

    public Map<String, String> getGlobalVariables() {
        return this.globalVariables;
    }

    void initiateAllTypeDefinitions() {
        VertexClass vertexClass = this.schema.getGraphClass().getDefaultVertexClass();
        this.vertexTypeDefinitions.put(vertexClass, new TypeDefinition(vertexClass));
        for (VertexClass object : this.schema.getGraphClass().getVertexClasses()) {
            this.vertexTypeDefinitions.put(object, new TypeDefinition(object));
        }
        EdgeClass edgeClass = this.schema.getGraphClass().getDefaultEdgeClass();
        this.edgeTypeDefinitions.put(edgeClass, new TypeDefinition(edgeClass));
        for (EdgeClass edgeClass2 : this.schema.getGraphClass().getEdgeClasses()) {
            this.edgeTypeDefinitions.put(edgeClass2, new TypeDefinition(edgeClass2));
        }
    }

    public void add(Definition definition) {
        if (definition instanceof TypeDefinition) {
            this.add((TypeDefinition)definition);
        } else if (definition instanceof ElementDefinition) {
            this.add((ElementDefinition)definition);
        } else {
            throw new RuntimeException("This shouldn'd have happend!");
        }
    }

    private void add(TypeDefinition typeDefinition) {
        TypeDefinition typeDefinition2 = this.getTypeDefinition(typeDefinition.getTypeClass());
        typeDefinition2.overwriteAttributes(typeDefinition);
    }

    private void add(ElementDefinition elementDefinition) {
        this.elementDefinitions.add(elementDefinition);
    }

    public boolean isDefinedbyElementDefinitions(AttributedElement<?, ?> attributedElement) {
        return this.attributedElementsDefinedByElementDefinitions.contains(attributedElement);
    }

    public void setGlobalVariables(Map<String, String> map) {
        this.globalVariables = map;
    }
}

