/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.ElementDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.TypeDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.GraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import java.util.Collection;

public abstract class AbstractGraphLayoutReader
implements GraphLayoutReader {
    protected GraphLayout graphLayout;
    protected Definition currentDefinition;
    private GreqlEvaluatorFacade evaluator;

    public AbstractGraphLayoutReader(GreqlEvaluatorFacade greqlEvaluatorFacade) {
        this.evaluator = greqlEvaluatorFacade;
        this.initilizeStates();
    }

    protected void initilizeStates() {
    }

    protected void definitionStarted(String string) {
        TypeDefinition typeDefinition = null;
        typeDefinition = this.graphLayout.getTypeDefinition(string);
        this.currentDefinition = typeDefinition;
        if (typeDefinition == null && this.isElementDefinition(string)) {
            this.currentDefinition = new ElementDefinition(string);
            this.graphLayout.add(this.currentDefinition);
        }
    }

    private boolean isElementDefinition(String string) {
        return this.containsGraphElements(this.evaluator.evaluate(string));
    }

    private boolean containsGraphElements(Object object) {
        if (object instanceof GraphElement) {
            return true;
        }
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                if (!(e instanceof GraphElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected void definitionEnded() {
        this.currentDefinition = null;
    }

    protected boolean isGlobalVariable(String string) {
        return string.charAt(0) == '@';
    }

    public void processGlobalVariable(String string, String string2) {
        if (!this.isGlobalVariable(string)) {
            throw new RuntimeException("Field " + string + " does not have a '@' as prefix. Delete it or add an @.");
        }
        this.graphLayout.getGlobalVariables().put(this.removeFirstChar(string), string2);
    }

    public void processDefinitionAttribute(String string, String string2) {
        this.currentDefinition.setAttribute(string, string2);
    }

    private String removeFirstChar(String string) {
        return string.substring(1, string.length());
    }
}

