/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.PSet;

public class SchemaVisualizer {
    public void createSchemaRepresentation(StringBuilder stringBuilder, StateRepository.State state) {
        this.createAttributedElementClassRepresentation(stringBuilder, state, true);
        this.createAttributedElementClassRepresentation(stringBuilder, state, false);
        this.createPackageRepresentation(stringBuilder, state);
    }

    private void createPackageRepresentation(StringBuilder stringBuilder, StateRepository.State state) {
        Package package_ = state.getGraph().getSchema().getDefaultPackage();
        stringBuilder.append("var divPackage = document.getElementById(\"divPackage\");\n");
        stringBuilder.append("var ulRootPackage = document.createElement(\"ul\");\n");
        stringBuilder.append("ulRootPackage.id = \"ulRootPackage\";\n");
        stringBuilder.append("divPackage.appendChild(ulRootPackage);\n");
        this.createEntriesForPackage(stringBuilder, "ulRootPackage", package_, true, state.getGraph().getSchema().getGraphClass().getVertexClasses(), state.getGraph().getSchema().getGraphClass().getEdgeClasses());
    }

    private void createEntriesForPackage(StringBuilder stringBuilder, String string, Package package_, boolean bl, List<VertexClass> list, List<EdgeClass> list2) {
        ArrayList<EdgeClass> arrayList;
        Object object;
        boolean bl2;
        Iterator iterator;
        String string2 = bl ? "defaultPackage" : package_.getSimpleName();
        String string3 = bl ? "defaultPackage" : this.replaceDollar(package_.getUniqueName().replaceAll(Pattern.quote("."), "__"));
        String string4 = bl ? "defaultPackage" : package_.getQualifiedName();
        String string5 = "";
        String string6 = "";
        for (VertexClass object22 : list) {
            if (object22.getQualifiedName().equals("Vertex")) continue;
            iterator = object22.getDirectSuperClasses().iterator();
            bl2 = false;
            while (iterator.hasNext() && !bl2) {
                object = (VertexClass)iterator.next();
                if (object.getQualifiedName().equals("Vertex")) continue;
                bl2 |= list.contains(object);
            }
            if (bl2) continue;
            object = this.replaceDollar(object22.getUniqueName());
            arrayList = "";
            arrayList = (String)((Object)arrayList) + "var checkbox" + (String)object + " = document.getElementById(\"input" + (String)object + "\");\n";
            arrayList = (String)((Object)arrayList) + "checkbox" + (String)object + ".checked = !checkbox" + (String)object + ".checked;\n";
            arrayList = (String)((Object)arrayList) + "deSelect(\"" + (String)object + "\",\"input" + string3 + "\");\n";
            if (object22.getPackage() == package_) {
                string6 = string6 + (String)((Object)arrayList);
            }
            string5 = string5 + (String)((Object)arrayList);
        }
        for (EdgeClass edgeClass : list2) {
            if (edgeClass.getQualifiedName().equals("Edge") || edgeClass.getQualifiedName().equals("Aggregation") || edgeClass.getQualifiedName().equals("Composition")) continue;
            iterator = edgeClass.getDirectSuperClasses().iterator();
            bl2 = false;
            while (iterator.hasNext() && !bl2) {
                object = (EdgeClass)iterator.next();
                if (object.getQualifiedName().equals("Edge") || object.getQualifiedName().equals("Aggregation") || object.getQualifiedName().equals("Composition")) continue;
                bl2 |= list2.contains(object);
            }
            if (bl2) continue;
            object = this.replaceDollar(edgeClass.getUniqueName());
            arrayList = "";
            arrayList = (String)((Object)arrayList) + "var checkbox" + (String)object + " = document.getElementById(\"input" + (String)object + "\");\n";
            arrayList = (String)((Object)arrayList) + "checkbox" + (String)object + ".checked = !checkbox" + (String)object + ".checked;\n";
            arrayList = (String)((Object)arrayList) + "deSelect(\"" + (String)object + "\",\"input" + string3 + "\");\n";
            if (edgeClass.getPackage() == package_) {
                string6 = string6 + arrayList;
            }
            string5 = string5 + arrayList;
        }
        Object object3 = "if(document.getElementById(\"checkSelectAll\").checked){\n";
        object3 = (String)object3 + string5;
        object3 = (String)object3 + "}else{\n";
        object3 = (String)object3 + string6;
        object3 = (String)object3 + "}\n";
        this.createLi(stringBuilder, string, string3, string2);
        this.createCheckBox(stringBuilder, string3, string4, (String)object3);
        this.createP(stringBuilder, string2, string3, string4, false, null);
        PSet<Package> pSet = package_.getSubPackages();
        if (!pSet.isEmpty()) {
            this.convertToTypeWithSubtypes(stringBuilder, string3);
            for (Package package_2 : pSet) {
                object = new ArrayList<VertexClass>();
                for (VertexClass vertexClass : list) {
                    if (!vertexClass.getQualifiedName().startsWith(package_2.getQualifiedName())) continue;
                    ((ArrayList)object).add(vertexClass);
                }
                arrayList = new ArrayList<EdgeClass>();
                for (EdgeClass edgeClass : list2) {
                    if (!edgeClass.getQualifiedName().startsWith(package_2.getQualifiedName())) continue;
                    arrayList.add(edgeClass);
                }
                this.createEntriesForPackage(stringBuilder, "ul" + string3, package_2, false, (List<VertexClass>)object, (List<EdgeClass>)arrayList);
            }
        }
    }

    private String replaceDollar(String string) {
        return Pattern.compile(Matcher.quoteReplacement("$")).matcher(string).replaceAll(Matcher.quoteReplacement(""));
    }

    private void createAttributedElementClassRepresentation(StringBuilder stringBuilder, StateRepository.State state, boolean bl) {
        Object object;
        Object object2;
        assert (state != null) : "state is null";
        assert (state.getGraph() != null) : "graph is null";
        assert (state.getGraph().getSchema() != null) : "schema is null";
        List<GraphElementClass<VertexClass, Vertex>> list = bl ? state.getGraph().getSchema().getGraphClass().getVertexClasses() : state.getGraph().getSchema().getGraphClass().getEdgeClasses();
        String string = bl ? "Vertex" : "Edge";
        this.createRootUl(stringBuilder, string);
        ArrayList<GraphElementClass<VertexClass, Vertex>> arrayList = new ArrayList<GraphElementClass<VertexClass, Vertex>>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (GraphElementClass<VertexClass, Vertex> attributedElementClass : list) {
            if (bl) {
                state.selectedVertexClasses.put((VertexClass)attributedElementClass, true);
            } else {
                state.selectedEdgeClasses.put((EdgeClass)attributedElementClass, true);
            }
            PSet<VertexClass> pSet = attributedElementClass.getDirectSuperClasses();
            object2 = "";
            object = pSet.iterator();
            if (object.hasNext()) {
                GraphElementClass graphElementClass = (GraphElementClass)object.next();
                while ((graphElementClass.getQualifiedName().equals("Vertex") || graphElementClass.getQualifiedName().equals("Edge") || graphElementClass.getQualifiedName().equals("Aggregation") || graphElementClass.getQualifiedName().equals("Composition")) && object.hasNext()) {
                    graphElementClass = (GraphElementClass)object.next();
                }
                if (graphElementClass.getQualifiedName().equals("Vertex") || graphElementClass.getQualifiedName().equals("Edge") || graphElementClass.getQualifiedName().equals("Aggregation") || graphElementClass.getQualifiedName().equals("Composition")) {
                    object2 = "Root" + string;
                } else {
                    object2 = this.replaceDollar(graphElementClass.getUniqueName());
                    if (object.hasNext()) {
                        arrayList.add(attributedElementClass);
                        arrayList2.add(object);
                    }
                }
            } else {
                object2 = "Root" + string;
            }
            this.createLi(stringBuilder, "ul" + (String)object2, this.replaceDollar(attributedElementClass.getUniqueName()), attributedElementClass.getSimpleName());
            this.createCheckBox(stringBuilder, this.replaceDollar(attributedElementClass.getUniqueName()), attributedElementClass.getQualifiedName(), "");
            this.createP(stringBuilder, attributedElementClass.getSimpleName(), this.replaceDollar(attributedElementClass.getUniqueName()), attributedElementClass.getQualifiedName(), attributedElementClass.isAbstract(), attributedElementClass.getAttributeList());
            if (attributedElementClass.getDirectSubClasses().size() <= 0) continue;
            this.convertToTypeWithSubtypes(stringBuilder, this.replaceDollar(attributedElementClass.getUniqueName()));
        }
        if (!arrayList2.isEmpty()) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                AttributedElementClass attributedElementClass = (AttributedElementClass)arrayList.get(i);
                int n = 0;
                while (((Iterator)arrayList2.get(i)).hasNext()) {
                    object2 = (AttributedElementClass)((Iterator)arrayList2.get(i)).next();
                    object = this.replaceDollar(object2.getUniqueName());
                    if (state.getGraph().getSchema().getAttributedElementClass("Aggregation") != object2 && state.getGraph().getSchema().getAttributedElementClass("Composition") != object2) {
                        this.cloneType(stringBuilder, attributedElementClass, n, (String)object);
                        this.adaptClone(stringBuilder, attributedElementClass, n);
                    }
                    ++n;
                }
            }
        }
    }

    private void cloneType(StringBuilder stringBuilder, AttributedElementClass<?, ?> attributedElementClass, int n, String string) {
        String string2 = this.replaceDollar(attributedElementClass.getUniqueName());
        stringBuilder.append("var li").append(string2).append("_").append(n).append(" = li").append(string2).append(".cloneNode(true);\n");
        stringBuilder.append("insertSorted(li").append(string2).append("_").append(n).append(", '").append(attributedElementClass.getSimpleName()).append("', ul").append(string).append(", 0, (ul").append(string).append(".childNodes && ul").append(string).append(".childNodes.length>0)?ul").append(string).append(".childNodes.length-1:0);\n");
    }

    private void adaptClone(StringBuilder stringBuilder, AttributedElementClass<?, ?> attributedElementClass, int n) {
        String string = this.replaceDollar(attributedElementClass.getUniqueName());
        stringBuilder.append("var findFreeNumber = function(prefix){\n");
        stringBuilder.append("var sufcnt=0;\n");
        stringBuilder.append("while(document.getElementById(prefix+\":\"+sufcnt)){\n");
        stringBuilder.append("sufcnt++;\n");
        stringBuilder.append("}\n;");
        stringBuilder.append("return sufcnt;\n");
        stringBuilder.append("}\n;");
        stringBuilder.append("var baseName = li").append(string).append("_").append(n).append(".id.substr(2);\n");
        stringBuilder.append("li").append(string).append("_").append(n).append(".id = \"li\"+baseName+\":\"").append(" + findFreeNumber(\"li\"+baseName);\n");
        stringBuilder.append("var li").append(string).append("_").append(n).append("ulChildren = li").append(string).append("_").append(n).append(".getElementsByTagName(\"ul\");\n");
        stringBuilder.append("for (var i=0; i<li").append(string).append("_").append(n).append("ulChildren.length;i++){\n");
        stringBuilder.append("var baseName = li").append(string).append("_").append(n).append("ulChildren[i].parentNode.childNodes[1].name.substr(5);\n");
        stringBuilder.append("li").append(string).append("_").append(n).append("ulChildren[i].id = \"ul\"+baseName+\":\"").append(" + findFreeNumber(\"ul\"+baseName);\n");
        stringBuilder.append("}\n");
        stringBuilder.append("var li").append(string).append("_").append(n).append("liChildren = li").append(string).append("_").append(n).append(".getElementsByTagName(\"li\");\n");
        stringBuilder.append("for (var i=0; i<li").append(string).append("_").append(n).append("liChildren.length;i++){\n");
        stringBuilder.append("var baseName = li").append(string).append("_").append(n).append("liChildren[i].childNodes[1].name.substr(5);\n");
        stringBuilder.append("li").append(string).append("_").append(n).append("liChildren[i].id = \"li\"+baseName+\":\" ").append("+ findFreeNumber(\"li\"+baseName);\n");
        stringBuilder.append("}\n");
        stringBuilder.append("var li").append(string).append("_").append(n).append("aChildren = li").append(string).append("_").append(n).append(".getElementsByTagName(\"a\");\n");
        stringBuilder.append("for (var i=0; i<li").append(string).append("_").append(n).append("aChildren.length;i++){\n");
        stringBuilder.append("var baseName = li").append(string).append("_").append(n).append("aChildren[i].parentNode.childNodes[1].name.substr(5);\n");
        stringBuilder.append("var baseName = baseName+\":\"+findFreeNumber(\"a\"+baseName);\n");
        stringBuilder.append("li").append(string).append("_").append(n).append("aChildren[i].id = \"a\"+baseName;\n");
        stringBuilder.append("li").append(string).append("_").append(n).append("aChildren[i].href =").append(" \"javascript:expand('ul\"+baseName+\"','a\"+baseName+\"');\";\n");
        stringBuilder.append("}\n");
        stringBuilder.append("var li").append(string).append("_").append(n).append("inputChildren = li").append(string).append("_").append(n).append(".getElementsByTagName(\"input\");\n");
        stringBuilder.append("for (var i=0; i<li").append(string).append("_").append(n).append("inputChildren.length;i++){\n");
        stringBuilder.append("var baseName = li").append(string).append("_").append(n).append("inputChildren[i].name.substr(5);\n");
        stringBuilder.append("li").append(string).append("_").append(n).append("inputChildren[i].id = \"input\"+baseName+\":\"").append(" + findFreeNumber(\"input\"+baseName);\n");
        stringBuilder.append("li").append(string).append("_").append(n).append("inputChildren[i].onclick = function(){").append("deSelect(this.value.substr(this.value.lastIndexOf('.')+1),this.id);\n").append("submitDeselectedTypes();\n};\n");
        stringBuilder.append("li").append(string).append("_").append(n).append("inputChildren[i].checked = true;\n");
        stringBuilder.append("}\n");
    }

    private void createRootUl(StringBuilder stringBuilder, String string) {
        stringBuilder.append("var div").append(string).append("Class = document.getElementById(\"div").append(string).append("Class\");\n");
        stringBuilder.append("var ulRoot").append(string).append(" = document.createElement(\"ul\");\n");
        stringBuilder.append("ulRoot").append(string).append(".id = \"ulRoot").append(string).append("\";\n");
        stringBuilder.append("div").append(string).append("Class.appendChild(ulRoot").append(string).append(");\n");
    }

    private void convertToTypeWithSubtypes(StringBuilder stringBuilder, String string) {
        stringBuilder.append("var a").append(string).append(" = document.createElement(\"a\");\n");
        stringBuilder.append("a").append(string).append(".id = \"a").append(string).append("\";\n");
        stringBuilder.append("a").append(string).append(".href = \"javascript:expand('ul").append(string).append("','a").append(string).append("');\";\n");
        stringBuilder.append("var img").append(string).append(" = document.createElement(\"img\");\n");
        stringBuilder.append("img").append(string).append(".src = \"plus.png\";\n");
        stringBuilder.append("img").append(string).append(".alt = \"+\";\n");
        stringBuilder.append("a").append(string).append(".appendChild(img").append(string).append(");\n");
        stringBuilder.append("var ul").append(string).append(" = document.createElement(\"ul\");\n");
        stringBuilder.append("ul").append(string).append(".id = \"ul").append(string).append("\";\n");
        stringBuilder.append("li").append(string).append(".appendChild(ul").append(string).append(");\n");
        stringBuilder.append("li").append(string).append(".replaceChild(a").append(string).append(",ws").append(string).append(");\n");
    }

    private void createP(StringBuilder stringBuilder, String string, String string2, String string3, boolean bl, List<Attribute> list) {
        StringBuilder stringBuilder2 = new StringBuilder(string3);
        if (list != null) {
            if (!list.isEmpty()) {
                stringBuilder2.append(":");
            }
            for (Attribute attribute : list) {
                stringBuilder2.append("    ").append(attribute.getDomain().getQualifiedName()).append(" ").append(attribute.getName()).append(";");
            }
        }
        stringBuilder.append("var p").append(string2).append(" = document.createElement(\"p\");\n");
        stringBuilder.append("p").append(string2).append(".title = \"").append((CharSequence)stringBuilder2).append("\";\n");
        stringBuilder.append("p").append(string2).append(".innerHTML = \"").append(bl ? "<i>" : "").append(string).append(bl ? "</i>" : "").append("\";\n");
        stringBuilder.append("li").append(string2).append(".appendChild(p").append(string2).append(");\n");
    }

    private void createCheckBox(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append("var input").append(string).append(";\n");
        stringBuilder.append("if(navigator.appName == \"Microsoft Internet Explorer\" && navigator.appVersion.indexOf(\"MSIE 7.\")!=-1){\n");
        stringBuilder.append("input").append(string).append(" = document.createElement('<input checked=\"checked\" />');\n");
        stringBuilder.append("} else {\n");
        stringBuilder.append("input").append(string).append(" = document.createElement(\"input\");\n");
        stringBuilder.append("}\n");
        stringBuilder.append("input").append(string).append(".checked = true;\n");
        stringBuilder.append("input").append(string).append(".id = \"input").append(string).append("\";\n");
        stringBuilder.append("input").append(string).append(".type = \"checkbox\";\n");
        stringBuilder.append("input").append(string).append(".name = \"input").append(string).append("\";\n");
        stringBuilder.append("input").append(string).append(".value = \"").append(string2).append("\";\n");
        stringBuilder.append("li").append(string).append(".appendChild(input").append(string).append(");\n");
        stringBuilder.append("input").append(string).append(".onclick = function(){\n").append(string3).append("deSelect('").append(string).append("',this.id);\n").append("submitDeselectedTypes();\n").append("};\n");
    }

    private void createLi(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append("var li").append(string2).append(" = document.createElement(\"li\");\n");
        stringBuilder.append("li").append(string2).append(".id = \"li").append(string2).append("\";\n");
        stringBuilder.append("insertSorted(li").append(string2).append(", '").append(string3).append("', ").append(string).append(", 0, (").append(string).append(".childNodes && ").append(string).append(".childNodes.length>0)?").append(string).append(".childNodes.length-1:0);\n");
        stringBuilder.append("var ws").append(string2).append(" = document.createElement(\"span\");\n");
        stringBuilder.append("ws").append(string2).append(".style.border = \"none\";\n");
        stringBuilder.append("ws").append(string2).append(".style.paddingRight = \"1em\";\n");
        stringBuilder.append("ws").append(string2).append(".style.marginRight = \"0.2em\";\n");
        stringBuilder.append("ws").append(string2).append(".style.visibility = \"hidden\";\n");
        stringBuilder.append("li").append(string2).append(".appendChild(ws").append(string2).append(");\n");
    }
}

