/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.RequestThread;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TabularVisualizer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TwoDVisualizer;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class TGraphBrowserServer
extends Thread {
    private static final String[] versionInfo;
    private static final String[] copyrightInfo;
    public static Logger logger;
    public static long starttime;
    public static final String VERSION = "SimpleWebServer  http://www.jibble.org/";
    private static final int DEFAULT_PORT = 8080;
    private String workspace;
    private final ServerSocket _serverSocket;
    private final boolean _running = true;

    public TGraphBrowserServer(int n, String string, String string2, String string3) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        this.workspace = string;
        if (string != null && (this.workspace.startsWith("\"") || this.workspace.startsWith("'"))) {
            this.workspace = this.workspace.substring(1, this.workspace.length() - 1);
        }
        StateRepository.MAXIMUM_FILE_SIZE = string2 == null ? null : Long.valueOf(Long.parseLong(string2) * 1024L * 1024L);
        File file = new File(this.workspace);
        StateRepository.MAXIMUM_WORKSPACE_SIZE = string3 == null ? file.getFreeSpace() + file.getTotalSpace() : Long.parseLong(string3) * 1024L * 1024L;
        this._serverSocket = new ServerSocket(n);
    }

    @Override
    public void run() {
        System.out.println(this.getClass().getSimpleName() + " is running on port " + this._serverSocket.getLocalPort());
        System.out.println("The current workspace is: " + this.workspace);
        System.out.println("Press CTRL + C to quit.");
        while (true) {
            try {
                while (true) {
                    Socket socket = this._serverSocket.accept();
                    RequestThread requestThread = new RequestThread(socket, this.workspace);
                    requestThread.start();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.interrupt();
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        CommandLine commandLine = TGraphBrowserServer.processCommandLineOptions(stringArray);
        assert (commandLine != null);
        try {
            Object object;
            String string;
            starttime = System.currentTimeMillis();
            String string2 = commandLine.getOptionValue("p");
            if (commandLine.hasOption("r")) {
                TwoDVisualizer.PRINT_ROLE_NAMES = true;
            }
            if (commandLine.hasOption("w")) {
                string = commandLine.getOptionValue("w");
            } else {
                object = new File(System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser");
                if (!((File)object).exists() && !((File)object).mkdir()) {
                    logger.info("The temp folder " + ((File)object).getAbsolutePath() + " could not be created.");
                }
                if (!((File)(object = new File(((File)object).getAbsoluteFile() + File.separator + "workspace"))).exists() && !((File)object).mkdir()) {
                    logger.info("The default workspace " + ((File)object).getAbsolutePath() + " could not be created.");
                }
                string = ((File)object).getAbsolutePath();
            }
            new TGraphBrowserServer(string2 == null ? 8080 : Integer.parseInt(string2), string, commandLine.getOptionValue("m"), commandLine.getOptionValue("s")).start();
            if (commandLine.getOptionValue("ic") != null) {
                TabularVisualizer.NUMBER_OF_INCIDENCES_PER_PAGE = Math.max(Integer.parseInt(commandLine.getOptionValue("ic")), 1);
            }
            if (commandLine.hasOption("d")) {
                StateRepository.dot = commandLine.getOptionValue("d");
            } else {
                System.out.println("The 2D-Visualization is disabled because parameter -d is not set.");
            }
            object = commandLine.getOptionValue("t");
            String string3 = commandLine.getOptionValue("i");
            new DeleteUnusedStates(object == null ? 600L : (long)Integer.parseInt((String)object), string3 == null ? 60L : (long)Integer.parseInt(string3)).start();
            if (commandLine.hasOption("td")) {
                TwoDVisualizer.SECONDS_TO_WAIT_FOR_DOT = Integer.parseInt(commandLine.getOptionValue("td"));
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + TGraphBrowserServer.class.getName();
        String string2 = TGraphBrowserServer.getInfo();
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("w", "workspace", true, "(optional): the workspace. Default is $temp$/tgraphbrowser/workspace");
        option.setRequired(false);
        option.setArgName("path");
        optionHandler.addOption(option);
        Option option2 = new Option("t", "state_timeout", true, "(optional): resources are freed, if they were not used in the last <given> seconds. Default value is 600 sec.");
        option2.setRequired(false);
        option2.setArgName("sec");
        optionHandler.addOption(option2);
        Option option3 = new Option("ci", "check_interval", true, "(optional): the interval in sec after which the states are checked, if thex are to old. Default value is 60 sec.");
        option3.setRequired(false);
        option3.setArgName("sec");
        optionHandler.addOption(option3);
        Option option4 = new Option("td", "time_for_dot", true, "(optional): the interval in sec after which the execution of dot is aborted. Default value is 60 sec.");
        option4.setRequired(false);
        option4.setArgName("sec");
        optionHandler.addOption(option4);
        Option option5 = new Option("p", "port", true, "(optional): the port of the server. Default is port 8080.");
        option5.setRequired(false);
        option5.setArgName("portnumber");
        optionHandler.addOption(option5);
        Option option6 = new Option("i", "incidences", true, "(optional): number of incident edges which are shown in the table view. Default is 10.");
        option6.setRequired(false);
        option6.setArgName("int");
        optionHandler.addOption(option6);
        Option option7 = new Option("d", "dot", true, "(optional): the command to call dot. If it is not set, the 2D-view won't be available.");
        option7.setRequired(false);
        option7.setArgName("command");
        optionHandler.addOption(option7);
        Option option8 = new Option("m", "maximum_filesize", true, "(optional): the maximum size of a tg-file which is loaded in MB");
        option8.setRequired(false);
        option8.setArgName("int");
        optionHandler.addOption(option8);
        Option option9 = new Option("s", "size_of_workspace", true, "(optional): the maximum size of the workspace in MB. Newly submitted tg.-files are rejected, if maximumSizeOfWorkspace < currentSizeOfWorkspace + sizeOfSubmittedTgFile ");
        option9.setRequired(false);
        option9.setArgName("int");
        optionHandler.addOption(option9);
        Option option10 = new Option("r", "print-role-names", false, "(optional): Print role names in the 2D view.  Defaults to false.");
        option10.setRequired(false);
        optionHandler.addOption(option10);
        return optionHandler.parse(stringArray);
    }

    public static String getInfo() {
        String[] stringArray = new String[versionInfo.length + copyrightInfo.length];
        System.arraycopy(versionInfo, 0, stringArray, 0, versionInfo.length);
        System.arraycopy(copyrightInfo, 0, stringArray, versionInfo.length, copyrightInfo.length);
        return TGraphBrowserServer.getInfoString(stringArray);
    }

    private static String getInfoString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    static {
        File file;
        versionInfo = new String[]{"TGraphBrowser", "  Version : 1.0"};
        copyrightInfo = new String[]{"(c) 2006-2011 Institute for Software Technology", "              University of Koblenz-Landau, Germany", "", "              ist@uni-koblenz.de", "", "Please report bugs to http://helena.uni-koblenz.de/redmine", "", "This program is free software; you can redistribute it and/or", "modify it under the terms of the GNU General Public License", "as published by the Free Software Foundation; either version 2", "of the License, or (at your option) any later version.", "", "This program is distributed in the hope that it will be useful,", "but WITHOUT ANY WARRANTY; without even the implied warranty of", "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the", "GNU General Public License for more details.", "", "You should have received a copy of the GNU General Public License", "along with this program; if not, write to the Free Software", "Foundation Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.", "", "This software uses:", "", "JGraLab Efraasia", "(c) 2006-2011 Institute for Software Technology", "              University of Koblenz-Landau, Germany", "", "              ist@uni-koblenz.de", "", "Apache Commons CLI 1.2", "Copyright 2001-2009 The Apache Software Foundation"};
        logger = JGraLab.getRootLogger();
        Handler handler = logger.getHandlers()[0];
        logger.removeHandler(handler);
        Formatter formatter = handler.getFormatter();
        String string = System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser";
        File file2 = new File(string);
        if (!file2.exists() && !file2.mkdir()) {
            logger.warning(file2 + " could not be created.");
        }
        if (!(file = new File(string = string + File.separator + "logs")).exists() && !file.mkdir()) {
            logger.warning(file.toString() + " could not be created");
        }
        try {
            string = string + File.separator + "Logging.txt";
            handler = new FileHandler(string);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        handler.setFormatter(formatter);
        logger.addHandler(handler);
        logger.setLevel(Level.INFO);
    }

    static class DeleteUnusedStates
    extends Thread {
        public static long timeout;
        private final long checkInterval;

        public DeleteUnusedStates(long l, long l2) {
            timeout = l * 1000L;
            this.checkInterval = l2 * 1000L;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        DeleteUnusedStates.sleep(this.checkInterval);
                        StateRepository.deleteAllUnusedSessions(timeout);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

