/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.InternalAttributedElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.PSet;

public class TabularVisualizer {
    static int NUMBER_OF_INCIDENCES_PER_PAGE = 10;

    public void calculateVertexListAndEdgeList(StateRepository.State state, PSet<GraphElement<?, ?>> pSet) {
        ArrayList<GraphElement<VertexClass, Vertex>> arrayList = new ArrayList<GraphElement<VertexClass, Vertex>>();
        ArrayList<GraphElement<VertexClass, Vertex>> arrayList2 = new ArrayList<GraphElement<VertexClass, Vertex>>();
        for (GraphElement graphElement : pSet) {
            GraphElement<VertexClass, Vertex> graphElement2;
            if (graphElement instanceof Vertex) {
                graphElement2 = (Vertex)graphElement;
                if (!state.selectedVertexClasses.get(graphElement2.getAttributedElementClass()).booleanValue()) continue;
                arrayList.add(graphElement2);
                continue;
            }
            graphElement2 = (Edge)graphElement;
            if (!state.selectedEdgeClasses.get(graphElement2.getAttributedElementClass()).booleanValue()) continue;
            arrayList2.add(graphElement2);
        }
        state.verticesOfTableView = arrayList.isEmpty() ? null : arrayList.toArray(new Vertex[0]);
        state.edgesOfTableView = arrayList2.isEmpty() ? null : arrayList2.toArray(new Edge[0]);
    }

    public void calculateVertexListAndEdgeList(StateRepository.State state) {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("V").append((CharSequence)state.getVertexTypeSet());
        PSet pSet = (PSet)StateRepository.evaluateGReQL(stringBuilder.toString(), state.getGraph(), null);
        state.verticesOfTableView = new Vertex[pSet.size()];
        int n = 0;
        for (Object object2 : pSet) {
            state.verticesOfTableView[n++] = object2;
        }
        stringBuilder = new StringBuilder("E");
        stringBuilder.append((CharSequence)state.getEdgeTypeSet());
        PSet pSet2 = (PSet)StateRepository.evaluateGReQL(stringBuilder.toString(), state.getGraph(), null);
        state.edgesOfTableView = new Edge[pSet2.size()];
        n = 0;
        object2 = pSet2.iterator();
        while (object2.hasNext()) {
            Edge edge = (Edge)object2.next();
            state.edgesOfTableView[n++] = edge;
        }
    }

    public void visualizeElements(StringBuilder stringBuilder, StateRepository.State state, int n, boolean bl, String string, boolean bl2, boolean bl3) {
        int n2;
        boolean bl4 = string.startsWith("v");
        stringBuilder.append("current").append(string.charAt(0) == 'v' ? "Vertex" : "Edge").append(" = \"").append(string).append("\";\n");
        stringBuilder.append("var parent = document.getElementById(\"divText").append(string.charAt(0) == 'v' ? "Vertex" : "Edge").append("\");\nparent.innerHTML = \"\";\n");
        if ((bl4 ? state.getGraph().getVCount() : state.getGraph().getECount()) == 0) {
            stringBuilder.append("var divText = document.getElementById(\"divText").append(bl4 ? "Vertex" : "Edge").append("\");\n");
            stringBuilder.append("var h1=document.createElement(\"h1\");\n");
            stringBuilder.append("h1.innerHTML = \"This graph doesn't have any ").append(bl4 ? "vertices" : "edges").append(".\";\n");
            stringBuilder.append("divText.appendChild(h1);\n");
            return;
        }
        stringBuilder.append("document.getElementById(\"h3HowManyElements\").style.display = \"none\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyVertices\").style.display = areVerticesShown() ? \"block\" : \"none\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyEdges\").style.display = areVerticesShown() ? \"none\" : \"block\";\n");
        stringBuilder.append("document.getElementById(\"h3").append(bl4 ? "HowManyVertices" : "HowManyEdges").append("\").innerHTML = \"").append(bl4 ? (state.verticesOfTableView == null ? 0 : state.verticesOfTableView.length) + " of " + state.getGraph().getVCount() + " vertices" : (state.edgesOfTableView == null ? 0 : state.edgesOfTableView.length) + " of " + state.getGraph().getECount() + " edges").append(" visible.\";\n");
        if (string.length() == 0 || string.length() == 1 || bl4 && (state.verticesOfTableView == null || state.verticesOfTableView.length == 0) || !bl4 && (state.edgesOfTableView == null || state.edgesOfTableView.length == 0)) {
            return;
        }
        int n3 = Integer.parseInt(string.substring(1));
        int n4 = -1;
        if ((bl4 ? state.selectedVertexClasses : state.selectedEdgeClasses).get((bl4 ? state.getGraph().getVertex(n3) : state.getGraph().getEdge(n3)).getAttributedElementClass()).booleanValue()) {
            for (n2 = 0; n2 < (bl4 ? state.verticesOfTableView : state.edgesOfTableView).length; ++n2) {
                if ((bl4 ? state.verticesOfTableView : state.edgesOfTableView)[n2].getId() != n3) continue;
                n4 = n2;
                break;
            }
        }
        n2 = n4 < 0 ? 1 : 0;
        n4 = n4 < 0 ? (n4 + 1) * -1 : n4;
        int n5 = 1;
        int n6 = 1;
        if (n > 0 && (bl4 ? state.verticesOfTableView : state.edgesOfTableView).length > n) {
            int n7 = (bl4 ? state.verticesOfTableView : state.edgesOfTableView).length;
            n5 = n7 / n;
            if (n7 % n != 0) {
                ++n5;
            }
            n6 = n4 / n + 1;
            this.createNavigationThroughPages(stringBuilder, bl4 ? "Vertex" : "Edge", n5, n6, true);
        } else {
            stringBuilder.append("parent.appendChild(document.createElement(\"br\"));\n");
            stringBuilder.append("var divText").append(bl4 ? "Vertex" : "Edge").append(" = parent;\n");
        }
        this.createTableDiv(stringBuilder, bl4 ? "Vertex" : "Edge");
        this.createTable(stringBuilder, n6, n, bl4 ? "Vertex" : "Edge", bl, bl4 ? state.verticesOfTableView : state.edgesOfTableView, state.selectedVertexClasses, state.selectedEdgeClasses, bl3);
        Object object = state.navigationHistory.get(state.insertPosition - 1);
        String string2 = "";
        if (object instanceof Vertex) {
            string2 = "v" + ((Vertex)object).getId();
        } else if (object instanceof Edge) {
            string2 = "e" + ((Edge)object).getId();
        }
        stringBuilder.append("changeBackgroundColor(\"").append(string2).append("\");\n");
        if (bl2) {
            stringBuilder.append("document.location.href = \"#").append(string).append("\";\n");
        }
        if (n2 != 0) {
            stringBuilder.append("if((").append(bl4).append(" && areVerticesShown()) || (").append(!bl4).append(" && !areVerticesShown())){\n");
            stringBuilder.append("alert(\"The ").append(bl4 ? "vertex " : "edge ").append(string).append(" could not be found");
            if (!(bl4 ? state.selectedVertexClasses : state.selectedEdgeClasses).get((bl4 ? state.getGraph().getVertex(n3) : state.getGraph().getEdge(n3)).getAttributedElementClass()).booleanValue()) {
                stringBuilder.append(" because the type ").append(((GraphElementClass)(bl4 ? state.getGraph().getVertex(n3) : state.getGraph().getEdge(n3)).getAttributedElementClass()).getQualifiedName()).append(" is deselected");
            }
            stringBuilder.append(". \\nThat's why the first page of the current table is shown.\");\n");
            stringBuilder.append("}\n");
        }
    }

    private void createTable(StringBuilder stringBuilder, int n, int n2, String string, boolean bl, GraphElement<?, ?>[] graphElementArray, HashMap<VertexClass, Boolean> hashMap, HashMap<EdgeClass, Boolean> hashMap2, boolean bl2) {
        stringBuilder.append("var mainTable").append(string).append(" = document.createElement(\"table\");\n");
        stringBuilder.append("var table").append(string).append(" = document.createElement(\"thead\");\n");
        stringBuilder.append("mainTable").append(string).append(".appendChild(table").append(string).append(");\n");
        stringBuilder.append("var currentTr = document.createElement(\"tr\");\n");
        stringBuilder.append("table").append(string).append(".appendChild(currentTr);\n");
        this.createCell(stringBuilder, true, string, false);
        if (bl) {
            this.createCell(stringBuilder, true, "Attributes", false);
        }
        this.createCell(stringBuilder, true, "Incident " + (string.startsWith("E") ? "vertices" : "edges"), false);
        stringBuilder.append("var table").append(string).append(" = document.createElement(\"tbody\");\n");
        stringBuilder.append("mainTable").append(string).append(".appendChild(table").append(string).append(");\n");
        for (int i = (n - 1) * (n2 < 0 ? 0 : n2); i < graphElementArray.length && i < (n2 < 0 ? graphElementArray.length : n * n2); ++i) {
            GraphElement<?, ?> graphElement = graphElementArray[i];
            stringBuilder.append("var currentTr = document.createElement(\"tr\");\n");
            stringBuilder.append("currentTr.id = \"tr").append(graphElement instanceof Vertex ? "v" : "e").append(graphElement.getId()).append("\";\n");
            stringBuilder.append("table").append(string).append(".appendChild(currentTr);\n");
            this.createCell(stringBuilder, false, this.createElement(graphElement), false);
            stringBuilder.append("currentTd.onclick = function(){\nclickOnElement(\"").append(graphElement instanceof Vertex ? "v" : "e").append(graphElement.getId()).append("\");\n}\n");
            if (bl2) {
                stringBuilder.append("var anker = document.createElement(\"a\");\n");
                stringBuilder.append("anker.id = \"").append(graphElement instanceof Vertex ? "v" : "e").append(graphElement.getId()).append("\";\n");
                stringBuilder.append("currentTd.appendChild(anker);\n");
            }
            if (!bl) {
                this.createAttributes(stringBuilder, graphElement, true);
            }
            if (bl) {
                this.createCell(stringBuilder, false, "", true);
                this.createAttributes(stringBuilder, graphElement, false);
                stringBuilder.append("currentTd.style.textAlign = \"left\";\n");
            }
            this.createCell(stringBuilder, false, "", true);
            if (graphElement instanceof Vertex) {
                stringBuilder.append("currentTd.id = \"td").append("v").append(graphElement.getId()).append("\";\n");
                this.createIncidentEdges(stringBuilder, (Vertex)graphElement, hashMap2, hashMap, 1, null);
            } else {
                this.createIncidentVertices(stringBuilder, (Edge)graphElement, hashMap);
            }
            stringBuilder.append("currentTd.style.textAlign = \"left\";\n");
        }
        stringBuilder.append("div").append(string).append("Table.appendChild(mainTable").append(string).append(");\n");
    }

    private String createElement(GraphElement<?, ?> graphElement) {
        return ((GraphElementClass)graphElement.getAttributedElementClass()).getUniqueName() + "<sub>" + Math.abs(graphElement.getId()) + "</sub>";
    }

    private void createAttributes(StringBuilder stringBuilder, AttributedElement<?, ?> attributedElement, boolean bl) {
        this.createAttributes(stringBuilder, attributedElement, bl, null);
    }

    private void createAttributes(StringBuilder stringBuilder, AttributedElement<?, ?> attributedElement, boolean bl, String string) {
        stringBuilder.append(bl ? (string == null ? "currentTd" : string) + ".title = \"" : "");
        boolean bl2 = true;
        for (Attribute attribute : attributedElement.getAttributedElementClass().getAttributeList()) {
            if (!bl2) {
                stringBuilder.append(bl ? "\t" : (string == null ? "currentTd" : string) + ".appendChild(document.createElement(\"br\"));\n");
            }
            stringBuilder.append(bl ? "" : (string == null ? "currentTd" : string) + ".appendChild(document.createTextNode(\"");
            stringBuilder.append(attribute.getName()).append(" = ");
            try {
                String string2 = ((InternalAttributedElement)((Object)attributedElement)).writeAttributeValueToString(attribute.getName());
                string2 = Pattern.compile(Matcher.quoteReplacement("\\")).matcher(string2).replaceAll(Matcher.quoteReplacement("\\\\"));
                string2 = Pattern.compile(Matcher.quoteReplacement("\"")).matcher(string2).replaceAll(Matcher.quoteReplacement("\\\""));
                stringBuilder.append(string2.equals("n") ? "null" : (string2.equals("t") ? "true" : (string2.equals("f") ? "false" : string2)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (GraphIOException graphIOException) {
                graphIOException.printStackTrace();
            }
            stringBuilder.append(bl ? ";" : ";\"));\n");
            bl2 = false;
        }
        stringBuilder.append(bl ? "\";\n" : "");
    }

    public void createIncidentEdges(StringBuilder stringBuilder, Vertex vertex, HashMap<EdgeClass, Boolean> hashMap, HashMap<VertexClass, Boolean> hashMap2, int n, String string) {
        if (string != null) {
            stringBuilder.append("var currentTd = document.getElementById(\"").append(string).append("\");\ncurrentTd.innerHTML = \"\";\n");
        }
        int n2 = 1;
        boolean bl = false;
        for (Edge edge : vertex.incidences()) {
            if (!hashMap.get(edge.getAttributedElementClass()).booleanValue()) continue;
            if (n2 > (n - 1) * NUMBER_OF_INCIDENCES_PER_PAGE && n2 <= n * NUMBER_OF_INCIDENCES_PER_PAGE) {
                if (n2 > 1) {
                    stringBuilder.append("currentTd.appendChild(document.createElement(\"br\"));\n");
                } else {
                    bl = true;
                }
                stringBuilder.append("var text = document.createElement(\"b\");\n");
                stringBuilder.append("text.appendChild(document.createTextNode(").append(this.isOutgoingEdge(vertex, edge) ? "String.fromCharCode(8594)" : "String.fromCharCode(8592)").append("));\n");
                stringBuilder.append("text.style.fontSize = \"large\";\n");
                stringBuilder.append("currentTd.appendChild(text);\n");
                stringBuilder.append("text = document.createTextNode(\"{\");\n");
                stringBuilder.append("currentTd.appendChild(text);\n");
                stringBuilder.append("var aE = document.createElement(\"a\");\n");
                stringBuilder.append("aE.href = \"javascript:showElement('e").append(Math.abs(edge.getId())).append("');\";\n");
                stringBuilder.append("aE.innerHTML = \"").append(this.createElement(edge)).append("\";\n");
                this.createAttributes(stringBuilder, edge.getNormalEdge(), true, "aE");
                stringBuilder.append("currentTd.appendChild(aE);\n");
                stringBuilder.append("currentTd.appendChild(document.createTextNode(\"}\"+String.fromCharCode(160)));\n");
                VertexClass vertexClass = edge.getThat().getAttributedElementClass();
                if (hashMap2.get(vertexClass).booleanValue()) {
                    stringBuilder.append("var aThat = document.createElement(\"a\");\n");
                    stringBuilder.append("aThat.href = \"javascript:showElement('v").append(edge.getThat().getId()).append("');\";\n");
                } else {
                    stringBuilder.append("var aThat = document.createElement(\"span\");\n");
                }
                stringBuilder.append("aThat.innerHTML= \"").append(this.createElement(edge.getThat())).append("\";\n");
                stringBuilder.append("currentTd.appendChild(aThat);\n");
                this.createAttributes(stringBuilder, edge.getThat(), true, "aThat");
            }
            ++n2;
        }
        if (n2 - 1 > NUMBER_OF_INCIDENCES_PER_PAGE) {
            if (bl) {
                stringBuilder.append("currentTd.insertBefore(document.createElement(\"br\"),currentTd.firstChild);\n");
            }
            int n3 = --n2 / NUMBER_OF_INCIDENCES_PER_PAGE + (n2 % NUMBER_OF_INCIDENCES_PER_PAGE == 0 ? 0 : 1);
            this.createNavigationThroughPages(stringBuilder, "v" + vertex.getId(), n3, n, false);
        }
    }

    private boolean isOutgoingEdge(Vertex vertex, Edge edge) {
        return edge.isNormal() && edge.getAlpha() == vertex;
    }

    private void createIncidentVertices(StringBuilder stringBuilder, Edge edge, HashMap<VertexClass, Boolean> hashMap) {
        VertexClass vertexClass = edge.getAlpha().getAttributedElementClass();
        if (hashMap.get(vertexClass).booleanValue()) {
            stringBuilder.append("var aAlpha = document.createElement(\"a\");\n");
            stringBuilder.append("aAlpha.href = \"javascript:showElement('v").append(edge.getAlpha().getId()).append("');\";\n");
        } else {
            stringBuilder.append("var aAlpha = document.createElement(\"span\");\n");
        }
        stringBuilder.append("aAlpha.innerHTML= \"").append(this.createElement(edge.getAlpha())).append("\";\n");
        stringBuilder.append("currentTd.appendChild(aAlpha);\n");
        this.createAttributes(stringBuilder, edge.getAlpha(), true, "aAlpha");
        stringBuilder.append("var textNode = document.createTextNode(String.fromCharCode(160));\n");
        stringBuilder.append("currentTd.appendChild(textNode);\n");
        stringBuilder.append("var textNode = document.createElement(\"b\");\n");
        stringBuilder.append("textNode.appendChild(document.createTextNode(String.fromCharCode(8594)));\n");
        stringBuilder.append("textNode.style.fontSize = \"large\";\n");
        stringBuilder.append("currentTd.appendChild(textNode);\n");
        stringBuilder.append("var textNode = document.createTextNode(String.fromCharCode(160));\n");
        stringBuilder.append("currentTd.appendChild(textNode);\n");
        vertexClass = edge.getOmega().getAttributedElementClass();
        if (hashMap.get(vertexClass).booleanValue()) {
            stringBuilder.append("var aOmega = document.createElement(\"a\");\n");
            stringBuilder.append("aOmega.href = \"javascript:showElement('v").append(edge.getOmega().getId()).append("');\";\n");
        } else {
            stringBuilder.append("var aOmega = document.createElement(\"span\");\n");
        }
        stringBuilder.append("aOmega.innerHTML= \"").append(this.createElement(edge.getOmega())).append("\";\n");
        stringBuilder.append("currentTd.appendChild(aOmega);\n");
        this.createAttributes(stringBuilder, edge.getOmega(), true, "aOmega");
    }

    private void createCell(StringBuilder stringBuilder, boolean bl, String string, boolean bl2) {
        String string2 = bl ? "h" : "d";
        stringBuilder.append("var currentT").append(string2).append(" = document.createElement(\"t").append(string2).append("\");\n");
        stringBuilder.append("currentTr.appendChild(currentT").append(string2).append(");\n");
        if (!bl2) {
            stringBuilder.append("currentT").append(string2).append(".innerHTML=\"").append(string).append("\";\n");
        } else {
            stringBuilder.append(string);
        }
    }

    private void createNavigationThroughPages(StringBuilder stringBuilder, String string, int n, int n2, boolean bl) {
        if (bl) {
            stringBuilder.append("var divText").append(string).append(" = document.getElementById(\"divText").append(string).append("\");\n");
        }
        stringBuilder.append("var div").append(string).append("Headline = document.createElement(\"div\");\n");
        stringBuilder.append("div").append(string).append("Headline.id = \"div").append(string).append("Headline\";\n");
        stringBuilder.append("if(div").append(string).append("Headline.hasAttribute){\n");
        stringBuilder.append("div").append(string).append("Headline.setAttribute(\"class\",\"divHeadline\");\n");
        stringBuilder.append("}else{\n");
        stringBuilder.append("div").append(string).append("Headline.setAttribute(\"className\",\"divHeadline\");\n");
        stringBuilder.append("}\n");
        if (bl) {
            stringBuilder.append("divText").append(string).append(".appendChild(div").append(string).append("Headline);\n");
        } else {
            stringBuilder.append("currentTd.insertBefore(div").append(string).append("Headline,currentTd.firstChild);\n");
        }
        if (bl) {
            stringBuilder.append("var brheadline = document.createElement(\"br\");\n");
            stringBuilder.append("div").append(string).append("Headline.appendChild(brheadline);\n");
        }
        stringBuilder.append("var aToBeginning = document.createElement(\"a\");\n");
        stringBuilder.append("aToBeginning.href = \"javascript:").append(bl ? "goToPage" : "goToIncidentPage").append("(1").append(bl ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        stringBuilder.append("aToBeginning.innerHTML = \"&lt;&lt;\";\n");
        stringBuilder.append("div").append(string).append("Headline.appendChild(aToBeginning);\n");
        stringBuilder.append("var aToPrevious = document.createElement(\"a\");\n");
        stringBuilder.append("aToPrevious.href = \"javascript:").append(bl ? "goToPage" : "goToIncidentPage").append("(document.getElementById('inputPageNumber").append(string).append("').value==1?1:document.getElementById('inputPageNumber").append(string).append("').value-1").append(bl ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        stringBuilder.append("aToPrevious.innerHTML = String.fromCharCode(160)+String.fromCharCode(60)+String.fromCharCode(160);\n");
        stringBuilder.append("div").append(string).append("Headline.appendChild(aToPrevious);\n");
        stringBuilder.append("var textPage = document.createTextNode(String.fromCharCode(160)+\"Page\"+String.fromCharCode(160));\n");
        stringBuilder.append("div").append(string).append("Headline.appendChild(textPage);\n");
        stringBuilder.append("var inputPageNumber").append(string).append(" = document.createElement(\"input\");\n");
        stringBuilder.append("inputPageNumber").append(string).append(".id = \"inputPageNumber").append(string).append("\";\n");
        stringBuilder.append("inputPageNumber").append(string).append(".type = \"text\";\n");
        stringBuilder.append("inputPageNumber").append(string).append(".size = 6;\n");
        stringBuilder.append("inputPageNumber").append(string).append(".value = ").append(n2).append(";\n");
        stringBuilder.append("inputPageNumber").append(string).append(".style.textAlign = \"right\";\n");
        stringBuilder.append("inputPageNumber").append(string).append(".onchange = function(){\nif(this.value<1){\nthis.value = 1;\n}else if(this.value>").append(n).append("){\nthis.value = ").append(n).append(";\n}\n").append(bl ? "goToPage" : "goToIncidentPage").append("(this.value*1,").append(bl ? "true" : "this.parentNode.parentNode.id").append(");\n};\n");
        stringBuilder.append("div").append(string).append("Headline.appendChild(inputPageNumber").append(string).append(");\n");
        stringBuilder.append("var textMax = document.createTextNode(String.fromCharCode(160)+\"/").append(n).append("\"+String.fromCharCode(160));\n");
        stringBuilder.append("div").append(string).append("Headline.appendChild(textMax);\n");
        stringBuilder.append("var aToNext = document.createElement(\"a\");\n");
        stringBuilder.append("aToNext.href = \"javascript:").append(bl ? "goToPage" : "goToIncidentPage").append("(document.getElementById('inputPageNumber").append(string).append("').value==").append(n).append("?").append(n).append(":document.getElementById('inputPageNumber").append(string).append("').value*1+1").append(bl ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        stringBuilder.append("aToNext.innerHTML = String.fromCharCode(160)+String.fromCharCode(62)+String.fromCharCode(160);\n");
        stringBuilder.append("div").append(string).append("Headline.appendChild(aToNext);\n");
        stringBuilder.append("var aToEnd = document.createElement(\"a\");\n");
        stringBuilder.append("aToEnd.href = \"javascript:").append(bl ? "goToPage" : "goToIncidentPage").append("(").append(n).append(bl ? "" : ",'\"+currentTd.id+\"'").append(");\";\n");
        stringBuilder.append("aToEnd.innerHTML = \"&gt;&gt;\";\n");
        stringBuilder.append("div").append(string).append("Headline.appendChild(aToEnd);\n");
        if (bl) {
            stringBuilder.append("var brafterheadline = document.createElement(\"br\");\n");
            stringBuilder.append("brafterheadline.id = \"brToDelete").append(string).append("\";\n");
            stringBuilder.append("divText").append(string).append(".appendChild(brafterheadline);\n");
        }
    }

    private void createTableDiv(StringBuilder stringBuilder, String string) {
        stringBuilder.append("var div").append(string).append("Table = document.createElement(\"div\");\n");
        stringBuilder.append("div").append(string).append("Table.id = \"div").append(string).append("Table\";\n");
        stringBuilder.append("divText").append(string).append(".appendChild(div").append(string).append("Table);\n");
    }
}

