/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.VertexTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;

class EdgeTreeNode
extends GraphElementTreeNode {
    private Edge e;

    public EdgeTreeNode(Edge edge, VertexTreeNode vertexTreeNode) {
        super(vertexTreeNode);
        this.e = edge;
    }

    public boolean isBackEdge() {
        Edge edge;
        return this.getParent() != null && this.getParent().getParent() != null && (edge = (Edge)((GraphElementTreeNode)this.getParent().getParent()).get()).getNormalEdge() == this.e.getNormalEdge();
    }

    @Override
    public String getClipboardText() {
        return this.e.getThisRole() + ":" + this.e.getAttributedElementClass().getQualifiedName() + ":" + this.e.getThatRole();
    }

    public String toString() {
        Object object;
        int n = -1;
        int n2 = -1;
        if (this.getParent() != null) {
            n = this.getParent().getIndex(this) + 1;
        }
        VertexTreeNode vertexTreeNode = (VertexTreeNode)this.getChildAt(0);
        Enumeration<GraphElementTreeNode> enumeration = vertexTreeNode.children();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            object = (EdgeTreeNode)enumeration.nextElement();
            ++n3;
            if (!((EdgeTreeNode)object).isBackEdge()) continue;
            n2 = n3;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(String.format("%3d", n));
        ((StringBuilder)object).append('/');
        ((StringBuilder)object).append(String.format("%3d", n2));
        ((StringBuilder)object).append(" | ");
        ((StringBuilder)object).append(this.e.toString());
        return ((StringBuilder)object).toString();
    }

    @Override
    public String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        String string = this.e.getThisRole();
        String string2 = this.e.getThatRole();
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append("$noRole$");
        }
        stringBuilder.append(" ------- ");
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append("$noRole$");
        }
        stringBuilder.append("<br/><br/>");
        stringBuilder.append(this.getAttributeString());
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    protected void init() {
        this.incs = new ArrayList();
        this.incs.add(new VertexTreeNode(this.e.getThat(), this));
    }

    @Override
    protected GraphElement<?, ?> get() {
        return this.e;
    }
}

