/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.utilities.tgtree.EdgeTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.VertexTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class GraphElementCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -1698523886275339684L;
    private static final Map<String, ImageIcon> ICON_CACHE = new HashMap<String, ImageIcon>();

    GraphElementCellRenderer() {
    }

    private static ImageIcon getIcon(String string) {
        ImageIcon imageIcon = ICON_CACHE.get(string);
        if (imageIcon == null) {
            imageIcon = new ImageIcon(GraphElementCellRenderer.class.getResource("icons/" + string + ".png"));
            imageIcon.setImage(imageIcon.getImage().getScaledInstance(24, 8, 4));
            ICON_CACHE.put(string, imageIcon);
        }
        return imageIcon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        GraphElementTreeNode graphElementTreeNode = (GraphElementTreeNode)object;
        this.setToolTipText(graphElementTreeNode.getToolTipText());
        this.setFont(new Font("Monospaced", 0, jTree.getFont().getSize()));
        if (graphElementTreeNode instanceof EdgeTreeNode) {
            String string = null;
            Edge edge = (Edge)((EdgeTreeNode)graphElementTreeNode).get();
            string = edge.isNormal() ? (edge.getThatAggregationKind() == AggregationKind.SHARED ? "l_aggr_r" : (edge.getThatAggregationKind() == AggregationKind.COMPOSITE ? "l_comp_r" : (edge.getThisAggregationKind() == AggregationKind.SHARED ? "r_aggr_r" : (edge.getThisAggregationKind() == AggregationKind.COMPOSITE ? "r_comp_r" : "edge_r")))) : (edge.getThatAggregationKind() == AggregationKind.SHARED ? "l_aggr_l" : (edge.getThatAggregationKind() == AggregationKind.COMPOSITE ? "l_comp_l" : (edge.getThisAggregationKind() == AggregationKind.SHARED ? "r_aggr_l" : (edge.getThisAggregationKind() == AggregationKind.COMPOSITE ? "r_comp_l" : "edge_l"))));
            this.setIcon(GraphElementCellRenderer.getIcon(string));
            EdgeTreeNode edgeTreeNode = (EdgeTreeNode)graphElementTreeNode;
            if (edgeTreeNode.isBackEdge()) {
                this.setForeground(Color.LIGHT_GRAY);
            }
        } else if (graphElementTreeNode instanceof VertexTreeNode) {
            this.setIcon(GraphElementCellRenderer.getIcon("vertex"));
        }
        return this;
    }
}

