/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import de.uni_koblenz.ist.utilities.gui.StringListPreferences;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class RecentFilesList
extends StringListPreferences {
    private int maxEntries;
    private JMenu menu;
    private int initialItemCount;

    public RecentFilesList(Preferences preferences, String string, int n, JMenu jMenu) {
        super(preferences, string);
        this.maxEntries = n;
        this.menu = jMenu;
        this.initialItemCount = jMenu.getItemCount();
        this.load(n);
        this.updateMenu();
    }

    public void rememberFile(File file) {
        if (file == null) {
            return;
        }
        try {
            String string = file.getCanonicalPath();
            int n = this.entries.indexOf(string);
            if (n == 0) {
                return;
            }
            if (n > 0) {
                this.entries.remove(n);
            }
            while (this.entries.size() >= this.maxEntries) {
                this.entries.remove(this.size() - 1);
            }
            this.entries.add(0, string);
            this.updateMenu();
            this.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateMenu() {
        while (this.menu.getItemCount() > this.initialItemCount) {
            this.menu.remove(this.menu.getItem(0));
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            this.menu.add((Component)new RecentMenuItem((String)this.entries.get(i)), i);
        }
    }

    public abstract void openRecentFile(File var1);

    private class RecentMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 6317371073043983226L;
        String filename;

        public RecentMenuItem(String string) {
            super(string);
            this.filename = string;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RecentFilesList.this.openRecentFile(new File(RecentMenuItem.this.filename));
                }
            });
        }
    }
}

