/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXMLStreamWriter
implements XMLStreamWriter {
    private int indentationLevel;
    private String indentation;
    private XMLStreamWriter writer;

    public IndentingXMLStreamWriter(XMLStreamWriter xMLStreamWriter) {
        this(xMLStreamWriter, "\t");
    }

    public IndentingXMLStreamWriter(XMLStreamWriter xMLStreamWriter, String string) {
        this.writer = xMLStreamWriter;
        this.indentation = string;
        this.indentationLevel = 0;
    }

    public void setIndentationLevel(int n) {
        this.indentationLevel = n;
    }

    public void setIndentation(String string) {
        this.indentation = string;
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.writer.getPrefix(string);
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.writer.getProperty(string);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.writer.setDefaultNamespace(string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.writer.setNamespaceContext(namespaceContext);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.writer.setPrefix(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.writer.writeAttribute(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.writer.writeAttribute(string, string2, string3);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.writer.writeAttribute(string, string2, string3, string4);
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeCData(string);
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeCharacters(string);
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeCharacters(cArray, n, n2);
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeComment(string);
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeDTD(string);
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.writer.writeDefaultNamespace(string);
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(string);
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(string, string2);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEmptyElement(string, string2, string3);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        while (this.indentationLevel > 0) {
            this.writeEndElement();
        }
        this.writer.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.indentationLevel;
        this.writeIndentation();
        this.writer.writeEndElement();
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeEntityRef(string);
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        this.writer.writeNamespace(string, string2);
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeProcessingInstruction(string);
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeProcessingInstruction(string, string2);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.writer.writeStartDocument(string);
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.writer.writeStartDocument(string, string2);
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(string);
        ++this.indentationLevel;
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(string, string2);
        ++this.indentationLevel;
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.writeIndentation();
        this.writer.writeStartElement(string, string2, string3);
        ++this.indentationLevel;
    }

    private void writeIndentation() throws XMLStreamException {
        this.writer.writeCharacters("\n");
        for (int i = 0; i < this.indentationLevel; ++i) {
            this.writer.writeCharacters(this.indentation);
        }
    }
}

