/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.problems.TraversalFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class BreadthFirstSearch
extends SearchAlgorithm
implements TraversalFromVertexSolver {
    private SearchVisitorList visitors;
    private int firstV;

    public BreadthFirstSearch(Graph graph, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
    }

    public BreadthFirstSearch(Graph graph) {
        this(graph, null);
    }

    @Override
    public BreadthFirstSearch withLevel() {
        super.withLevel();
        return this;
    }

    @Override
    public BreadthFirstSearch withNumber() {
        super.withNumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withENumber() {
        super.withENumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withParent() {
        super.withParent();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutLevel() {
        super.withoutLevel();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutNumber() {
        super.withoutNumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutENumber() {
        super.withoutENumber();
        return this;
    }

    @Override
    public BreadthFirstSearch withoutParent() {
        super.withoutParent();
        return this;
    }

    @Override
    public BreadthFirstSearch normal() {
        super.normal();
        return this;
    }

    @Override
    public BreadthFirstSearch reversed() {
        super.reversed();
        return this;
    }

    @Override
    public BreadthFirstSearch undirected() {
        super.undirected();
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.firstV = 1;
        this.visitors.reset();
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.visitors = new SearchVisitorList();
    }

    public int getFirstV() {
        return this.firstV;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        visitor.setAlgorithm(this);
        this.visitors.addVisitor(visitor);
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.visitors.removeVisitor(visitor);
    }

    @Override
    public BreadthFirstSearch execute(Vertex vertex) throws AlgorithmTerminatedException {
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && !traversalContext.containsVertex(vertex) || this.visitedVertices.get(vertex)) {
            return this;
        }
        this.startRunning();
        this.vertexOrder[this.num] = vertex;
        if (this.level != null) {
            this.level.set(vertex, 0);
        }
        this.visitors.visitRoot(vertex);
        if (this.number != null) {
            this.number.set(vertex, this.num);
        }
        this.visitors.visitVertex(vertex);
        this.visitedVertices.set(vertex, true);
        ++this.num;
        while (this.firstV < this.num && this.vertexOrder[this.firstV] != null) {
            Vertex vertex2 = this.vertexOrder[this.firstV++];
            for (Edge edge : vertex2.incidences(this.traversalDirection)) {
                this.cancelIfInterrupted();
                if (this.visitedEdges.get(edge) || this.navigable != null && !this.navigable.get(edge)) continue;
                Vertex vertex3 = edge.getThat();
                this.edgeOrder[this.eNum] = edge;
                if (this.enumber != null) {
                    this.enumber.set(edge, this.eNum);
                }
                this.visitors.visitEdge(edge);
                this.visitedEdges.set(edge, true);
                ++this.eNum;
                if (this.visitedVertices.get(vertex3)) {
                    this.visitors.visitFrond(edge);
                    continue;
                }
                this.visitors.visitTreeEdge(edge);
                this.vertexOrder[this.num] = vertex3;
                if (this.level != null) {
                    this.level.set(vertex3, this.level.get(vertex2) + 1);
                }
                if (this.parent != null) {
                    this.parent.set(edge.getThat(), edge);
                }
                if (this.number != null) {
                    this.number.set(vertex3, this.num);
                }
                this.visitors.visitVertex(vertex3);
                this.visitedVertices.set(vertex3, true);
                ++this.num;
            }
        }
        this.done();
        return this;
    }

    @Override
    public BreadthFirstSearch execute() throws AlgorithmTerminatedException {
        super.execute();
        return this;
    }
}

