/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.shortest_paths;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.BreadthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.ArrayBinaryDoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.ArrayBinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.BinaryDoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.BinaryFunction;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.problems.DistancesSolver;
import de.uni_koblenz.jgralab.algolib.problems.NegativeCyclesSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathsSolver;
import de.uni_koblenz.jgralab.algolib.problems.WeightedProblemSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;

public class FloydAlgorithm
extends StructureOrientedAlgorithm
implements WeightedProblemSolver,
DistancesSolver,
ShortestPathsSolver,
NegativeCyclesSolver {
    private IntFunction<Vertex> indexMapping;
    private Permutation<Vertex> vertexOrder;
    private int vertexCount;
    private double[][] weightedDistance;
    private Edge[][] successor;
    private DoubleFunction<Edge> edgeWeight;
    private boolean negativeCycles;

    public FloydAlgorithm(Graph graph) {
        this(graph, null, null);
    }

    public FloydAlgorithm(Graph graph, BooleanFunction<Edge> booleanFunction, DoubleFunction<Edge> doubleFunction) {
        super(graph, booleanFunction);
        this.edgeWeight = doubleFunction;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public FloydAlgorithm normal() {
        super.normal();
        return this;
    }

    @Override
    public FloydAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public FloydAlgorithm undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm does not support any visitors.");
    }

    @Override
    public void setEdgeWeight(DoubleFunction<Edge> doubleFunction) {
        this.checkStateForSettingParameters();
        this.edgeWeight = doubleFunction;
    }

    public DoubleFunction<Edge> getEdgeWeight() {
        return this.edgeWeight;
    }

    @Override
    public void reset() {
        super.reset();
        this.negativeCycles = false;
        BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(this.graph).withNumber();
        try {
            ((SearchAlgorithm)breadthFirstSearch).execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        assert (breadthFirstSearch.getState() == AlgorithmStates.FINISHED);
        this.indexMapping = breadthFirstSearch.getNumber();
        this.vertexOrder = breadthFirstSearch.getVertexOrder();
        this.vertexCount = this.graph.getVCount();
        this.weightedDistance = new double[this.vertexCount + 1][this.vertexCount + 1];
        this.successor = new Edge[this.vertexCount + 1][this.vertexCount + 1];
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.traversalDirection = EdgeDirection.OUT;
    }

    @Override
    public FloydAlgorithm execute() throws AlgorithmTerminatedException {
        int n;
        this.startRunning();
        int n2 = this.vertexCount + 1;
        for (int i = 1; i < n2; ++i) {
            for (int j = 1; j < n2; ++j) {
                this.weightedDistance[i][j] = Double.POSITIVE_INFINITY;
                this.successor[i][j] = null;
            }
            this.weightedDistance[i][i] = 0.0;
        }
        for (Edge edge : this.graph.edges()) {
            if (this.navigable != null && !this.navigable.get(edge)) continue;
            n = this.indexMapping.get(edge.getAlpha());
            int n3 = this.indexMapping.get(edge.getOmega());
            double d = this.edgeWeight.get(edge);
            switch (this.traversalDirection) {
                case OUT: {
                    if (!(this.weightedDistance[n][n3] > d)) break;
                    this.weightedDistance[n][n3] = d;
                    this.successor[n][n3] = edge;
                    break;
                }
                case INOUT: {
                    if (!(this.weightedDistance[n][n3] > d)) break;
                    this.weightedDistance[n][n3] = d;
                    this.weightedDistance[n3][n] = d;
                    this.successor[n][n3] = edge;
                    this.successor[n3][n] = edge.getReversedEdge();
                    break;
                }
                case IN: {
                    if (!(this.weightedDistance[n3][n3] > d)) break;
                    this.weightedDistance[n3][n] = d;
                    this.successor[n3][n] = edge.getReversedEdge();
                }
            }
        }
        for (int i = 1; i <= this.vertexCount; ++i) {
            for (int j = 1; j <= this.vertexCount; ++j) {
                for (n = 1; n <= this.vertexCount; ++n) {
                    double d = this.weightedDistance[j][i] + this.weightedDistance[i][n];
                    if (this.weightedDistance[j][n] > d) {
                        this.cancelIfInterrupted();
                        this.weightedDistance[j][n] = d;
                        this.successor[j][n] = this.successor[j][i];
                    }
                    if (j != n || !(this.weightedDistance[j][n] < 0.0)) continue;
                    this.negativeCycles = true;
                    this.terminate();
                }
            }
        }
        this.done();
        return this;
    }

    @Override
    public BinaryDoubleFunction<Vertex, Vertex> getDistances() {
        this.checkStateForResult();
        return new ArrayBinaryDoubleFunction<Vertex>(this.weightedDistance, this.indexMapping);
    }

    @Override
    public BinaryFunction<Vertex, Vertex, Edge> getSuccessor() {
        this.checkStateForResult();
        return new ArrayBinaryFunction<Vertex, Edge>(this.successor, this.indexMapping);
    }

    public Permutation<Vertex> getVertexOrder() {
        return this.vertexOrder;
    }

    public IntFunction<Vertex> getIndexMapping() {
        return this.indexMapping;
    }

    public double[][] getInternalWeightedDistance() {
        return this.weightedDistance;
    }

    public Edge[][] getInternalSuccessor() {
        return this.successor;
    }

    @Override
    public boolean hasNegativeCycles() {
        this.checkStateForResult();
        return this.negativeCycles;
    }

    public boolean getInternalNegativeCycles() {
        return this.negativeCycles;
    }
}

