/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.BooleanFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.BitSet;
import java.util.Iterator;

public abstract class BitSetGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements BooleanFunction<T> {
    protected final BitSet marks = new BitSet();
    protected long version;

    protected BitSetGraphMarker(Graph graph) {
        super(graph);
    }

    public boolean mark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        boolean bl = this.isMarked(t);
        this.marks.set(t.getId());
        ++this.version;
        return !bl;
    }

    @Override
    public boolean removeMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        boolean bl = this.isMarked(t);
        this.marks.clear(t.getId());
        --this.version;
        return bl;
    }

    @Override
    public int size() {
        return this.marks.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.marks.isEmpty();
    }

    @Override
    public void clear() {
        this.marks.clear();
    }

    @Override
    public boolean isMarked(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.marks.get(t.getId());
    }

    @Override
    public void maxEdgeCountIncreased(int n) {
    }

    @Override
    public void maxVertexCountIncreased(int n) {
    }

    @Override
    public boolean get(T t) {
        return this.isMarked(t);
    }

    @Override
    public boolean isDefined(T t) {
        return true;
    }

    @Override
    public void set(T t, boolean bl) {
        if (bl) {
            this.mark(t);
        } else {
            this.removeMark(t);
        }
    }

    @Override
    public Iterator<BooleanFunctionEntry<T>> iterator() {
        final Iterator iterator = this.getDomainElements().iterator();
        return new Iterator<BooleanFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BooleanFunctionEntry<T> next() {
                GraphElement graphElement = (GraphElement)iterator.next();
                return new BooleanFunctionEntry<GraphElement>(graphElement, BitSetGraphMarker.this.get(graphElement));
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

