/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.LongFunction;
import de.uni_koblenz.jgralab.algolib.functions.entries.LongFunctionEntry;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import java.util.Iterator;

public abstract class LongGraphMarker<T extends GraphElement<?, ?>>
extends AbstractGraphMarker<T>
implements LongFunction<T> {
    private static final long DEFAULT_UNMARKED_VALUE = Long.MIN_VALUE;
    protected long[] temporaryAttributes;
    protected int marked;
    protected long unmarkedValue = Long.MIN_VALUE;
    protected long version;

    protected LongGraphMarker(Graph graph, int n) {
        super(graph);
        this.temporaryAttributes = this.createNewArray(n);
        this.marked = 0;
    }

    private long[] createNewArray(int n) {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.unmarkedValue;
        }
        return lArray;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.temporaryAttributes.length; ++i) {
            this.temporaryAttributes[i] = this.unmarkedValue;
        }
        this.marked = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.marked == 0;
    }

    @Override
    public boolean isMarked(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        return this.temporaryAttributes[t.getId()] != this.unmarkedValue;
    }

    public long mark(T t, long l) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        long l2 = this.temporaryAttributes[t.getId()];
        this.temporaryAttributes[t.getId()] = l;
        ++this.marked;
        ++this.version;
        return l2;
    }

    public long getMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        long l = this.temporaryAttributes[t.getId()];
        return l;
    }

    @Override
    public boolean removeMark(T t) {
        assert (t.getGraph() == this.graph);
        assert (t.getId() <= (t instanceof Vertex ? this.graph.getMaxVCount() : this.graph.getMaxECount()));
        if (this.temporaryAttributes[t.getId()] == this.unmarkedValue) {
            return false;
        }
        this.temporaryAttributes[t.getId()] = this.unmarkedValue;
        --this.marked;
        ++this.version;
        return true;
    }

    @Override
    public int size() {
        return this.marked;
    }

    public int maxSize() {
        return this.temporaryAttributes.length - 1;
    }

    protected void expand(int n) {
        assert (n > this.temporaryAttributes.length);
        long[] lArray = this.createNewArray(n);
        System.arraycopy(this.temporaryAttributes, 0, lArray, 0, this.temporaryAttributes.length);
        this.temporaryAttributes = lArray;
    }

    public long getUnmarkedValue() {
        return this.unmarkedValue;
    }

    public void setUnmarkedValue(long l) {
        if (l != this.unmarkedValue) {
            for (int i = 0; i < this.temporaryAttributes.length; ++i) {
                if (this.temporaryAttributes[i] == l) {
                    --this.marked;
                }
                if (this.temporaryAttributes[i] != this.unmarkedValue) continue;
                this.temporaryAttributes[i] = l;
            }
            this.unmarkedValue = l;
        }
    }

    @Override
    public long get(T t) {
        return this.getMark(t);
    }

    @Override
    public boolean isDefined(T t) {
        return this.isMarked(t);
    }

    @Override
    public void set(T t, long l) {
        this.mark(t, l);
    }

    @Override
    public Iterable<T> getDomainElements() {
        return this.getMarkedElements();
    }

    @Override
    public Iterator<LongFunctionEntry<T>> iterator() {
        final Iterator iterator = this.getMarkedElements().iterator();
        return new Iterator<LongFunctionEntry<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public LongFunctionEntry<T> next() {
                GraphElement graphElement = (GraphElement)iterator.next();
                return new LongFunctionEntry<GraphElement>(graphElement, LongGraphMarker.this.get(graphElement));
            }

            @Override
            public void remove() {
            }
        };
    }
}

