/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import java.util.Iterator;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class VariableDeclaration {
    private PSet<Object> definitionSet;
    private final VariableEvaluator<Variable> variableEval;
    private final VertexEvaluator<? extends Expression> definitionSetEvaluator;
    private Iterator<Object> iter = null;
    private int iterationNumber = 0;

    VariableEvaluator<Variable> getVariableEval() {
        return this.variableEval;
    }

    public VariableDeclaration(Variable variable, VertexEvaluator<? extends Expression> vertexEvaluator, VariableEvaluator<Variable> variableEvaluator) {
        this.variableEval = variableEvaluator;
        this.definitionSet = JGraLab.set();
        this.definitionSetEvaluator = vertexEvaluator;
    }

    public String toString() {
        System.out.println("Warning: Use the toString(GreqlEvaluatorImpl) method for VariableDeclarations.");
        return super.toString();
    }

    public String toString(InternalGreqlEvaluator internalGreqlEvaluator) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Variable)this.variableEval.getVertex()).get_name());
        stringBuilder.append(" = ");
        stringBuilder.append(this.getVariableValue(internalGreqlEvaluator));
        stringBuilder.append(" [");
        stringBuilder.append(this.iterationNumber);
        stringBuilder.append('/');
        stringBuilder.append(this.definitionSet.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean iterate(InternalGreqlEvaluator internalGreqlEvaluator) {
        ++this.iterationNumber;
        if (this.iter != null && this.iter.hasNext()) {
            this.variableEval.setValue(this.iter.next(), internalGreqlEvaluator);
            return true;
        }
        return false;
    }

    public Object getVariableValue(InternalGreqlEvaluator internalGreqlEvaluator) {
        return this.variableEval.getValue(internalGreqlEvaluator);
    }

    protected void reset(InternalGreqlEvaluator internalGreqlEvaluator) {
        this.iterationNumber = 0;
        this.variableEval.setValue((Object)Undefined.UNDEFINED, internalGreqlEvaluator);
        Object object = this.definitionSetEvaluator.getResult(internalGreqlEvaluator);
        if (object instanceof PVector) {
            PVector pVector = (PVector)object;
            this.definitionSet = JGraLab.set().plusAll(pVector);
            if (pVector.size() > this.definitionSet.size()) {
                throw new GreqlException("A collection that doesn't fulfill the set property is used as variable range definition");
            }
        } else {
            PSet<Object> pSet;
            this.definitionSet = object instanceof PSet ? (pSet = (PSet<Object>)object) : JGraLab.set().plus(object);
        }
        this.iter = this.definitionSet.iterator();
    }

    public int getDefinitionCardinality() {
        return 40;
    }
}

