/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.greql.evaluator.fa.DFAState;
import de.uni_koblenz.jgralab.greql.evaluator.fa.FiniteAutomaton;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DFA
extends FiniteAutomaton {
    @Override
    public DFA getDFA() {
        return this;
    }

    public DFA(NFA nFA) {
        this.finalStates = new ArrayList();
        this.transitionList = new ArrayList();
        this.stateList = new ArrayList();
        this.eleminateEpsilonTransitions(nFA);
        this.myhillConstruction(nFA);
        this.removeDuplicateTransitions();
        this.updateStateAttributes();
    }

    private void removeDuplicateTransitions() {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        for (State object : this.stateList) {
            for (int i = 0; i < object.outTransitions.size() - 1; ++i) {
                Transition transition = object.outTransitions.get(i);
                for (int j = i + 1; j < object.outTransitions.size(); ++j) {
                    Transition transition2 = object.outTransitions.get(j);
                    if (transition.endState != transition2.endState || transition.startState != transition2.startState || !transition.equalSymbol(transition2)) continue;
                    hashSet.add(transition2);
                }
            }
        }
        for (Transition transition : hashSet) {
            this.transitionList.remove(transition);
            transition.delete();
        }
    }

    private void removeEpsilonTransition(NFA nFA, Transition transition) {
        State state = transition.startState;
        State state2 = transition.endState;
        if (state != state2) {
            if (state2.inTransitions.size() == 1 && nFA.initialState != state2) {
                Iterator<Transition> iterator = state2.outTransitions.iterator();
                while (iterator.hasNext()) {
                    Transition transition2 = iterator.next();
                    transition2.startState = state;
                    state.outTransitions.add(transition2);
                    iterator.remove();
                }
                nFA.stateList.remove(state2);
                nFA.finalStates.remove(state2);
            } else {
                for (Transition transition3 : state2.outTransitions) {
                    if (transition3.isEpsilon() && transition3.endState == state) continue;
                    Transition transition4 = transition3.copy(false);
                    nFA.transitionList.add(transition4);
                    transition4.setStartState(state);
                    transition4.setEndState(transition4.endState);
                }
            }
        }
        nFA.transitionList.remove(transition);
        transition.delete();
        if (state2.isFinal && !state.isFinal) {
            state.isFinal = true;
            nFA.finalStates.add(state);
        }
    }

    private void eleminateEpsilonTransitions(NFA nFA) {
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < nFA.transitionList.size()) {
                Transition transition = (Transition)nFA.transitionList.get(n);
                if (transition.isEpsilon()) {
                    this.removeEpsilonTransition(nFA, transition);
                    bl = true;
                    continue;
                }
                ++n;
            }
        }
    }

    private void myhillConstruction(NFA nFA) {
        this.initialState = new DFAState(nFA.initialState);
        if (nFA.initialState.isFinal) {
            this.initialState.isFinal = true;
            this.finalStates.add(this.initialState);
        }
        this.stateList.add(this.initialState);
        for (int i = 0; i < this.stateList.size(); ++i) {
            State state = (State)this.stateList.get(i);
            for (int j = 0; j < state.outTransitions.size(); ++j) {
                int n;
                Transition transition = state.outTransitions.get(j);
                DFAState dFAState = new DFAState(transition.endState);
                this.transitionList.addAll(dFAState.addRepresentedState(transition.endState));
                for (n = j + 1; n < state.outTransitions.size(); ++n) {
                    Transition transition2 = state.outTransitions.get(n);
                    if (!transition.equalSymbol(transition2)) continue;
                    if (transition.endState != transition2.endState) {
                        this.transitionList.addAll(dFAState.addRepresentedState(transition2.endState));
                    }
                    transition2.delete();
                    --n;
                }
                transition.setEndState(dFAState);
                n = 0;
                for (int k = 0; k < this.stateList.size(); ++k) {
                    DFAState dFAState2 = (DFAState)this.stateList.get(k);
                    if (!dFAState2.representSameNFAStates(dFAState)) continue;
                    n = 1;
                    ArrayList arrayList = new ArrayList(dFAState.inTransitions);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ((Transition)iterator.next()).setEndState(dFAState2);
                    }
                }
                if (n != 0) continue;
                this.stateList.add(dFAState);
                if (!dFAState.containsFinalStateOfNFA(nFA)) continue;
                dFAState.isFinal = true;
                this.finalStates.add(dFAState);
            }
        }
    }
}

