/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public class TypeIdEvaluator
extends VertexEvaluator<TypeId> {
    private TypeCollection tc;

    public TypeIdEvaluator(TypeId typeId, GreqlQueryImpl greqlQueryImpl) {
        super(typeId, greqlQueryImpl);
    }

    @Override
    public TypeCollection evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        if (this.tc == null) {
            this.tc = TypeCollection.empty().with(((TypeId)this.vertex).get_name(), ((TypeId)this.vertex).is_type(), ((TypeId)this.vertex).is_excluded());
        }
        try {
            this.tc = this.tc.bindToSchema(internalGreqlEvaluator);
        }
        catch (UnknownTypeException unknownTypeException) {
            throw new UnknownTypeException(unknownTypeException.getTypeName(), this.createPossibleSourcePositions());
        }
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        return this.tc;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        OptimizerInfo optimizerInfo = this.query.getOptimizer().getOptimizerInfo();
        long l = optimizerInfo.getEdgeClassCount() + optimizerInfo.getVertexClassCount();
        return new VertexCosts(l, l, l);
    }

    @Override
    public double calculateEstimatedSelectivity() {
        double d;
        OptimizerInfo optimizerInfo = this.query.getOptimizer().getOptimizerInfo();
        if (this.tc != null) {
            d = this.tc.getFrequency(optimizerInfo);
        } else {
            int n = (int)Math.round((double)(optimizerInfo.getEdgeClassCount() + optimizerInfo.getVertexClassCount()) / 2.0);
            d = 1.0;
            TypeId typeId = (TypeId)this.getVertex();
            if (typeId.is_type()) {
                d = 1.0 / (double)n;
            } else {
                double d2 = (optimizerInfo.getAverageEdgeSubclasses() + optimizerInfo.getAverageVertexSubclasses()) / 2.0;
                d = d2 / (double)n;
            }
            if (typeId.is_excluded()) {
                d = 1.0 - d;
            }
        }
        logger.fine("TypeId estimated selectivity " + this.tc + ": " + d);
        return d;
    }

    @Override
    public String getLoggingName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((TypeId)this.vertex).getAttributedElementClass().getQualifiedName());
        if (((TypeId)this.vertex).is_type()) {
            stringBuilder.append("-type");
        }
        if (((TypeId)this.vertex).is_excluded()) {
            stringBuilder.append("-excluded");
        }
        return stringBuilder.toString();
    }
}

