/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.exception;

import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.serialising.GreqlSerializer;
import java.util.ArrayList;
import java.util.List;

public class QuerySourceException
extends GreqlException {
    private static final long serialVersionUID = 8525494291742693931L;
    private List<SourcePosition> positions;
    private final GreqlVertex element;

    public QuerySourceException(String string, GreqlVertex greqlVertex, List<SourcePosition> list, Throwable throwable) {
        super(string, throwable);
        this.element = greqlVertex;
        this.positions = list != null ? list : new ArrayList<SourcePosition>();
    }

    public QuerySourceException(String string, GreqlVertex greqlVertex, SourcePosition sourcePosition, Exception exception) {
        super(string, exception);
        this.element = greqlVertex;
        this.positions = new ArrayList<SourcePosition>();
        this.positions.add(sourcePosition);
    }

    public QuerySourceException(String string, GreqlVertex greqlVertex, List<SourcePosition> list) {
        this(string, greqlVertex, list, null);
    }

    public QuerySourceException(String string, GreqlVertex greqlVertex, SourcePosition sourcePosition) {
        this(string, greqlVertex, sourcePosition, null);
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.positions.size() > 0) {
            stringBuilder.append(super.getMessage());
            stringBuilder.append(": query part '");
            stringBuilder.append(this.element != null ? GreqlSerializer.serializeVertex(this.element) : "<unknown element>");
            stringBuilder.append("' at position (");
            stringBuilder.append(this.positions.get(0).get_offset());
            stringBuilder.append(", ");
            stringBuilder.append(this.positions.get(0).get_length());
            stringBuilder.append(")");
        } else {
            stringBuilder.append(super.getMessage());
            stringBuilder.append(": query part '");
            stringBuilder.append(this.element != null ? GreqlSerializer.serializeVertex(this.element) : "<unknown element>");
            stringBuilder.append("' at unknown position in query");
        }
        if (this.element != null) {
            try {
                String string = GreqlSerializer.serializeGraph((GreqlGraph)this.element.getGraph());
                stringBuilder.append("\nComplete (optimized) Query: ");
                stringBuilder.append(string);
            }
            catch (GreqlException greqlException) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    public List<SourcePosition> getSourcePositions() {
        return this.positions;
    }

    public int getOffset() {
        if (this.positions.size() < 0) {
            return 0;
        }
        return this.positions.get(0).get_offset();
    }

    public int getLength() {
        if (this.positions.size() < 0) {
            return 0;
        }
        return this.positions.get(0).get_length();
    }

    public GreqlVertex getElement() {
        return this.element;
    }
}

