/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.relations;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;

public class GrEqual
extends Function {
    @Description(params={"a", "b"}, description="Determines if $a \\geq b$. Alternative: a >= b", categories={Function.Category.RELATIONS})
    public GrEqual() {
        super(2L, 1L, 0.05);
    }

    public Boolean evaluate(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return Double.compare(number.doubleValue(), number2.doubleValue()) >= 0;
        }
        if (number instanceof Long || number2 instanceof Long) {
            return number.longValue() >= number2.longValue();
        }
        assert (number instanceof Integer && number2 instanceof Integer);
        return number.intValue() >= number2.intValue();
    }

    public <T extends Comparable<? super T>> Boolean evaluate(T t, T t2) {
        return t.compareTo(t2) >= 0;
    }
}

