/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import java.util.ArrayList;
import java.util.logging.Logger;

public class TransformXorFunctionApplicationOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(TransformXorFunctionApplicationOptimizer.class);

    TransformXorFunctionApplicationOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof TransformXorFunctionApplicationOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        GreqlGraph greqlGraph = greqlQuery.getQueryGraph();
        ArrayList<FunctionApplication> arrayList = new ArrayList<FunctionApplication>();
        for (FunctionApplication object : greqlGraph.getFunctionApplicationVertices()) {
            if (!OptimizerUtility.isXor(object)) continue;
            arrayList.add(object);
        }
        boolean bl = false;
        for (FunctionApplication functionApplication : arrayList) {
            bl = true;
            IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
            Expression expression = isArgumentOf.getAlpha();
            isArgumentOf = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN);
            Expression expression2 = isArgumentOf.getAlpha();
            FunctionApplication functionApplication2 = greqlGraph.createFunctionApplication();
            FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("or", greqlGraph);
            greqlGraph.createIsFunctionIdOf(functionId, functionApplication2);
            FunctionApplication functionApplication3 = greqlGraph.createFunctionApplication();
            FunctionApplication functionApplication4 = greqlGraph.createFunctionApplication();
            FunctionId functionId2 = OptimizerUtility.findOrCreateFunctionId("and", greqlGraph);
            greqlGraph.createIsFunctionIdOf(functionId2, functionApplication3);
            greqlGraph.createIsFunctionIdOf(functionId2, functionApplication4);
            FunctionApplication functionApplication5 = greqlGraph.createFunctionApplication();
            FunctionApplication functionApplication6 = greqlGraph.createFunctionApplication();
            FunctionId functionId3 = OptimizerUtility.findOrCreateFunctionId("not", greqlGraph);
            greqlGraph.createIsFunctionIdOf(functionId3, functionApplication5);
            greqlGraph.createIsFunctionIdOf(functionId3, functionApplication6);
            greqlGraph.createIsArgumentOf(functionApplication3, functionApplication2);
            greqlGraph.createIsArgumentOf(functionApplication4, functionApplication2);
            greqlGraph.createIsArgumentOf(expression, functionApplication3);
            greqlGraph.createIsArgumentOf(functionApplication5, functionApplication3);
            greqlGraph.createIsArgumentOf(expression2, functionApplication5);
            greqlGraph.createIsArgumentOf(expression, functionApplication6);
            greqlGraph.createIsArgumentOf(functionApplication6, functionApplication4);
            greqlGraph.createIsArgumentOf(expression2, functionApplication4);
            ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
            for (Edge edge = functionApplication.getFirstIncidence(EdgeDirection.OUT); edge != null; edge = edge.getNextIncidence(EdgeDirection.OUT)) {
                arrayList2.add(edge);
            }
            for (Edge edge : arrayList2) {
                edge.setAlpha(functionApplication2);
            }
            logger.finer(this.optimizerHeaderString() + "Transformed " + functionApplication + " to (" + expression + " & ~" + expression2 + ") | (~" + expression + " & " + expression2 + ").");
            functionApplication.delete();
        }
        return bl;
    }
}

