/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class VariableDeclarationOrderUnit
implements Comparable<VariableDeclarationOrderUnit> {
    private final Variable variable;
    private final Declaration declaringDeclaration;
    private final Set<Vertex> dependentVertices;
    private long variableValueChangeCosts = Long.MIN_VALUE;
    private long typeExpressionCardinality = Long.MIN_VALUE;
    private final GreqlQuery query;
    private final SimpleDeclaration simpleDeclarationOfVariable;
    private final Expression typeExpressionOfVariable;

    VariableDeclarationOrderUnit(Variable variable, Declaration declaration, GreqlQuery greqlQuery) {
        this.variable = variable;
        this.declaringDeclaration = declaration;
        this.query = greqlQuery;
        this.simpleDeclarationOfVariable = this.variable.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getOmega();
        this.typeExpressionOfVariable = this.simpleDeclarationOfVariable.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).getAlpha();
        this.dependentVertices = new HashSet<Vertex>();
        this.addDependendVertices(this.variable);
        while (this.extendDependendVertices()) {
        }
    }

    private void addDependendVertices(Vertex vertex) {
        if (vertex == this.simpleDeclarationOfVariable || vertex == this.declaringDeclaration) {
            return;
        }
        if (this.variable != vertex) {
            this.dependentVertices.add(vertex);
        }
        for (Edge edge : vertex.incidences(EdgeDirection.OUT)) {
            this.addDependendVertices(edge.getOmega());
        }
    }

    private boolean extendDependendVertices() {
        boolean bl = false;
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(this.dependentVertices.size());
        for (Vertex vertex : this.dependentVertices) {
            arrayList.add(vertex);
        }
        for (Vertex vertex : arrayList) {
            SimpleDeclaration simpleDeclaration;
            if (!(vertex instanceof SimpleDeclaration) || (simpleDeclaration = (SimpleDeclaration)vertex) == this.simpleDeclarationOfVariable) continue;
            for (Variable variable : simpleDeclaration.get_declaredVar()) {
                if (this.dependentVertices.contains(variable)) continue;
                bl = true;
                this.addDependendVertices(variable);
            }
        }
        return bl;
    }

    long getVariableValueChangeCosts() {
        if (this.variableValueChangeCosts == Long.MIN_VALUE) {
            this.variableValueChangeCosts = this.calculateVariableValueChangeCosts();
        }
        return this.variableValueChangeCosts;
    }

    private int calculateVariableValueChangeCosts() {
        int n = 0;
        for (Vertex vertex : this.dependentVertices) {
            VertexEvaluator<GreqlVertex> vertexEvaluator = ((GreqlQueryImpl)this.query).getVertexEvaluator((GreqlVertex)vertex);
            assert (vertexEvaluator != null);
            n = (int)((long)n + vertexEvaluator.getOwnEvaluationCosts());
        }
        return n;
    }

    Expression getTypeExpressionOfVariable() {
        return this.typeExpressionOfVariable;
    }

    public String toString() {
        return this.dependentVertices.size() + " Expressions depend on " + this.variable + " (" + this.variable.get_name() + ") resulting in costs of " + this.getVariableValueChangeCosts() + " on value changes.";
    }

    @Override
    public int compareTo(VariableDeclarationOrderUnit variableDeclarationOrderUnit) {
        long l;
        if (this == variableDeclarationOrderUnit) {
            return 0;
        }
        if (this.dependentVertices.contains(variableDeclarationOrderUnit.variable)) {
            assert (!variableDeclarationOrderUnit.dependentVertices.contains(this.variable)) : "Circular dependency!";
            return -1;
        }
        if (variableDeclarationOrderUnit.dependentVertices.contains(this.variable)) {
            assert (!this.dependentVertices.contains(variableDeclarationOrderUnit.variable)) : "Circular dependency!";
            return 1;
        }
        if (this.getVariableValueChangeCosts() < variableDeclarationOrderUnit.getVariableValueChangeCosts()) {
            return 1;
        }
        if (this.getVariableValueChangeCosts() > variableDeclarationOrderUnit.getVariableValueChangeCosts()) {
            return -1;
        }
        long l2 = this.getTypeExpressionCardinality();
        if (l2 > (l = variableDeclarationOrderUnit.getTypeExpressionCardinality())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        if (this.variable.getId() < variableDeclarationOrderUnit.getVariable().getId()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VariableDeclarationOrderUnit)) {
            return false;
        }
        return this.compareTo((VariableDeclarationOrderUnit)object) == 0;
    }

    public int hashCode() {
        int n = 991;
        return n * this.variable.hashCode() + n;
    }

    private long calculateTypeExpressionCardinality() {
        VertexEvaluator<Expression> vertexEvaluator = ((GreqlQueryImpl)this.query).getVertexEvaluator(this.typeExpressionOfVariable);
        return vertexEvaluator.getEstimatedCardinality();
    }

    long getTypeExpressionCardinality() {
        if (this.typeExpressionCardinality == Long.MIN_VALUE) {
            this.typeExpressionCardinality = this.calculateTypeExpressionCardinality();
        }
        return this.typeExpressionCardinality;
    }

    SimpleDeclaration getSimpleDeclarationOfVariable() {
        return this.simpleDeclarationOfVariable;
    }

    Variable getVariable() {
        return this.variable;
    }

    Declaration getDeclaringDeclaration() {
        return this.declaringDeclaration;
    }
}

