/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import java.util.ArrayList;

public class ConditionalExpression
extends Formula {
    protected Expression condition;
    protected Formula trueFormula;
    protected Formula falseFormula;

    public ConditionalExpression(GreqlQuery greqlQuery, Expression expression, Formula formula, Formula formula2) {
        super(greqlQuery);
        this.condition = expression;
        this.trueFormula = formula;
        this.falseFormula = formula2;
    }

    @Override
    public String toString() {
        return "(v" + this.condition.getId() + ") ? " + this.trueFormula + " : " + this.falseFormula + ";";
    }

    @Override
    public Expression toExpression() {
        GreqlGraph greqlGraph = this.query.getQueryGraph();
        de.uni_koblenz.jgralab.greql.schema.ConditionalExpression conditionalExpression = greqlGraph.createConditionalExpression();
        greqlGraph.createIsConditionOf(this.condition, conditionalExpression);
        greqlGraph.createIsTrueExprOf(this.trueFormula.toExpression(), conditionalExpression);
        greqlGraph.createIsFalseExprOf(this.falseFormula.toExpression(), conditionalExpression);
        return conditionalExpression;
    }

    @Override
    protected ArrayList<Expression> getNonConstantTermExpressions() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    protected Formula calculateReplacementFormula(Expression expression, Literal literal) {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public Formula simplify() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public double getSelectivity() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public boolean equals(Object object) {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }
}

