/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types.pathsearch;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;

public class VertexStateQueue {
    private static int initialSize = 100;
    public Vertex currentVertex = null;
    public State currentState = null;
    int size = initialSize;
    Vertex[] vertices = new Vertex[initialSize];
    State[] states = new State[initialSize];
    int last = 0;
    int first = 0;

    public VertexStateQueue() {
        this.size = initialSize;
    }

    public final void put(Vertex vertex, State state) {
        if (this.last == this.first + this.size - 1) {
            this.resize();
        }
        this.vertices[this.last % this.size] = vertex;
        this.states[this.last % this.size] = state;
        ++this.last;
    }

    public final boolean hasNext() {
        if (this.first == this.last) {
            return false;
        }
        this.currentVertex = this.vertices[this.first % this.size];
        this.currentState = this.states[this.first % this.size];
        ++this.first;
        return true;
    }

    private final void resize() {
        Vertex[] vertexArray = new Vertex[this.size * 2];
        State[] stateArray = new State[this.size * 2];
        for (int i = 0; i < this.size; ++i) {
            vertexArray[i] = this.vertices[(this.first + i) % this.size];
            stateArray[i] = this.states[(this.first + i) % this.size];
        }
        this.states = stateArray;
        this.vertices = vertexArray;
        this.last = this.size - 1;
        this.first = 0;
        this.size *= 2;
    }
}

