/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.Empty;
import org.pcollections.PSet;

public class CreateVertices
extends Transformation<PSet<? extends Vertex>> {
    private PSet<? extends Object> archetypes = null;
    private String semanticExpression = null;
    private VertexClass vertexClass = null;

    public CreateVertices(Context context, VertexClass vertexClass, PSet<? extends Object> pSet) {
        super(context);
        this.vertexClass = vertexClass;
        this.archetypes = pSet;
    }

    public CreateVertices(Context context, VertexClass vertexClass, String string) {
        super(context);
        this.vertexClass = vertexClass;
        this.semanticExpression = string;
    }

    public static CreateVertices parseAndCreate(ExecuteTransformation executeTransformation) {
        VertexClass vertexClass = executeTransformation.matchVertexClass();
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new CreateVertices(executeTransformation.context, vertexClass, string);
    }

    @Override
    protected PSet<? extends Vertex> transform() {
        if (this.context.phase != Context.TransformationPhase.GRAPH) {
            return null;
        }
        if (this.archetypes == null) {
            this.archetypes = (PSet)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        PSet pSet = Empty.set();
        for (Object e : this.archetypes) {
            Object t = this.context.targetGraph.createVertex(this.vertexClass);
            pSet = pSet.plus(t);
            this.context.addMapping(this.vertexClass, e, (AttributedElement<?, ?>)t);
        }
        return pSet;
    }
}

