/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pcollections.ArrayPSet;
import org.pcollections.PMap;

public class RecordImpl
implements Record {
    private PMap<String, Object> entries;
    private static RecordImpl empty = new RecordImpl();

    private RecordImpl() {
        this.entries = JGraLab.map();
    }

    private RecordImpl(PMap<String, Object> pMap) {
        this.entries = pMap;
    }

    public static RecordImpl empty() {
        return empty;
    }

    public RecordImpl plus(String string, Object object) {
        return new RecordImpl(this.entries.plus(string, object != null ? object : NullValue.NULL));
    }

    @Override
    public Object getComponent(String string) {
        if (this.entries.containsKey(string)) {
            return this.entries.get(string).equals((Object)NullValue.NULL) ? null : this.entries.get(string);
        }
        throw new NoSuchAttributeException("Record doesn't contain a component '" + string + "'");
    }

    @Override
    public void writeComponentValues(GraphIO graphIO) throws IOException, GraphIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasComponent(String string) {
        return this.entries.containsKey(string);
    }

    @Override
    public List<String> getComponentNames() {
        return ((ArrayPSet)this.entries.keySet()).toPVector();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    public int hashCode() {
        int n = 0;
        for (Object v : this.entries.values()) {
            n += v.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof RecordImpl) {
            return this.entries.equals(((RecordImpl)object).entries);
        }
        if (object instanceof Record) {
            Record record = (Record)object;
            if (this.size() != record.size()) {
                return false;
            }
            try {
                Iterator iterator = this.entries.values().iterator();
                for (String string : this.entries.keySet()) {
                    if (record.getComponent(string).equals(iterator.next())) continue;
                    return false;
                }
                return true;
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public PMap<String, Object> toPMap() {
        return this.entries;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean bl = true;
        for (Map.Entry entry : this.entries.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static enum NullValue {
        NULL;

    }
}

