/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IncidenceDirection;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.HashSet;

public class RolenameCodeGenerator {
    private final VertexClass vertexClass;
    private final String schemaRootPackageName;

    RolenameCodeGenerator(VertexClass vertexClass) {
        this.vertexClass = vertexClass;
        this.schemaRootPackageName = vertexClass.getSchema().getPackagePrefix() + ".";
    }

    private CodeBlock createRemoveAdjacenceSnippet(String string, EdgeClass edgeClass, VertexClass vertexClass, EdgeDirection edgeDirection, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("rolename", string);
        codeSnippet.setVariable("edgeClass", "#schemaPackage#." + edgeClass.getSimpleName() + ".EC");
        codeSnippet.setVariable("edgeClassName", this.schemaRootPackageName + edgeClass.getQualifiedName());
        codeSnippet.setVariable("dir", "EdgeDirection." + edgeDirection.toString());
        codeSnippet.setVariable("definingVertexClassName", this.schemaRootPackageName + vertexClass.getQualifiedName());
        if (!bl) {
            codeSnippet.add("/**", " * removes the given vertex as <code>#rolename#</code> from this vertex, i.e. ", " * deletes the <code>#edgeClassName#</code> edge connections of this vertex with ", " * the given one.", " */", "public boolean remove_#rolename#(#definingVertexClassName# vertex);");
        } else {
            codeSnippet.add("@Override", "public boolean remove_#rolename#(#definingVertexClassName# vertex) {", "\tboolean elementRemoved = false;", "\t#edgeClassName# edge = (#edgeClassName#) getFirstIncidence(#edgeClassName#.EC, #dir#);", "\twhile (edge != null) {", "\t\t#edgeClassName# next = (#edgeClassName#) edge.getNextIncidence(#edgeClassName#.EC, #dir#);", "\t\tif (edge.getThat().equals(vertex)) {\t\t\tedge.delete();", "\t\t\telementRemoved = true;", "\t\t}", "\t\tedge = next;", "\t}", "\treturn elementRemoved;", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createRemoveAllAdjacencesSnippet(String string, EdgeClass edgeClass, VertexClass vertexClass, EdgeDirection edgeDirection, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("rolename", string);
        codeSnippet.setVariable("edgeClassName", this.schemaRootPackageName + edgeClass.getQualifiedName());
        codeSnippet.setVariable("dir", "EdgeDirection." + edgeDirection.toString());
        codeSnippet.setVariable("vertexClassName", this.schemaRootPackageName + vertexClass.getQualifiedName());
        if (!bl) {
            codeSnippet.add("/**", " * removes all #rolename# adjacences to all vertices by ", " * deleting the <code>#edgeClassName#</code> edges of this vertex to ", " * all other ones, but doesn't delete those vertices.", " *", " * @return the adjacent vertices prior to removal of incidences", " */", "public java.util.List<? extends #vertexClassName#> remove_#rolename#();");
        } else {
            codeSnippet.add("@Override", "public java.util.List<? extends #vertexClassName#> remove_#rolename#() {", "\tjava.util.List<#vertexClassName#> adjacences = new java.util.ArrayList<#vertexClassName#>();", "\t#edgeClassName# edge = (#edgeClassName#) getFirstIncidence(#edgeClassName#.EC, #dir#);", "\twhile (edge != null) {", "\t\t#edgeClassName# next = (#edgeClassName#) edge.getNextIncidence(#edgeClassName#.EC, #dir#);", "\t\tadjacences.add((#vertexClassName#) edge.getThat());", "\t\tedge.delete();", "\t\tedge = next;", "\t}", "\treturn adjacences;", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createGetAdjacencesSnippet(IncidenceClass incidenceClass, VertexClass vertexClass, VertexClass vertexClass2, EdgeDirection edgeDirection, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("rolename", incidenceClass.getRolename());
        codeSnippet.setVariable("edgeClassName", this.schemaRootPackageName + incidenceClass.getEdgeClass().getQualifiedName());
        codeSnippet.setVariable("dir", "EdgeDirection." + edgeDirection.toString());
        codeSnippet.setVariable("vertexClassName", this.schemaRootPackageName + vertexClass.getQualifiedName());
        codeSnippet.setVariable("definingVertexClassName", this.schemaRootPackageName + vertexClass2.getQualifiedName());
        if (incidenceClass.getMax() == 1) {
            if (!bl) {
                codeSnippet.add("/**", " * @return the vertex to this one with the rolename '#rolename#' ", " *         (connected with a <code>#edgeClassName#</code> edge), or null if no such vertex exists", " */", "public #vertexClassName# get_#rolename#();");
            } else {
                codeSnippet.add("@Override", "public #vertexClassName# get_#rolename#() {", "\t#edgeClassName# edge = (#edgeClassName#) getFirstIncidence(#edgeClassName#.EC, #dir#);", "\tif (edge != null) {", "\t\treturn (#vertexClassName#) edge.getThat();", "\t}", "\treturn null;", "}");
            }
        } else if (!bl) {
            codeSnippet.add("/**", " * @return an Iterable of all vertices adjacent to this one with the rolename '#rolename#'", " *         (connected with a <code>#edgeClassName#</code> edge).", " */", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#();", "", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#(#jgPackage#.VertexFilter<V> filter);");
        } else {
            codeSnippet.add("@Override", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#() {", "\treturn new de.uni_koblenz.jgralab.impl.NeighbourIterable<#edgeClassName#, V>(this, #edgeClassName#.EC, #dir#, null);", "}", "", "@Override", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#(#jgPackage#.VertexFilter<V> filter) {", "\treturn new de.uni_koblenz.jgralab.impl.NeighbourIterable<#edgeClassName#, V>(this, #edgeClassName#.EC, #dir#, filter);", "}");
        }
        return codeSnippet;
    }

    private CodeBlock createAddRolenameSnippet(String string, EdgeClass edgeClass, VertexClass vertexClass, VertexClass vertexClass2, EdgeDirection edgeDirection, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("rolename", string);
        codeSnippet.setVariable("edgeClassName", this.schemaRootPackageName + edgeClass.getQualifiedName());
        codeSnippet.setVariable("edgeClass", "#edgeClassName#.EC");
        codeSnippet.setVariable("graphClassName", this.schemaRootPackageName + edgeClass.getGraphClass().getQualifiedName());
        codeSnippet.setVariable("definingVertexClassName", this.schemaRootPackageName + vertexClass.getQualifiedName());
        codeSnippet.setVariable("allowedVertexClassName", this.schemaRootPackageName + vertexClass2.getQualifiedName());
        codeSnippet.setVariable("thisVertexClassName", this.schemaRootPackageName + this.vertexClass.getQualifiedName());
        if (edgeDirection == EdgeDirection.OUT) {
            codeSnippet.setVariable("alpha", "this");
            codeSnippet.setVariable("alphaVertexClassName", this.schemaRootPackageName + this.vertexClass.getQualifiedName());
            codeSnippet.setVariable("omega", "vertex");
            codeSnippet.setVariable("omegaVertexClassName", this.schemaRootPackageName + vertexClass2.getQualifiedName());
        } else {
            codeSnippet.setVariable("alpha", "vertex");
            codeSnippet.setVariable("alphaVertexClassName", this.schemaRootPackageName + vertexClass2.getQualifiedName());
            codeSnippet.setVariable("omega", "this");
            codeSnippet.setVariable("omegaVertexClassName", this.schemaRootPackageName + this.vertexClass.getQualifiedName());
        }
        if (!bl) {
            codeSnippet.add("/**", " * adds the given vertex as <code>#rolename#</code> to this vertex, i.e. creates an", " * <code>#edgeClassName#</code> edge from this vertex to the given ", " * one and returns the created edge.", " * @return  a newly created edge of type <code>#edgeClassName#</code>", " *          between this vertex and the given one.", " */", "public #edgeClassName# add_#rolename#(#definingVertexClassName# vertex);");
        } else {
            codeSnippet.add("@Override", "public #edgeClassName# add_#rolename#(#definingVertexClassName# vertex) {");
            codeSnippet.add("\treturn ((#graphClassName#)getGraph()).createEdge(#edgeClass#, (#alphaVertexClassName#) #alpha#, (#omegaVertexClassName#) #omega#);", "}");
        }
        return codeSnippet;
    }

    public CodeBlock createRolenameMethods(boolean bl) {
        CodeList codeList = new CodeList();
        HashSet<IncidenceClass> hashSet = new HashSet<IncidenceClass>();
        hashSet.addAll(this.vertexClass.getValidFromFarIncidenceClasses());
        hashSet.addAll(this.vertexClass.getValidToFarIncidenceClasses());
        for (IncidenceClass incidenceClass : hashSet) {
            codeList.add(this.createMethodsForOneIncidenceClass(incidenceClass, incidenceClass, bl));
        }
        return codeList;
    }

    private CodeList createMethodsForOneIncidenceClass(IncidenceClass incidenceClass, IncidenceClass incidenceClass2, boolean bl) {
        CodeList codeList = new CodeList();
        String string = incidenceClass2.getRolename();
        if (!string.isEmpty()) {
            EdgeClass edgeClass = incidenceClass.getEdgeClass();
            VertexClass vertexClass = incidenceClass2.getVertexClass();
            VertexClass vertexClass2 = incidenceClass.getVertexClass();
            EdgeDirection edgeDirection = incidenceClass.getDirection() == IncidenceDirection.OUT ? EdgeDirection.IN : EdgeDirection.OUT;
            codeList.addNoIndent(this.createAddRolenameSnippet(string, edgeClass, vertexClass, vertexClass2, edgeDirection, bl));
            codeList.addNoIndent(this.createRemoveAllAdjacencesSnippet(string, edgeClass, vertexClass2, edgeDirection, bl));
            codeList.addNoIndent(this.createRemoveAdjacenceSnippet(string, edgeClass, vertexClass, edgeDirection, bl));
            codeList.addNoIndent(this.createGetAdjacencesSnippet(incidenceClass2, vertexClass2, vertexClass, edgeDirection, bl));
        }
        return codeList;
    }
}

