/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.CompositeDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.io.IOException;
import java.util.Iterator;
import org.pcollections.PMap;

public final class MapDomainImpl
extends CompositeDomainImpl
implements MapDomain {
    private final Domain keyDomain;
    private final Domain valueDomain;

    MapDomainImpl(Schema schema, Domain domain, Domain domain2) {
        super("Map<" + domain.getTGTypeName(schema.getDefaultPackage()) + ", " + domain2.getTGTypeName(schema.getDefaultPackage()) + ">", (PackageImpl)schema.getDefaultPackage());
        if (this.parentPackage.getSchema().getDomain(domain.getQualifiedName()) == null) {
            throw new SchemaException("Key domain '" + domain.getQualifiedName() + "' not existent in schema " + this.parentPackage.getSchema().getQualifiedName());
        }
        if (this.parentPackage.getSchema().getDomain(domain2.getQualifiedName()) == null) {
            throw new SchemaException("Value domain '" + domain2.getQualifiedName() + "' not existent in schema " + this.parentPackage.getSchema().getQualifiedName());
        }
        this.keyDomain = domain;
        this.valueDomain = domain2;
        ((SchemaImpl)schema).addDomainDependency(this, this.keyDomain);
        ((SchemaImpl)schema).addDomainDependency(this, this.valueDomain);
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return "org.pcollections.PMap<" + this.keyDomain.getJavaClassName(string) + ", " + this.valueDomain.getJavaClassName(string) + ">";
    }

    @Override
    public String getJavaClassName(String string) {
        return this.getJavaAttributeImplementationTypeName(string);
    }

    @Override
    public Domain getKeyDomain() {
        return this.keyDomain;
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3, boolean bl) {
        CodeList codeList = new CodeList();
        codeList.setVariable("init", "");
        this.internalGetReadMethod(codeList, string, string2, string3, bl);
        return codeList;
    }

    @Override
    public String getTGTypeName(Package package_) {
        return "Map<" + this.keyDomain.getTGTypeName(package_) + ", " + this.valueDomain.getTGTypeName(package_) + ">";
    }

    @Override
    public Domain getValueDomain() {
        return this.valueDomain;
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        CodeList codeList = new CodeList();
        codeList.setVariable("name", string2);
        this.internalGetWriteMethod(codeList, string, string2, string3);
        return codeList;
    }

    @Override
    public String toString() {
        return "domain Map<" + this.keyDomain.toString() + ", " + this.valueDomain.toString() + ">";
    }

    private void internalGetReadMethod(CodeList codeList, String string, String string2, String string3, boolean bl) {
        codeList.setVariable("name", string2);
        codeList.setVariable("empty", "de.uni_koblenz.jgralab.JGraLab.map()");
        codeList.setVariable("keydom", this.getKeyDomain().getJavaClassName(string));
        codeList.setVariable("keytype", this.getKeyDomain().getJavaAttributeImplementationTypeName(string));
        codeList.setVariable("valuedom", this.getValueDomain().getJavaClassName(string));
        codeList.setVariable("valuetype", this.getValueDomain().getJavaAttributeImplementationTypeName(string));
        codeList.setVariable("io", string3);
        codeList.addNoIndent(new CodeSnippet("#init#"));
        if (bl) {
            codeList.addNoIndent(new CodeSnippet("boolean attrIsSet = true;"));
        }
        codeList.addNoIndent(new CodeSnippet("if (#io#.isNextToken(#token#.LCRL)) {"));
        codeList.add(new CodeSnippet("org.pcollections.PMap<#keydom#, #valuedom#> $#name# = #empty#;"));
        codeList.add(new CodeSnippet("#io#.match();", "while (!#io#.isNextToken(#token#.RCRL)) {"));
        if (this.getKeyDomain().isComposite()) {
            codeList.add(new CodeSnippet("\t#keytype# #name#Key = null;"));
        } else {
            codeList.add(new CodeSnippet("\t#keytype# #name#Key;"));
        }
        if (this.getValueDomain().isComposite()) {
            codeList.add(new CodeSnippet("\t\t#valuetype# #name#Value = null;"));
        } else {
            codeList.add(new CodeSnippet("\t\t#valuetype# #name#Value;"));
        }
        codeList.add(this.getKeyDomain().getReadMethod(string, string2 + "Key", string3, false), 1);
        codeList.add(new CodeSnippet("\t#io#.match(#token#.HYPHEN);"));
        codeList.add(this.getValueDomain().getReadMethod(string, string2 + "Value", string3, false), 1);
        codeList.add(new CodeSnippet("\t$#name# = $#name#.plus(#name#Key, #name#Value);", "}", "#io#.match();", "#name# = $#name#;"));
        codeList.addNoIndent(new CodeSnippet("} else if (#io#.isNextToken(#token#.NULL_LITERAL)) {"));
        codeList.add(new CodeSnippet("#io#.match();", "#name# = null;"));
        if (bl) {
            codeList.addNoIndent(new CodeSnippet("} else if (#io#.isNextToken(#token#.UNSET)) {", "\t#io#.match();", "\tattrIsSet = false;"));
        }
        codeList.addNoIndent(new CodeSnippet("} else {", "\tthrow new GraphIOException(\"Unknown Map value\");", "}"));
    }

    private void internalGetWriteMethod(CodeList codeList, String string, String string2, String string3) {
        codeList.setVariable("nameKey", "key");
        codeList.setVariable("nameValue", "value");
        codeList.setVariable("keytype", this.getKeyDomain().getJavaAttributeImplementationTypeName(string));
        codeList.setVariable("valuetype", this.getValueDomain().getJavaAttributeImplementationTypeName(string));
        codeList.setVariable("io", string3);
        codeList.addNoIndent(new CodeSnippet("if (#name# != null) {"));
        codeList.add(new CodeSnippet("#io#.write(\"{\");"));
        codeList.add(new CodeSnippet("for (#keytype# #nameKey#: #name#.keySet()) {"));
        codeList.add(new CodeSnippet("#valuetype# #nameValue# = #name#.get(#nameKey#);"), 1);
        codeList.add(this.getKeyDomain().getWriteMethod(string, codeList.getVariable("nameKey"), string3), 1);
        codeList.add(new CodeSnippet("\t#io#.write(\" -\");"));
        codeList.add(this.getValueDomain().getWriteMethod(string, codeList.getVariable("nameValue"), string3), 1);
        codeList.add(new CodeSnippet("}", "#io#.write(\"}\");"));
        codeList.addNoIndent(new CodeSnippet("} else {"));
        codeList.add(new CodeSnippet(string3 + ".writeIdentifier(GraphIO.NULL_LITERAL);"));
        codeList.addNoIndent(new CodeSnippet("}"));
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        if (graphIO.isNextToken(TgLexer.Token.UNSET)) {
            graphIO.match();
            return GraphIO.Unset.UNSET;
        }
        if (graphIO.isNextToken(TgLexer.Token.LCRL)) {
            PMap<Object, Object> pMap = JGraLab.map();
            graphIO.match();
            while (!graphIO.isNextToken(TgLexer.Token.RCRL)) {
                Object object = null;
                Object object2 = null;
                object = this.getKeyDomain().parseGenericAttribute(graphIO);
                graphIO.match(TgLexer.Token.HYPHEN);
                object2 = this.getValueDomain().parseGenericAttribute(graphIO);
                pMap = pMap.plus(object, object2);
            }
            graphIO.match();
            return pMap;
        }
        if (graphIO.isNextToken(TgLexer.Token.NULL_LITERAL)) {
            graphIO.match();
            return null;
        }
        return null;
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        if (object != null) {
            graphIO.write("{");
            for (Object k : ((PMap)object).keySet()) {
                this.getKeyDomain().serializeGenericAttribute(graphIO, k);
                graphIO.write("-");
                this.getValueDomain().serializeGenericAttribute(graphIO, ((PMap)object).get(k));
            }
            graphIO.write("}");
        } else {
            graphIO.writeIdentifier(GraphIO.NULL_LITERAL);
        }
    }

    @Override
    protected void registerAttribute(Attribute attribute) {
        this.attributes = this.attributes.plus(attribute);
        ((DomainImpl)this.keyDomain).registerAttribute(attribute);
        ((DomainImpl)this.valueDomain).registerAttribute(attribute);
    }

    @Override
    public boolean isConformValue(Object object) {
        boolean bl = true;
        if (object == null) {
            return bl;
        }
        if (!(bl &= object instanceof PMap)) {
            return false;
        }
        Iterator iterator = ((PMap)object).keySet().iterator();
        while (iterator.hasNext() && bl) {
            Object k = iterator.next();
            bl &= this.getKeyDomain().isConformValue(k) && this.getValueDomain().isConformValue(((PMap)object).get(k));
        }
        return bl;
    }
}

