/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.pcollections.ArrayPSet;
import org.pcollections.PSet;

public final class PackageImpl
extends NamedElementImpl
implements Package {
    final Map<String, Domain> domains = new TreeMap<String, Domain>();
    final Map<String, EdgeClass> edgeClasses = new TreeMap<String, EdgeClass>();
    final Map<String, VertexClass> vertexClasses = new TreeMap<String, VertexClass>();
    private final Map<String, Package> subPackages = new TreeMap<String, Package>();

    static PackageImpl createDefaultPackage(Schema schema) {
        assert (schema.getDefaultPackage() == null) : "DefaultPackage already created!";
        return new PackageImpl((SchemaImpl)schema);
    }

    private PackageImpl(SchemaImpl schemaImpl) {
        this("", null, schemaImpl);
    }

    PackageImpl(String string, PackageImpl packageImpl, SchemaImpl schemaImpl) {
        super(string, packageImpl, schemaImpl);
        if (packageImpl != null) {
            packageImpl.addSubPackage(this);
        }
        schemaImpl.addPackage(this);
    }

    void addDomain(Domain domain) {
        assert (domain.getPackage() == this) : "The domain does not belong into this package (" + this.getQualifiedName() + "). It belongs here: " + domain.getPackageName();
        assert (!this.domains.containsKey(domain.getSimpleName()) && !this.domains.containsValue(domain)) : "This package (" + this.getQualifiedName() + ") already contains a domain called " + domain.getSimpleName();
        this.domains.put(domain.getSimpleName(), domain);
    }

    void addEdgeClass(EdgeClass edgeClass) {
        assert (edgeClass.getPackage() == this) : "The edge class '" + edgeClass.getQualifiedName() + "' does not belong into the package '" + this.getQualifiedName() + "' but into '" + edgeClass.getPackageName() + "'.";
        assert (!this.edgeClasses.containsKey(edgeClass.getSimpleName()) && !this.edgeClasses.containsValue(edgeClass)) : "This package (" + this.getQualifiedName() + ") already contains an edge class called " + edgeClass.getSimpleName();
        if (!(this.isDefaultPackage() && edgeClass.getSimpleName().equals("Edge") || this.isDefaultPackage() && edgeClass.getSimpleName().equals("TemporaryEdgeClass"))) {
            this.edgeClasses.put(edgeClass.getSimpleName(), edgeClass);
        }
    }

    void addSubPackage(Package package_) {
        assert (package_.getPackage() == this) : "The subpackage does not belong into the package '" + this.getQualifiedName() + "' but into '" + package_.getPackageName() + "'.";
        assert (!this.subPackages.containsKey(package_.getSimpleName())) : "The package '" + this.getQualifiedName() + "' already contains a subpackage called '" + package_.getSimpleName() + "'.";
        this.subPackages.put(package_.getSimpleName(), package_);
    }

    void addVertexClass(VertexClass vertexClass) {
        assert (vertexClass.getPackage() == this) : "The vertex class '" + vertexClass.getQualifiedName() + "' does not belong into the package '" + this.getQualifiedName() + "' but into '" + vertexClass.getPackageName() + "'";
        assert (!this.vertexClasses.containsKey(vertexClass.getSimpleName()) && !this.vertexClasses.containsValue(vertexClass)) : "This package (" + this.getQualifiedName() + ") already contains a vertex class called \"" + vertexClass.getSimpleName() + "\"";
        if (!(this.isDefaultPackage() && vertexClass.getSimpleName().equals("Vertex") || this.isDefaultPackage() && vertexClass.getSimpleName().equals("TemporaryVertexClass"))) {
            this.vertexClasses.put(vertexClass.getSimpleName(), vertexClass);
        }
    }

    @Override
    public boolean containsNamedElement(String string) {
        return this.domains.containsKey(string) || this.edgeClasses.containsKey(string) || this.vertexClasses.containsKey(string) || this.subPackages.containsKey(string);
    }

    @Override
    public PSet<Domain> getDomains() {
        return ArrayPSet.empty().plusAll(this.domains.values());
    }

    @Override
    public PSet<EdgeClass> getEdgeClasses() {
        return ArrayPSet.empty().plusAll(this.edgeClasses.values());
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Package getSubPackage(String string) {
        return this.subPackages.get(string);
    }

    @Override
    public PSet<Package> getSubPackages() {
        return ArrayPSet.empty().plusAll(this.subPackages.values());
    }

    @Override
    public PSet<VertexClass> getVertexClasses() {
        return ArrayPSet.empty().plusAll(this.vertexClasses.values());
    }

    @Override
    public boolean isDefaultPackage() {
        return this == this.schema.getDefaultPackage();
    }

    @Override
    public String toString() {
        return "package " + this.qualifiedName;
    }

    @Override
    public String getUniqueName() {
        return this.qualifiedName;
    }

    @Override
    public void setQualifiedName(String string) {
        if (this.schema.getDefaultPackage() == this) {
            throw new SchemaException("Cannot rename the default package.");
        }
        if (this.qualifiedName.equals(string)) {
            return;
        }
        if (this.schema.knows(string)) {
            throw new SchemaException(string + " is already known to the schema.");
        }
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!NamedElementImpl.PACKAGE_NAME_PATTERN.matcher(string3).matches()) {
            throw new SchemaException("Invalid package name '" + string3 + "'.");
        }
        this.unregister();
        this.qualifiedName = string;
        this.simpleName = string3;
        this.parentPackage = this.schema.createPackageWithParents(string2);
        LinkedList<NamedElement> linkedList = new LinkedList<NamedElement>();
        linkedList.addAll(this.vertexClasses.values());
        linkedList.addAll(this.edgeClasses.values());
        linkedList.addAll(this.subPackages.values());
        for (NamedElement namedElement : linkedList) {
            namedElement.setQualifiedName(this.qualifiedName + "." + namedElement.getSimpleName());
        }
        this.register();
    }

    @Override
    protected final void register() {
        super.register();
        this.parentPackage.subPackages.put(this.simpleName, this);
    }

    @Override
    protected final void unregister() {
        super.unregister();
        this.parentPackage.subPackages.remove(this.simpleName);
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (this.isDefaultPackage()) {
            throw new SchemaException("The default package cannot be deleted.");
        }
        if (this.domains.size() != 0 || this.vertexClasses.size() != 0 || this.edgeClasses.size() != 0) {
            throw new SchemaException("Only empty packages can be deleted!");
        }
        this.parentPackage.subPackages.remove(this.simpleName);
        this.schema.packages.remove(this.qualifiedName);
        this.schema.namedElements.remove(this.qualifiedName);
    }

    @Override
    public EdgeClass getEdgeClass(String string) {
        return this.edgeClasses.get(string);
    }

    @Override
    public Domain getDomain(String string) {
        return this.domains.get(string);
    }

    @Override
    public VertexClass getVertexClass(String string) {
        return this.vertexClasses.get(string);
    }
}

