/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.ant;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Schema;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;

public class DeleteGeneratedSchemaTask
extends Task {
    private Set<String> tgFiles = new HashSet<String>();
    private String sourcePath;

    public void setSchemaFile(String string) {
        this.tgFiles.add(string);
    }

    public void setSourcePath(String string) {
        this.sourcePath = string;
    }

    public void addConfiguredFileset(FileSet fileSet) {
        for (Object e : fileSet) {
            if (!(e instanceof FileResource)) continue;
            File file = ((FileResource)e).getFile();
            this.tgFiles.add(file.getAbsolutePath());
        }
    }

    public void execute() {
        try {
            for (String string : this.tgFiles) {
                if (new File(string).exists()) {
                    Schema schema = GraphIO.loadSchemaFromFile(string);
                    DeleteGeneratedSchemaTask.deleteGeneratedSchema(this.sourcePath, schema);
                    continue;
                }
                System.err.println("Warning: could not delete generated schema files: \"" + string + "\" could not be found.");
            }
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
            throw new BuildException((Throwable)graphIOException);
        }
    }

    public static void deleteGeneratedSchema(String string, Schema schema) throws GraphIOException {
        String string2 = string + File.separator + schema.getPathName();
        File file = new File(string2);
        if (file.exists()) {
            assert (file.isDirectory());
            DeleteGeneratedSchemaTask.deleteTree(file);
            System.out.println("Deleted schema from directory " + file.getAbsolutePath());
        }
    }

    public static void deleteTree(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            for (File file2 : file.listFiles()) {
                DeleteGeneratedSchemaTask.deleteTree(file2);
            }
            file.delete();
        }
    }
}

