/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.ant;

import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.utilities.ant.DeleteGeneratedSchemaTask;
import de.uni_koblenz.jgralab.utilities.tgschema2java.TgSchema2Java;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;

public class TgSchema2JavaTask
extends Task {
    private TgSchema2Java executeObject = new TgSchema2Java();
    private Set<String> schemaLocation;
    private String commitPath;

    public TgSchema2JavaTask() {
        this.executeObject.setTypeSpecificMethodSupport(true);
        this.schemaLocation = new HashSet<String>();
    }

    public void setSourcePath(String string) {
        this.commitPath = string;
    }

    public void setSchemaFile(String string) {
        this.schemaLocation.add(string);
    }

    public void setWithoutTypes(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("true") || string2.equals("yes")) {
            this.executeObject.setTypeSpecificMethodSupport(false);
        } else if (!string2.equals("false") && !string2.equals("no")) {
            throw new BuildException("Invalid value for boolean field: " + string);
        }
    }

    public void addConfiguredFileset(FileSet fileSet) {
        for (Object e : fileSet) {
            if (!(e instanceof FileResource)) continue;
            File file = ((FileResource)e).getFile();
            this.schemaLocation.add(file.getAbsolutePath());
        }
    }

    public void execute() {
        if (this.schemaLocation == null) {
            throw new BuildException("Schema file not set.");
        }
        if (this.commitPath == null) {
            throw new BuildException("Source path not set.");
        }
        this.executeObject.setCommitPath(this.commitPath);
        try {
            for (String string : this.schemaLocation) {
                this.executeObject.loadSchema(string);
                DeleteGeneratedSchemaTask.deleteGeneratedSchema(this.commitPath, this.executeObject.getSchema());
                this.executeObject.execute();
            }
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
            throw new BuildException((Throwable)graphIOException);
        }
    }
}

