/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import de.uni_koblenz.ist.utilities.gui.DrawingPanel;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.utilities.gui.xdot.ElementSelectionEvent;
import de.uni_koblenz.jgralab.utilities.gui.xdot.ElementSelectionListener;
import de.uni_koblenz.jgralab.utilities.gui.xdot.TextShape;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotParser;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class XDotPanel
extends DrawingPanel {
    private static final long serialVersionUID = 1L;
    private Graph graph;
    private List<XDotShape> shapes;
    private GraphMarker<List<XDotShape>> elementShapes;
    private GraphMarker<Rectangle> elementBoxes;
    private GraphMarker<Rectangle> elementTexts;
    private Stroke standardStroke;
    private Stroke dashedStroke;
    private Stroke thickStroke;
    private Stroke thickDashedStroke;
    private boolean trackMouseMotion;
    private AttributedElement<?, ?> hoverElement;
    private List<ElementSelectionListener> listenerList;

    public XDotPanel(Graph graph, InputStream inputStream) throws IOException {
        super(true, false);
        this.setBackground(Color.WHITE);
        this.setGraph(graph, inputStream);
        this.standardStroke = new BasicStroke(1.0f, 1, 1);
        this.thickStroke = new BasicStroke(2.5f, 1, 1);
        float[] fArray = new float[]{5.0f, 5.0f};
        this.dashedStroke = new BasicStroke(1.0f, 1, 1, 1.0f, fArray, 0.0f);
        this.thickDashedStroke = new BasicStroke(2.5f, 1, 1, 1.0f, fArray, 0.0f);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                AttributedElement<?, ?> attributedElement;
                if (XDotPanel.this.trackMouseMotion && (attributedElement = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(mouseEvent.getPoint()))) != XDotPanel.this.hoverElement) {
                    XDotPanel.this.hoverElement = attributedElement;
                    XDotPanel.this.fireMouseOver(new ElementSelectionEvent(attributedElement, mouseEvent));
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                AttributedElement<?, ?> attributedElement;
                if (XDotPanel.this.trackMouseMotion && (attributedElement = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(mouseEvent.getPoint()))) != XDotPanel.this.hoverElement) {
                    XDotPanel.this.hoverElement = attributedElement;
                    XDotPanel.this.fireMouseOver(new ElementSelectionEvent(attributedElement, mouseEvent));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AttributedElement<?, ?> attributedElement = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(mouseEvent.getPoint()));
                XDotPanel.this.fireMousePressed(new ElementSelectionEvent(attributedElement, mouseEvent));
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AttributedElement<?, ?> attributedElement = XDotPanel.this.getElementAt(XDotPanel.this.screenToModel(mouseEvent.getPoint()));
                XDotPanel.this.fireMouseReleased(new ElementSelectionEvent(attributedElement, mouseEvent));
            }
        });
        this.listenerList = new ArrayList<ElementSelectionListener>();
    }

    public void setGraph(Graph graph, InputStream inputStream) throws IOException {
        this.graph = graph;
        this.elementShapes = new GraphMarker(graph);
        XDotParser xDotParser = new XDotParser(this.graph, this.elementShapes);
        this.shapes = xDotParser.parseXDotFile(new BufferedInputStream(inputStream));
        Rectangle2D rectangle2D = xDotParser.getBounds();
        if (rectangle2D != null) {
            this.setBoundingBox(rectangle2D);
        }
        this.elementBoxes = null;
    }

    private void fireMousePressed(ElementSelectionEvent elementSelectionEvent) {
        for (ElementSelectionListener elementSelectionListener : this.listenerList) {
            elementSelectionListener.mousePressed(elementSelectionEvent);
        }
    }

    private void fireMouseReleased(ElementSelectionEvent elementSelectionEvent) {
        for (ElementSelectionListener elementSelectionListener : this.listenerList) {
            elementSelectionListener.mouseReleased(elementSelectionEvent);
        }
    }

    private void fireMouseOver(ElementSelectionEvent elementSelectionEvent) {
        for (ElementSelectionListener elementSelectionListener : this.listenerList) {
            elementSelectionListener.mouseOver(elementSelectionEvent);
        }
    }

    public void addElementSelectionListener(ElementSelectionListener elementSelectionListener) {
        if (!this.listenerList.contains(elementSelectionListener)) {
            this.listenerList.add(elementSelectionListener);
            this.trackMouseMotion = true;
        }
    }

    public void removeElementSelectionListener(ElementSelectionListener elementSelectionListener) {
        this.listenerList.remove(elementSelectionListener);
        if (this.listenerList.isEmpty()) {
            this.trackMouseMotion = false;
        }
    }

    private void computeBoundingBoxes() {
        this.elementBoxes = new GraphMarker(this.graph);
        this.elementTexts = new GraphMarker(this.graph);
        for (AttributedElement attributedElement : this.elementShapes.getMarkedElements()) {
            List list = (List)this.elementShapes.get(attributedElement);
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            for (XDotShape xDotShape : list) {
                if (xDotShape.getShape() instanceof TextShape) {
                    if (rectangle2 == null) {
                        rectangle2 = new Rectangle(xDotShape.getShape().getBounds());
                        continue;
                    }
                    rectangle2 = rectangle2.union(xDotShape.getShape().getBounds());
                    continue;
                }
                if (rectangle == null) {
                    rectangle = new Rectangle(xDotShape.getShape().getBounds());
                    continue;
                }
                rectangle = rectangle.union(xDotShape.getShape().getBounds());
            }
            this.elementBoxes.mark(attributedElement, rectangle);
            this.elementTexts.mark(attributedElement, rectangle2);
        }
    }

    @Override
    protected void paintContent(Graphics2D graphics2D) {
        for (XDotShape xDotShape : this.shapes) {
            graphics2D.setStroke(this.standardStroke);
            xDotShape.draw(graphics2D);
        }
        if (this.elementBoxes == null) {
            this.computeBoundingBoxes();
        }
    }

    protected AttributedElement<?, ?> getElementAt(Point point) {
        Rectangle rectangle;
        int n = Integer.MAX_VALUE;
        AttributedElement object = null;
        for (XDotShape object2 : this.shapes) {
            rectangle = object2.getShape().getBounds();
            if (rectangle.width * rectangle.height >= n || !rectangle.contains(point)) continue;
            n = rectangle.width * rectangle.height;
            object = object2.getElement();
        }
        if (this.elementBoxes != null) {
            for (AttributedElement attributedElement : this.elementBoxes.getMarkedElements()) {
                rectangle = (Rectangle)this.elementTexts.get(attributedElement);
                if (rectangle != null && rectangle.width * rectangle.height < n && rectangle.contains(point)) {
                    n = rectangle.width * rectangle.height;
                    object = attributedElement;
                }
                if ((rectangle = (Rectangle)this.elementBoxes.get(attributedElement)) == null || rectangle.width * rectangle.height >= n || !rectangle.contains(point)) continue;
                n = rectangle.width * rectangle.height;
                object = attributedElement;
            }
        }
        return object;
    }

    public void setElementColors(AttributedElement<?, ?> attributedElement, Color color, Color color2, Color color3) {
        assert (color != null);
        assert (color2 != null);
        assert (color3 != null);
        List list = (List)this.elementShapes.get(attributedElement);
        if (list == null) {
            return;
        }
        for (XDotShape xDotShape : list) {
            if (xDotShape.getLineColor() != null) {
                xDotShape.setLineColor(color);
            }
            if (xDotShape.getFillColor() != null) {
                xDotShape.setFillColor(color2);
            }
            if (xDotShape.getTextColor() == null) continue;
            xDotShape.setTextColor(color3);
        }
    }

    public void setElementStroke(AttributedElement<?, ?> attributedElement, Stroke stroke) {
        assert (stroke != null);
        List list = (List)this.elementShapes.get(attributedElement);
        if (list == null) {
            return;
        }
        for (XDotShape xDotShape : list) {
            xDotShape.setStroke(stroke);
        }
    }

    public Stroke getStandardStroke() {
        return this.standardStroke;
    }

    public Stroke getDashedStroke() {
        return this.dashedStroke;
    }

    public Stroke getThickStroke() {
        return this.thickStroke;
    }

    public Stroke getThickDashedStroke() {
        return this.thickDashedStroke;
    }
}

