/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.rsa2tg;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class SchemaGraph2Tg {
    private boolean useShortNames = true;
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final String STAR = "*";
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final String DELIMITER = ";";
    private static final String COLON = ":";
    private static final String CURLY_BRACKET_OPENED = "{";
    private static final String CURLY_BRACKET_CLOSED = "}";
    private static final String SQUARE_BRACKET_OPENED = "[";
    private static final String SQUARE_BRACKET_CLOSED = "]";
    private static final String ROUND_BRACKET_OPENED = "(";
    private static final String ROUND_BRACKET_CLOSED = ")";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String ROLE = "role";
    private static final String SCHEMA = "Schema";
    private static final String PACKAGE = "Package";
    private static final String COMMENT = "Comment";
    private static final String ABSTRACT = "abstract";
    private static final String VERTEX_CLASS = "VertexClass";
    private static final String GRAPH_CLASS = "GraphClass";
    private static final String RECORD_DOMAIN = "RecordDomain";
    private static final String ENUM_DOMAIN = "EnumDomain";
    private static final String EDGE_CLASS = "EdgeClass";
    private static final String AGGREGATION = "aggregation";
    private static final String AGG_SHARED = "shared";
    private static final String AGG_COMPOSITE = "composite";
    private static final String TGRAPH = "TGraph";
    private static final String TGRAPH_VERSION = "2";
    private static final String ASSIGN = "=";
    private static final String NEWLINE = "\n";
    private final SchemaGraph schemaGraph;
    private final String outputFilename;
    private String currentPackageName;
    private Writer stream;

    public boolean isUseShortNames() {
        return this.useShortNames;
    }

    public void setUseShortNames(boolean bl) {
        this.useShortNames = bl;
    }

    public SchemaGraph2Tg(SchemaGraph schemaGraph, String string) {
        this.schemaGraph = schemaGraph;
        this.outputFilename = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        try {
            assert (this.outputFilename != null && !this.outputFilename.equals(EMPTY)) : "No output filename specified!";
            assert (this.schemaGraph != null) : "No SchemaGraph specified!";
            this.stream = new PrintWriter(this.outputFilename);
            this.printTGSchema(this.schemaGraph);
            this.stream.append(NEWLINE);
            this.stream.flush();
        }
        finally {
            this.stream.close();
            this.stream = null;
        }
    }

    public void setStream(StringWriter stringWriter) {
        this.stream = stringWriter;
    }

    private void printTGSchema(SchemaGraph schemaGraph) {
        this.println(TGRAPH, SPACE, TGRAPH_VERSION, DELIMITER, NEWLINE);
        Schema schema = schemaGraph.getFirstSchema();
        assert (schema != null);
        this.println(SCHEMA, SPACE, schema.get_packagePrefix(), DOT, schema.get_name(), DELIMITER, NEWLINE);
        Package package_ = (Package)schema.getFirstContainsDefaultPackageIncidence(EdgeDirection.OUT).getThat();
        this.setCurrentPackageName(package_);
        GraphClass graphClass = schema.getFirstDefinesGraphClassIncidence(EdgeDirection.OUT).getOmega();
        this.printGraphClass(graphClass);
        this.printComments(graphClass);
        this.printPackageWithElements((Package)schema.getFirstContainsDefaultPackageIncidence(EdgeDirection.OUT).getThat());
    }

    private void printPackageWithElements(Package package_) {
        this.setCurrentPackageName(package_);
        this.printComments(package_);
        if (package_.get_qualifiedName() != null && !package_.get_qualifiedName().isEmpty() || package_.getDegree(Annotates.EC) > 0) {
            this.println(PACKAGE, SPACE, this.currentPackageName, DELIMITER);
        }
        for (ContainsDomain edge : package_.getContainsDomainIncidences(EdgeDirection.OUT)) {
            this.printDomain((Domain)edge.getThat());
        }
        for (ContainsGraphElementClass containsGraphElementClass : package_.getContainsGraphElementClassIncidences(EdgeDirection.OUT)) {
            GraphElementClass graphElementClass = (GraphElementClass)containsGraphElementClass.getThat();
            if (graphElementClass instanceof EdgeClass) {
                this.printEdgeClass((EdgeClass)graphElementClass);
                continue;
            }
            this.printVertexClass((VertexClass)graphElementClass);
        }
        for (ContainsSubPackage containsSubPackage : package_.getContainsSubPackageIncidences(EdgeDirection.OUT)) {
            this.printPackageWithElements((Package)containsSubPackage.getThat());
        }
    }

    private void setCurrentPackageName(Package package_) {
        this.currentPackageName = package_.get_qualifiedName();
    }

    private void printComments(NamedElement namedElement) {
        for (Annotates annotates : namedElement.getAnnotatesIncidences(EdgeDirection.IN)) {
            Comment comment = (Comment)annotates.getThat();
            this.println(COMMENT, SPACE, namedElement.get_qualifiedName(), SPACE, GraphIO.toUtfString(comment.get_text()), DELIMITER);
        }
    }

    public void printVertexClass(VertexClass vertexClass) {
        this.printComments(vertexClass);
        if (vertexClass.is_abstract()) {
            this.print(ABSTRACT, SPACE);
        }
        this.print(VERTEX_CLASS, SPACE, this.shortName(vertexClass.get_qualifiedName()));
        if (vertexClass.getFirstSpecializesVertexClassIncidence(EdgeDirection.OUT) != null) {
            this.print(COLON, SPACE);
            boolean bl = true;
            for (SpecializesVertexClass specializesVertexClass : vertexClass.getSpecializesVertexClassIncidences(EdgeDirection.OUT)) {
                if (bl) {
                    bl = false;
                } else {
                    this.print(COMMA, SPACE);
                }
                VertexClass vertexClass2 = (VertexClass)specializesVertexClass.getThat();
                this.print(this.shortName(vertexClass2.get_qualifiedName()));
            }
        }
        this.printAttributes(vertexClass);
        this.printConstraints(vertexClass);
        this.println(DELIMITER);
    }

    public void printEdgeClass(EdgeClass edgeClass) {
        GraphElementClass graphElementClass;
        this.printComments(edgeClass);
        if (edgeClass.is_abstract()) {
            this.print(ABSTRACT, SPACE);
        }
        this.print(EDGE_CLASS, SPACE, this.shortName(edgeClass.get_qualifiedName()));
        if (edgeClass.getFirstSpecializesEdgeClassIncidence(EdgeDirection.OUT) != null) {
            this.print(COLON, SPACE);
            boolean bl = true;
            for (SpecializesEdgeClass graphElement2 : edgeClass.getSpecializesEdgeClassIncidences(EdgeDirection.OUT)) {
                if (bl) {
                    bl = false;
                } else {
                    this.print(COMMA, SPACE);
                }
                graphElementClass = (EdgeClass)graphElement2.getThat();
                this.print(this.shortName(graphElementClass.get_qualifiedName()));
            }
        }
        IncidenceClass incidenceClass = (IncidenceClass)edgeClass.getFirstComesFromIncidence(EdgeDirection.OUT).getThat();
        IncidenceClass incidenceClass2 = (IncidenceClass)edgeClass.getFirstGoesToIncidence(EdgeDirection.OUT).getThat();
        VertexClass vertexClass = (VertexClass)incidenceClass.getFirstEndsAtIncidence(EdgeDirection.OUT).getThat();
        graphElementClass = (VertexClass)incidenceClass2.getFirstEndsAtIncidence(EdgeDirection.OUT).getThat();
        this.print(SPACE, FROM, SPACE, this.shortName(vertexClass.get_qualifiedName()));
        this.printMultiplicitiesAndRoles(incidenceClass);
        this.print(SPACE, TO, SPACE, this.shortName(graphElementClass.get_qualifiedName()));
        this.printMultiplicitiesAndRoles(incidenceClass2);
        this.printAttributes(edgeClass);
        this.printConstraints(edgeClass);
        this.println(DELIMITER);
    }

    private void printAggregation(IncidenceClass incidenceClass) {
        assert (incidenceClass != null);
        switch (incidenceClass.get_aggregation()) {
            case NONE: {
                break;
            }
            case SHARED: {
                this.print(SPACE, AGGREGATION, SPACE, AGG_SHARED);
                break;
            }
            case COMPOSITE: {
                this.print(SPACE, AGGREGATION, SPACE, AGG_COMPOSITE);
            }
        }
    }

    private String shortName(String string) {
        if (!this.useShortNames || this.isPredefinedDomainName(string)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n == -1 && !this.currentPackageName.isEmpty()) {
            return '.' + string;
        }
        if (n != -1 && this.currentPackageName.equals(string.substring(0, n))) {
            return string.substring(n + 1);
        }
        return string;
    }

    private boolean isPredefinedDomainName(String string) {
        return string.equals("Integer") || string.equals("String") || string.equals("Long") || string.equals("Double") || string.startsWith("List<") || string.startsWith("Set<") || string.startsWith("Map<") || string.equals("Boolean");
    }

    private void printMultiplicitiesAndRoles(IncidenceClass incidenceClass) {
        String string = incidenceClass.get_min() == Integer.MAX_VALUE ? STAR : String.valueOf(incidenceClass.get_min());
        String string2 = incidenceClass.get_max() == Integer.MAX_VALUE ? STAR : String.valueOf(incidenceClass.get_max());
        this.print(SPACE, ROUND_BRACKET_OPENED, string, COMMA, string2, ROUND_BRACKET_CLOSED);
        if (incidenceClass.get_roleName() != null && !incidenceClass.get_roleName().isEmpty()) {
            this.print(SPACE, ROLE, SPACE, incidenceClass.get_roleName());
        }
        this.printAggregation(incidenceClass);
    }

    private void printDomain(Domain domain) {
        if (domain instanceof RecordDomain) {
            this.printRecordDomain((RecordDomain)domain);
            return;
        }
        if (domain instanceof EnumDomain) {
            this.printEnumDomain((EnumDomain)domain);
            return;
        }
    }

    private void printEnumDomain(EnumDomain enumDomain) {
        this.printComments(enumDomain);
        this.print(ENUM_DOMAIN, SPACE, this.shortName(enumDomain.get_qualifiedName()), SPACE, ROUND_BRACKET_OPENED);
        boolean bl = true;
        for (String string : enumDomain.get_enumConstants()) {
            if (bl) {
                bl = false;
            } else {
                this.print(COMMA, SPACE);
            }
            this.print(string);
        }
        this.println(ROUND_BRACKET_CLOSED, DELIMITER);
    }

    private void printRecordDomain(RecordDomain recordDomain) {
        this.printComments(recordDomain);
        this.print(RECORD_DOMAIN, SPACE, recordDomain.get_qualifiedName(), SPACE, ROUND_BRACKET_OPENED);
        boolean bl = true;
        for (HasRecordDomainComponent hasRecordDomainComponent : recordDomain.getHasRecordDomainComponentIncidences(EdgeDirection.OUT)) {
            if (bl) {
                bl = false;
            } else {
                this.print(COMMA, SPACE);
            }
            Domain domain = (Domain)hasRecordDomainComponent.getThat();
            this.print(hasRecordDomainComponent.get_name(), COLON, SPACE, this.shortName(domain.get_qualifiedName()));
        }
        this.println(ROUND_BRACKET_CLOSED, DELIMITER);
    }

    private void printGraphClass(GraphClass graphClass) {
        this.print(GRAPH_CLASS, SPACE, graphClass.get_qualifiedName());
        this.printAttributes(graphClass);
        this.printConstraints(graphClass);
        this.println(DELIMITER, NEWLINE);
    }

    private void printConstraints(AttributedElementClass attributedElementClass) {
        for (HasConstraint hasConstraint : attributedElementClass.getHasConstraintIncidences(EdgeDirection.OUT)) {
            Constraint constraint = (Constraint)hasConstraint.getThat();
            this.print(SPACE, SQUARE_BRACKET_OPENED);
            this.print(GraphIO.toUtfString(constraint.get_message()), SPACE);
            this.print(GraphIO.toUtfString(constraint.get_predicateQuery()));
            String string = constraint.get_offendingElementsQuery();
            if (string != null) {
                this.print(SPACE, GraphIO.toUtfString(string));
            }
            this.print(SQUARE_BRACKET_CLOSED);
        }
    }

    private void printAttributes(AttributedElementClass attributedElementClass) {
        if (attributedElementClass.getFirstHasAttributeIncidence(EdgeDirection.OUT) == null) {
            return;
        }
        this.print(SPACE, CURLY_BRACKET_OPENED);
        boolean bl = true;
        for (HasAttribute hasAttribute : attributedElementClass.getHasAttributeIncidences(EdgeDirection.OUT)) {
            if (bl) {
                bl = false;
            } else {
                this.print(COMMA, SPACE);
            }
            Attribute attribute = (Attribute)hasAttribute.getThat();
            Domain domain = (Domain)attribute.getFirstHasDomainIncidence(EdgeDirection.OUT).getThat();
            this.print(attribute.get_name(), COLON, SPACE, this.shortName(domain.get_qualifiedName()));
            String string = attribute.get_defaultValue();
            if (string == null) continue;
            this.print(SPACE, ASSIGN, SPACE, GraphIO.toUtfString(string));
        }
        this.print(CURLY_BRACKET_CLOSED);
    }

    private void println(String ... stringArray) {
        this.print(stringArray);
        try {
            this.stream.write(NEWLINE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    private void print(String ... stringArray) {
        try {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                this.stream.write(stringArray[i]);
            }
            this.stream.write(stringArray[stringArray.length - 1]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }
}

