/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.RequestThread;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TGraphBrowserServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.pcollections.PSet;

public class TwoDVisualizer {
    public static int SECONDS_TO_WAIT_FOR_DOT = 60;
    public static boolean PRINT_ROLE_NAMES = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visualizeElements(StringBuilder stringBuilder, StateRepository.State state, Integer n, String string, Object object, Boolean bl, Integer n2, RequestThread requestThread) {
        Object object2;
        Object object3;
        if (object instanceof Vertex) {
            stringBuilder.append("current").append("Vertex = \"").append(((Vertex)object).getId()).append("\";\n");
        } else if (object instanceof Edge) {
            stringBuilder.append("current").append("Edge = \"").append(((Edge)object).getId()).append("\";\n");
        }
        PSet<GraphElement<?, ?>> pSet = JGraLab.set();
        if (object instanceof Vertex) {
            object3 = this.computeElements((Vertex)object, n2, state.getGraph(), state);
            pSet = this.calculateElementsInSet(stringBuilder, state, pSet, object3);
        } else if (object instanceof Edge) {
            object3 = (Edge)object;
            object2 = this.computeElements(object3.getAlpha(), n2, state.getGraph(), state);
            pSet = this.calculateElementsInSet(stringBuilder, state, pSet, object2);
            object2 = this.computeElements(object3.getOmega(), n2, state.getGraph(), state);
            pSet = this.calculateElementsInSet(stringBuilder, state, pSet, object2);
        } else {
            pSet = this.calculateElementsInSet(stringBuilder, state, pSet, object);
        }
        object3 = new File(System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser");
        if (!((File)object3).exists() && !((File)object3).mkdir()) {
            TGraphBrowserServer.logger.warning(object3 + " could not be created.");
        }
        ((File)object3).deleteOnExit();
        object2 = null;
        try {
            object2 = ((File)object3).getCanonicalPath() + File.separator + n + "GraphSnippet.dot";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        MyTg2Dot myTg2Dot = new MyTg2Dot(pSet, (String)object2, bl, object, state.selectedEdgeClasses, state.selectedVertexClasses);
        myTg2Dot.convert();
        if (myTg2Dot.exception != null) {
            stringBuilder.append("document.getElementById('divError').style.display = \"block\";\n");
            stringBuilder.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append("Could not create file ").append((String)object2).append("\";\n");
            stringBuilder.append("document.getElementById('divNonError').style.display = \"none\";\n");
            return;
        }
        String string2 = null;
        try {
            string2 = ((File)object3).getCanonicalPath() + File.separator + n + "GraphSnippet.svg";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            String string3 = StateRepository.dot;
            synchronized (string3) {
                String string4 = null;
                string4 = System.getProperty("os.name").startsWith("Windows") ? StateRepository.dot + " -Tsvg -o \"" + string2 + "\" \"" + (String)object2 + "\"" : StateRepository.dot + " -Tsvg -o " + string2 + " " + (String)object2;
                ExecutingDot executingDot = new ExecutingDot(string4, requestThread);
                executingDot.start();
                try {
                    RequestThread requestThread2 = requestThread;
                    synchronized (requestThread2) {
                        requestThread.wait(SECONDS_TO_WAIT_FOR_DOT * 1000);
                    }
                    executingDot.svgCreationProcess.destroy();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (executingDot.exitCode != -1) {
                    if (executingDot.exitCode != 0 && executingDot.exception != null) {
                        throw executingDot.exception;
                    }
                } else {
                    stringBuilder.append("changeView();\n");
                    stringBuilder.append("document.getElementById('divError').style.display = \"block\";\n");
                    stringBuilder.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append("Creation of file ").append(string2.contains("\\") ? string2.replace("\\", "/") : string2).append(" was terminated because it took more than ").append(SECONDS_TO_WAIT_FOR_DOT).append(" seconds.\";\n");
                    stringBuilder.append("document.getElementById('divNonError').style.display = \"none\";\n");
                    return;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            stringBuilder.append("document.getElementById('divError').style.display = \"block\";\n");
            stringBuilder.append("document.getElementById('h2ErrorMessage').innerHTML = \"ERROR: ").append("Could not create file ").append(string2).append("\";\n");
            stringBuilder.append("document.getElementById('divNonError').style.display = \"none\";\n");
            return;
        }
        if (!new File((String)object2).delete()) {
            TGraphBrowserServer.logger.warning((String)object2 + " could not be deleted");
        }
        assert (string2 != null) : "svg file name must not be null";
        string2 = string2.substring(string2.lastIndexOf(File.separator) + 1);
        stringBuilder.append("/*@cc_on\n");
        stringBuilder.append("/*@if (@_jscript_version > 5.6)\n");
        stringBuilder.append("var div2D = document.getElementById(\"div2DGraph\");\n");
        stringBuilder.append("var object = document.createElement(\"embed\");\n");
        stringBuilder.append("object.id = \"embed2DGraph\";\n");
        stringBuilder.append("object.src = \"_").append(string2).append("\";\n");
        stringBuilder.append("object.type = \"image/svg+xml\";\n");
        stringBuilder.append("div2D.appendChild(object);\n");
        stringBuilder.append("@else @*/\n");
        stringBuilder.append("var div2D = document.getElementById(\"div2DGraph\");\n");
        stringBuilder.append("var object = document.createElement(\"object\");\n");
        stringBuilder.append("object.id = \"embed2DGraph\";\n");
        stringBuilder.append("object.data = \"").append(string2).append("\";\n");
        stringBuilder.append("object.type = \"image/svg+xml\";\n");
        stringBuilder.append("div2D.appendChild(object);\n");
        stringBuilder.append("/*@end\n");
        stringBuilder.append("@*/\n");
        stringBuilder.append("object.onload = function(){\n");
        stringBuilder.append("resize();\n");
        stringBuilder.append("};\n");
    }

    private PSet<GraphElement<?, ?>> calculateElementsInSet(StringBuilder stringBuilder, StateRepository.State state, PSet<GraphElement<?, ?>> pSet, Object object) {
        int n = 0;
        int n2 = 0;
        if (object instanceof SubGraphMarker) {
            SubGraphMarker subGraphMarker = (SubGraphMarker)object;
            for (GraphElement<?, ?> graphElement : subGraphMarker.getMarkedElements()) {
                ++n;
                if (graphElement instanceof Vertex) {
                    if (!state.selectedVertexClasses.get(graphElement.getAttributedElementClass()).booleanValue()) continue;
                    pSet = pSet.plus(graphElement);
                    ++n2;
                    continue;
                }
                if (!state.selectedEdgeClasses.get(graphElement.getAttributedElementClass()).booleanValue()) continue;
                pSet = pSet.plus(((Edge)graphElement).getNormalEdge());
                ++n2;
            }
        } else {
            PSet pSet2 = (PSet)object;
            for (GraphElement graphElement : pSet2) {
                ++n;
                if (graphElement instanceof Vertex && state.selectedVertexClasses.get(graphElement.getAttributedElementClass()).booleanValue()) {
                    pSet = pSet.plus(graphElement);
                    ++n2;
                    continue;
                }
                if (!state.selectedEdgeClasses.get(graphElement.getAttributedElementClass()).booleanValue()) continue;
                pSet = pSet.plus(((Edge)graphElement).getNormalEdge());
                ++n2;
            }
        }
        stringBuilder.append("var div2D = document.getElementById(\"div2DGraph\");\n");
        stringBuilder.append("div2D.innerHTML = \"\";\n");
        stringBuilder.append("document.getElementById(\"h3HowManyElements\").innerHTML = \"").append(n2).append(" of ").append(n).append(" elements selected.\";\n");
        return pSet;
    }

    private SubGraphMarker computeElements(Vertex vertex, Integer n, Graph graph, StateRepository.State state) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("current", vertex);
        StringBuilder stringBuilder = new StringBuilder("using current: ");
        stringBuilder.append("slice(current,<->" + state.getEdgeTypeSet() + "^1");
        for (int i = 2; i <= n; ++i) {
            stringBuilder.append("|<->" + state.getEdgeTypeSet() + "^" + i);
        }
        stringBuilder.append(")");
        return (SubGraphMarker)StateRepository.evaluateGReQL(stringBuilder.toString(), graph, hashMap);
    }

    private static class MyTg2Dot {
        private static final double ranksep = 1.5;
        private static final boolean ranksepEqually = false;
        private static final double nodesep = 0.25;
        private static final String fontname = "Helvetica";
        private static final int fontsize = 14;
        protected String outputName = null;
        private boolean printIncidenceNumbers = false;
        private final PSet<GraphElement<?, ?>> elements;
        private final Object current;
        private final boolean showAttributes;
        public Exception exception;
        private int counter = 0;
        private final HashMap<EdgeClass, Boolean> selectedEdgeClasses;
        private final HashMap<VertexClass, Boolean> selectedVertexClasses;

        public MyTg2Dot(PSet<GraphElement<?, ?>> pSet, String string, Boolean bl, Object object, HashMap<EdgeClass, Boolean> hashMap, HashMap<VertexClass, Boolean> hashMap2) {
            this.selectedEdgeClasses = hashMap;
            this.selectedVertexClasses = hashMap2;
            this.elements = pSet;
            this.outputName = string;
            this.showAttributes = bl;
            this.setPrintIncidenceNumbers(true);
            this.current = object;
        }

        public void setPrintIncidenceNumbers(boolean bl) {
            this.printIncidenceNumbers = bl;
        }

        public boolean isPrintIncidenceNumbers() {
            return this.printIncidenceNumbers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void convert() {
            PrintStream printStream = null;
            try {
                printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outputName)));
                this.graphStart(printStream);
                for (GraphElement graphElement : this.elements) {
                    if (graphElement instanceof Vertex) {
                        this.printVertex(printStream, (Vertex)graphElement);
                        continue;
                    }
                    this.printEdge(printStream, (Edge)graphElement);
                }
                this.graphEnd(printStream);
                printStream.flush();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                this.exception = fileNotFoundException;
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }

        public void graphEnd(PrintStream printStream) {
            printStream.println("}");
        }

        public void graphStart(PrintStream printStream) {
            printStream.println("digraph \"" + this.outputName + "\"");
            printStream.println("{");
            printStream.println("ranksep=\"1.5\";");
            printStream.println("nodesep=\"0.25\";");
            printStream.println("node [shape=\"record\" style=\"filled\"  fillcolor=\"white\" fontname=\"Helvetica\" fontsize=\"14\" color=\"#999999\"];");
            printStream.println("edge [fontname=\"Helvetica\" fontsize=\"14\" labelfontname=\"Helvetica\" labelfontsize=\"14\" color=\"#999999\" penwidth=\"3\"  arrowsize=\"1.5\" ];");
        }

        protected void printEdge(PrintStream printStream, Edge edge) {
            if (!this.selectedEdgeClasses.get(edge.getAttributedElementClass()).booleanValue()) {
                return;
            }
            Vertex vertex = edge.getAlpha();
            Vertex vertex2 = edge.getOmega();
            if (!this.selectedVertexClasses.get(vertex.getAttributedElementClass()).booleanValue() || !this.selectedVertexClasses.get(vertex2.getAttributedElementClass()).booleanValue()) {
                return;
            }
            printStream.print("v" + vertex.getId() + " -> v" + vertex2.getId() + " [");
            EdgeClass edgeClass = edge.getAttributedElementClass();
            printStream.print("dir=\"both\" ");
            if (edge.getOmegaAggregationKind() == AggregationKind.SHARED) {
                printStream.print("arrowtail=\"odiamond\" ");
            } else if (edge.getOmegaAggregationKind() == AggregationKind.COMPOSITE) {
                printStream.print("arrowtail=\"diamond\" ");
            } else if (edge.getAlphaAggregationKind() == AggregationKind.SHARED) {
                printStream.print("arrowhead=\"odiamondnormal\" ");
                printStream.print("arrowtail=\"none\" ");
            } else if (edge.getAlphaAggregationKind() == AggregationKind.COMPOSITE) {
                printStream.print("arrowhead=\"diamondnormal\" ");
                printStream.print("arrowtail=\"none\" ");
            } else {
                printStream.print("arrowtail=\"none\" ");
            }
            printStream.print(" label=\"e" + edge.getId() + ": " + edgeClass.getUniqueName().replace('$', '.') + "");
            if (this.showAttributes && edgeClass.getAttributeCount() > 0) {
                printStream.print("\\l");
                this.printAttributes(printStream, edge);
            }
            printStream.print("\"");
            printStream.print(" tooltip=\"");
            if (!this.showAttributes) {
                this.printAttributes(printStream, edge);
            }
            printStream.print(" \"");
            if (this.isPrintIncidenceNumbers()) {
                String string = null;
                String string2 = null;
                if (PRINT_ROLE_NAMES) {
                    EdgeClass edgeClass2 = edge.getAttributedElementClass();
                    string = edgeClass2.getFrom().getRolename();
                    string2 = edgeClass2.getTo().getRolename();
                }
                printStream.print(" taillabel=\"" + this.getIncidenceNumber(edge, vertex) + (string != null && !string.isEmpty() ? ", " + string : "") + "\"");
                printStream.print(" headlabel=\"" + this.getIncidenceNumber(edge.getReversedEdge(), vertex2) + (string2 != null && !string2.isEmpty() ? ", " + string2 : "") + "\"");
            }
            printStream.print(" href=\"javascript:top.showElement('e" + edge.getId() + "');\"");
            if (edge == this.current) {
                printStream.print(" color=\"red\"");
            }
            printStream.println("];");
        }

        private int getIncidenceNumber(Edge edge, Vertex vertex) {
            int n = 1;
            for (Edge edge2 : vertex.incidences()) {
                if (edge2 == edge) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private void printAttributes(PrintStream printStream, AttributedElement<?, ?> attributedElement) {
            Object obj = attributedElement.getAttributedElementClass();
            StringBuilder stringBuilder = new StringBuilder();
            for (Attribute attribute : obj.getAttributeList()) {
                String string;
                String string2 = attribute.getName();
                Object t = attributedElement.getAttribute(attribute.getName());
                String string3 = string = t != null ? t.toString() : "null";
                if (t instanceof String) {
                    string = '\"' + string + '\"';
                }
                string2 = string2 + " = " + this.stringQuote(string) + (this.showAttributes ? "\\l" : ";");
                if (!this.showAttributes) {
                    if (stringBuilder.length() + string2.length() < 400) {
                        stringBuilder.append(string2);
                        continue;
                    }
                    stringBuilder.append(" ...");
                    break;
                }
                stringBuilder.append(string2);
            }
            printStream.print(stringBuilder);
        }

        protected void printVertex(PrintStream printStream, Vertex vertex) {
            VertexClass vertexClass = vertex.getAttributedElementClass();
            printStream.print("v" + vertex.getId() + " [label=\"{{v" + vertex.getId() + "|" + vertexClass.getUniqueName().replace('$', '.') + "}");
            if (this.showAttributes && vertexClass.getAttributeCount() > 0) {
                printStream.print("|");
                this.printAttributes(printStream, vertex);
            }
            printStream.print("}\"");
            printStream.print(" href=\"javascript:top.showElement('v" + vertex.getId() + "');\"");
            if (vertex == this.current) {
                printStream.print(" fillcolor=\"#FFC080\"");
            }
            printStream.print(" tooltip=\"");
            if (!this.showAttributes) {
                this.printAttributes(printStream, vertex);
            }
            printStream.print(" \"");
            printStream.println("];");
            for (Edge edge : vertex.incidences()) {
                if (this.elements.contains(edge.getNormalEdge()) || !this.selectedEdgeClasses.get(edge.getNormalEdge().getAttributedElementClass()).booleanValue()) continue;
                printStream.println("nv" + this.counter + " [shape=\"plaintext\" fontcolor=\"white\"]");
                printStream.println("nv" + this.counter++ + " -> v" + vertex.getId() + " [style=\"dashed\"]");
                break;
            }
        }

        protected String stringQuote(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            block12: for (char c : string.toCharArray()) {
                switch (c) {
                    case '\\': {
                        stringBuilder.append("\\\\");
                        continue block12;
                    }
                    case '<': {
                        stringBuilder.append("\\<");
                        continue block12;
                    }
                    case '>': {
                        stringBuilder.append("\\>");
                        continue block12;
                    }
                    case '{': {
                        stringBuilder.append("\\{");
                        continue block12;
                    }
                    case '}': {
                        stringBuilder.append("\\}");
                        continue block12;
                    }
                    case '\"': {
                        stringBuilder.append("\\\"");
                        continue block12;
                    }
                    case '|': {
                        stringBuilder.append("\\|");
                        continue block12;
                    }
                    case '\n': {
                        stringBuilder.append("\\\\n");
                        continue block12;
                    }
                    case '\r': {
                        stringBuilder.append("\\\\r");
                        continue block12;
                    }
                    case '\t': {
                        stringBuilder.append("\\\\t");
                        continue block12;
                    }
                    default: {
                        if (c < ' ' || c > '\u007f') {
                            stringBuilder.append("\\\\u");
                            String string2 = "000" + Integer.toHexString(c);
                            stringBuilder.append(string2.substring(string2.length() - 4, string2.length()));
                            continue block12;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
    }

    private static final class ExecutingDot
    extends Thread {
        public Process svgCreationProcess;
        private final String execStr;
        public int exitCode = -1;
        public IOException exception;
        private final RequestThread sleepingRequestThread;

        public ExecutingDot(String string, RequestThread requestThread) {
            this.execStr = string;
            this.sleepingRequestThread = requestThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            try {
                this.svgCreationProcess = Runtime.getRuntime().exec(this.execStr);
                this.exitCode = this.svgCreationProcess.waitFor();
                RequestThread requestThread = this.sleepingRequestThread;
                synchronized (requestThread) {
                    if (this.sleepingRequestThread.getState() == Thread.State.TIMED_WAITING) {
                        this.sleepingRequestThread.notify();
                    }
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

