/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pcollections.IntTree;
import org.pcollections.PMap;

public final class IntTreePMap<V>
extends AbstractMap<Integer, V>
implements PMap<Integer, V> {
    private static final IntTreePMap<Object> EMPTY = new IntTreePMap<Object>(IntTree.EMPTYNODE);
    private final IntTree<V> root;
    private Set<Map.Entry<Integer, V>> entrySet = null;

    public static <V> IntTreePMap<V> empty() {
        return EMPTY;
    }

    public static <V> IntTreePMap<V> singleton(Integer n, V v) {
        return IntTreePMap.empty().plus(n, v);
    }

    public static <V> IntTreePMap<V> from(Map<? extends Integer, ? extends V> map) {
        if (map instanceof IntTreePMap) {
            return (IntTreePMap)map;
        }
        return IntTreePMap.empty().plusAll((Map)map);
    }

    private IntTreePMap(IntTree<V> intTree) {
        this.root = intTree;
    }

    private IntTreePMap<V> withRoot(IntTree<V> intTree) {
        if (intTree == this.root) {
            return this;
        }
        return new IntTreePMap<V>(intTree);
    }

    IntTreePMap<V> withKeysChangedAbove(int n, int n2) {
        return this.withRoot(this.root.changeKeysAbove(n, n2));
    }

    IntTreePMap<V> withKeysChangedBelow(int n, int n2) {
        return this.withRoot(this.root.changeKeysBelow(n, n2));
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, V>>(){

                @Override
                public int size() {
                    return IntTreePMap.this.size();
                }

                @Override
                public Iterator<Map.Entry<Integer, V>> iterator() {
                    return IntTreePMap.this.root.iterator();
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Object v = IntTreePMap.this.get(((Map.Entry)object).getKey());
                    return v != null && v.equals(((Map.Entry)object).getValue());
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.root.containsKey(((Integer)object).intValue());
    }

    @Override
    public V get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.root.get(((Integer)object).intValue());
    }

    public IntTreePMap<V> plus(Integer n, V v) {
        return this.withRoot(this.root.plus(n.intValue(), v));
    }

    public IntTreePMap<V> minus(Object object) {
        if (!(object instanceof Integer)) {
            return this;
        }
        return this.withRoot(this.root.minus(((Integer)object).intValue()));
    }

    public IntTreePMap<V> plusAll(Map<? extends Integer, ? extends V> map) {
        IntTree<V> intTree = this.root;
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            intTree = intTree.plus(entry.getKey().intValue(), entry.getValue());
        }
        return this.withRoot(intTree);
    }

    public IntTreePMap<V> minusAll(Collection<?> collection) {
        IntTree<V> intTree = this.root;
        for (Object obj : collection) {
            if (!(obj instanceof Integer)) continue;
            intTree = intTree.minus(((Integer)obj).intValue());
        }
        return this.withRoot(intTree);
    }

    @Override
    public V put(Integer n, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        throw new UnsupportedOperationException();
    }
}

