/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.pcollections.ArrayPSet;
import org.pcollections.OrderedPSet;
import org.pcollections.POrderedSet;

public class LinkedHashPSet<E>
implements POrderedSet<E> {
    private final LinkedHashSet<E> lhs;
    private final int storedHashCode;

    private LinkedHashPSet(LinkedHashSet<E> linkedHashSet) {
        this.lhs = linkedHashSet;
        this.storedHashCode = this.lhs.hashCode();
    }

    public static <T> LinkedHashPSet<T> immute(LinkedHashSet<T> linkedHashSet) {
        return new LinkedHashPSet<T>(linkedHashSet);
    }

    private final void checkUnmodified() {
        if (this.storedHashCode != this.lhs.hashCode()) {
            throw new RuntimeException("Backing LinkedHashSet was modified!");
        }
    }

    @Override
    public int hashCode() {
        this.checkUnmodified();
        return this.storedHashCode;
    }

    @Override
    public boolean equals(Object object) {
        this.checkUnmodified();
        if (object == null || !(object instanceof Set)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Set set = (Set)object;
        if (set.size() != this.lhs.size()) {
            return false;
        }
        for (E e : this) {
            if (set.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final POrderedSet<E> plus(E e) {
        if (this.contains(e)) {
            return this;
        }
        return this.immute(1).plus(e);
    }

    @Override
    public final int size() {
        this.checkUnmodified();
        return this.lhs.size();
    }

    @Override
    public final boolean isEmpty() {
        this.checkUnmodified();
        return this.lhs.isEmpty();
    }

    @Override
    public final boolean contains(Object object) {
        this.checkUnmodified();
        return this.lhs.contains(object);
    }

    @Override
    public final Iterator<E> iterator() {
        this.checkUnmodified();
        return new ImmutableIterator(this.lhs.iterator());
    }

    @Override
    public final Object[] toArray() {
        this.checkUnmodified();
        return this.lhs.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        this.checkUnmodified();
        return this.lhs.toArray(TArray);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        return this.lhs.containsAll(collection);
    }

    @Override
    public final E get(int n) {
        this.checkUnmodified();
        if (n < 0 || n > this.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        for (Object e : this.lhs) {
            if (n == 0) {
                return e;
            }
            --n;
        }
        throw new RuntimeException();
    }

    @Override
    public final int indexOf(Object object) {
        if (!this.contains(object)) {
            return -1;
        }
        int n = 0;
        for (E e : this) {
            if (e == object) {
                return n;
            }
            ++n;
        }
        throw new RuntimeException();
    }

    @Override
    public final POrderedSet<E> plusAll(Collection<? extends E> collection) {
        this.checkUnmodified();
        return this.immute(collection.size()).plusAll(collection);
    }

    private final POrderedSet<E> immute(int n) {
        POrderedSet<Object> pOrderedSet = this.lhs.size() + n <= 16 ? ArrayPSet.empty() : OrderedPSet.empty();
        return pOrderedSet.plusAll(this.lhs);
    }

    @Override
    public final POrderedSet<E> minus(Object object) {
        if (!this.contains(object)) {
            return this;
        }
        return this.immute(-1).minus(object);
    }

    @Override
    public final POrderedSet<E> minusAll(Collection<?> collection) {
        this.checkUnmodified();
        return this.immute(-collection.size()).minusAll(collection);
    }

    public final String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "{";
        for (Object e : this.lhs) {
            stringBuilder.append(string).append(e);
            string = ", ";
        }
        return stringBuilder.append("}").toString();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private static final class ImmutableIterator<E>
    implements Iterator<E> {
        private Iterator<E> it;

        private ImmutableIterator(Iterator<E> iterator) {
            this.it = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

