/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.plist;

import de.uni_koblenz.ist.utilities.plist.PListDict;
import de.uni_koblenz.ist.utilities.plist.PListException;
import de.uni_koblenz.ist.utilities.plist.PListProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PList {
    static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private PListDict dict;
    private String filename;

    public PList() {
        this.dict = new PListDict();
    }

    public PList(String string) throws PListException {
        this.filename = string;
        try {
            this.dict = this.loadFrom(string);
        }
        catch (PListException pListException) {
            if (pListException.getCause() instanceof FileNotFoundException) {
                this.dict = new PListDict();
            }
            throw pListException;
        }
    }

    public void store() throws PListException {
        this.storeTo(this.filename);
    }

    public void store(boolean bl) throws PListException {
        this.storeTo(this.filename, bl);
    }

    public PListDict loadFrom(String string) throws PListException {
        try {
            PListProcessor pListProcessor = new PListProcessor();
            pListProcessor.process(string);
            return pListProcessor.getDict();
        }
        catch (Exception exception) {
            throw new PListException("Error reading property list '" + string + "'", exception);
        }
    }

    public void storeTo(String string) throws PListException {
        this.storeTo(new File(string), false);
    }

    public void storeTo(String string, boolean bl) throws PListException {
        this.storeTo(new File(string), bl);
    }

    public void storeTo(File file, boolean bl) throws PListException {
        XMLStreamWriter xMLStreamWriter = null;
        try {
            if (bl && file.exists()) {
                File file2 = new File(file.getCanonicalPath() + "~");
                if (file2.exists() && !file2.delete()) {
                    throw new PListException("Can't delete old backup " + file2.getCanonicalPath());
                }
                if (!file.renameTo(file2)) {
                    throw new PListException("Can't rename " + file.getCanonicalPath() + " to " + file2.getCanonicalPath());
                }
            }
            xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(file)), "UTF-8");
            this.print(xMLStreamWriter);
            xMLStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new PListException("Error writing property list '" + this.filename + "'", iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new PListException("Error writing property list '" + this.filename + "'", xMLStreamException);
        }
        finally {
            if (xMLStreamWriter != null) {
                try {
                    xMLStreamWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new PListException("Error writing property list '" + this.filename + "'", xMLStreamException);
                }
            }
        }
    }

    public void print(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeDTD("\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
        xMLStreamWriter.writeStartElement("plist");
        xMLStreamWriter.writeAttribute("version", "1.0");
        this.print(xMLStreamWriter, this.dict);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(XMLStreamWriter xMLStreamWriter, Object object) throws XMLStreamException {
        if (object instanceof PListDict) {
            Set<Map.Entry<String, Object>> set = ((PListDict)object).entrySet();
            if (set.size() == 0) {
                xMLStreamWriter.writeEmptyElement("dict");
            } else {
                xMLStreamWriter.writeStartElement("dict");
                for (Map.Entry<String, Object> entry : set) {
                    xMLStreamWriter.writeStartElement("key");
                    xMLStreamWriter.writeCharacters(entry.getKey());
                    xMLStreamWriter.writeEndElement();
                    this.print(xMLStreamWriter, entry.getValue());
                }
                xMLStreamWriter.writeEndElement();
            }
        } else if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                xMLStreamWriter.writeEmptyElement("array");
            } else {
                xMLStreamWriter.writeStartElement("array");
                for (Object e : list) {
                    this.print(xMLStreamWriter, e);
                }
                xMLStreamWriter.writeEndElement();
            }
        } else if (object instanceof Integer) {
            xMLStreamWriter.writeStartElement("integer");
            xMLStreamWriter.writeCharacters(object.toString());
            xMLStreamWriter.writeEndElement();
        } else if (object instanceof String) {
            xMLStreamWriter.writeStartElement("string");
            xMLStreamWriter.writeCharacters(object.toString());
            xMLStreamWriter.writeEndElement();
        } else if (object instanceof Double) {
            xMLStreamWriter.writeStartElement("real");
            xMLStreamWriter.writeCharacters(object.toString());
            xMLStreamWriter.writeEndElement();
        } else if (object instanceof Boolean) {
            xMLStreamWriter.writeEmptyElement(object.toString());
        } else if (object instanceof Date) {
            String string;
            DateFormat dateFormat = PList.dateFormat;
            synchronized (dateFormat) {
                string = PList.dateFormat.format((Date)object);
            }
            xMLStreamWriter.writeStartElement("date");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
    }

    public PListDict getDict() {
        return this.dict;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

