/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.shortest_paths;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.DoubleFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.problems.DistanceFromVertexToVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.DistancesFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathFromVertexToVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.ShortestPathsFromVertexSolver;
import de.uni_koblenz.jgralab.algolib.problems.TraversalSolver;
import de.uni_koblenz.jgralab.algolib.problems.WeightedProblemSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.DoubleVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;
import java.util.LinkedList;
import java.util.Queue;

public class FordMooreAlgorithm
extends StructureOrientedAlgorithm
implements WeightedProblemSolver,
TraversalSolver,
DistancesFromVertexSolver,
ShortestPathsFromVertexSolver,
DistanceFromVertexToVertexSolver,
ShortestPathFromVertexToVertexSolver {
    private DoubleFunction<Edge> edgeWeight;
    private Vertex target;
    private Function<Vertex, Edge> parent;
    private DoubleFunction<Vertex> distance;
    private Queue<Vertex> vertexQueue;
    private IntFunction<Vertex> pushCount;
    private int maxPushCount;
    private boolean negativeCycleDetected;

    public FordMooreAlgorithm(Graph graph, BooleanFunction<Edge> booleanFunction, DoubleFunction<Edge> doubleFunction) {
        super(graph, booleanFunction);
        this.edgeWeight = doubleFunction;
    }

    public FordMooreAlgorithm(Graph graph) {
        this(graph, null, null);
    }

    @Override
    public void setEdgeWeight(DoubleFunction<Edge> doubleFunction) {
        this.checkStateForSettingParameters();
        this.edgeWeight = doubleFunction;
    }

    @Override
    public void disableOptionalResults() {
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public FordMooreAlgorithm normal() {
        super.normal();
        return this;
    }

    @Override
    public FordMooreAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public FordMooreAlgorithm undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return true;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm currently doesn't support visitors!");
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        throw new UnsupportedOperationException("This algorithm currently doesn't support visitors!");
    }

    @Override
    public void reset() {
        super.reset();
        this.parent = new ArrayVertexMarker<Edge>(this.graph);
        this.distance = new DoubleVertexMarker(this.graph);
        for (Vertex vertex : this.graph.vertices()) {
            this.distance.set(vertex, Double.POSITIVE_INFINITY);
        }
        this.vertexQueue = this.vertexQueue == null ? new LinkedList() : this.vertexQueue;
        this.vertexQueue.clear();
        this.pushCount = new IntegerVertexMarker(this.graph);
        this.maxPushCount = this.graph.getVCount() - 1;
        this.negativeCycleDetected = false;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.edgeWeight = null;
        this.traversalDirection = EdgeDirection.OUT;
    }

    @Override
    public FordMooreAlgorithm execute(Vertex vertex) throws AlgorithmTerminatedException {
        this.startRunning();
        for (Vertex object : this.graph.vertices()) {
            this.pushCount.set(object, 0);
        }
        this.distance.set(vertex, 0.0);
        this.vertexQueue.add(vertex);
        this.pushCount.set(vertex, this.pushCount.get(vertex) + 1);
        while (!this.vertexQueue.isEmpty()) {
            Vertex vertex2 = this.vertexQueue.poll();
            assert (vertex2 != null);
            for (Edge edge : vertex2.incidences(this.traversalDirection)) {
                this.cancelIfInterrupted();
                if (this.navigable != null && !this.navigable.get(edge)) continue;
                Vertex vertex3 = edge.getThat();
                double d = this.distance.get(vertex2);
                double d2 = this.edgeWeight == null ? 1.0 : this.edgeWeight.get(edge);
                double d3 = d + d2;
                if (!(d3 < this.distance.get(vertex3))) continue;
                this.parent.set(vertex3, edge);
                this.distance.set(vertex3, d3);
                int n = this.pushCount.get(vertex3) + 1;
                if (n > this.maxPushCount) {
                    this.negativeCycleDetected = true;
                    this.terminate();
                }
                this.pushCount.set(vertex3, n);
                this.vertexQueue.add(vertex3);
            }
        }
        this.done();
        return this;
    }

    @Override
    public FordMooreAlgorithm execute(Vertex vertex, Vertex vertex2) throws AlgorithmTerminatedException {
        this.target = vertex2;
        return this.execute(vertex);
    }

    @Override
    public DoubleFunction<Vertex> getDistance() {
        this.checkStateForResult();
        return this.distance;
    }

    public DoubleFunction<Vertex> getInternalDistance() {
        return this.distance;
    }

    @Override
    public double getDistanceToTarget() {
        this.checkStateForResult();
        if (this.target != null) {
            return this.distance.get(this.target);
        }
        throw new UnsupportedOperationException("No target vertex specified or wrong execute method used.");
    }

    @Override
    public Function<Vertex, Edge> getParent() {
        this.checkStateForResult();
        return this.parent;
    }

    public Function<Vertex, Edge> getInternalParent() {
        return this.parent;
    }

    public boolean hasNegativeCycleDetected() {
        return this.negativeCycleDetected;
    }

    public int getMaxPushCount() {
        return this.maxPushCount;
    }

    public Queue<Vertex> getVertexQueue() {
        return this.vertexQueue;
    }

    public IntFunction<Vertex> getPushCount() {
        return this.pushCount;
    }
}

