/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.parallel.EvaluationEnvironment;
import de.uni_koblenz.jgralab.greql.parallel.ParallelGreqlEvaluatorCallable;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PVector;

public abstract class GreqlQuery
implements ParallelGreqlEvaluatorCallable {
    private String name;

    protected GreqlQuery() {
    }

    public static GreqlQuery readQuery(File file) throws IOException {
        return GreqlQuery.readQuery(file, new DefaultOptimizer(new DefaultOptimizerInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GreqlQuery readQuery(File file, Optimizer optimizer) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Object object = bufferedReader.readLine();
            while (object != null) {
                stringBuilder.append((String)object).append('\n');
                object = bufferedReader.readLine();
            }
            object = GreqlQuery.createQuery(stringBuilder.toString(), optimizer);
            return object;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("An exception occurred while closing the stream.", iOException);
            }
        }
    }

    public static GreqlQuery createQuery(String string) {
        return new GreqlQueryImpl(string);
    }

    public static GreqlQuery createQuery(String string, Optimizer optimizer) {
        return new GreqlQueryImpl(string, optimizer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public abstract GreqlGraph getQueryGraph();

    @Override
    public abstract Set<String> getUsedVariables();

    @Override
    public abstract Set<String> getStoredVariables();

    public abstract String getQueryText();

    public abstract GreqlExpression getRootExpression();

    public Object evaluate() {
        return this.evaluate(null, new GreqlEnvironmentAdapter(), null);
    }

    public Object evaluate(Graph graph) {
        return this.evaluate(graph, new GreqlEnvironmentAdapter(), null);
    }

    public Object evaluate(Graph graph, GreqlEnvironment greqlEnvironment) {
        return this.evaluate(graph, greqlEnvironment, null);
    }

    public Object evaluate(Graph graph, ProgressFunction progressFunction) {
        return this.evaluate(graph, new GreqlEnvironmentAdapter(), progressFunction);
    }

    public abstract Object evaluate(Graph var1, GreqlEnvironment var2, ProgressFunction var3);

    public <T> T getSingleResult(Graph graph) {
        return (T)this.evaluate(graph);
    }

    public <T> T getSingleResult(Graph graph, GreqlEnvironment greqlEnvironment) {
        return (T)this.evaluate(graph, greqlEnvironment);
    }

    public <T> PVector<T> getResultList(Graph graph) {
        return (PVector)this.evaluate(graph);
    }

    public <T> PVector<T> getResultList(Graph graph, GreqlEnvironment greqlEnvironment) {
        return (PVector)this.evaluate(graph, greqlEnvironment);
    }

    public <K, V> PMap<K, V> getResultMap(Graph graph) {
        return (PMap)this.evaluate(graph);
    }

    public <K, V> PMap<K, V> getResultMap(Graph graph, GreqlEnvironment greqlEnvironment) {
        return (PMap)this.evaluate(graph, greqlEnvironment);
    }

    public <T> POrderedSet<T> getResultSet(Graph graph) {
        return (POrderedSet)this.evaluate(graph);
    }

    public <T> POrderedSet<T> getResultSet(Graph graph, GreqlEnvironment greqlEnvironment) {
        return (POrderedSet)this.evaluate(graph, greqlEnvironment);
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, GraphIOException {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.err.println("Usage: java GreqlQuery <query> [<graphfile>]");
            System.exit(1);
        }
        JGraLab.setLogLevel(Level.OFF);
        String string = stringArray[0];
        Graph graph = null;
        if (stringArray.length == 2) {
            graph = GraphIO.loadGraphFromFile(stringArray[1], ImplementationType.GENERIC, (ProgressFunction)new ConsoleProgressFunction("Loading"));
        }
        Object object = GreqlQuery.createQuery(string).evaluate(graph);
        System.out.println("Evaluation Result:");
        System.out.println("==================");
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                System.out.println(entry.getKey() + " --> " + entry.getValue());
            }
        } else if (object instanceof PCollection) {
            PCollection pCollection = (PCollection)object;
            for (Object e : pCollection) {
                System.out.println(e);
            }
        } else {
            System.out.println(object);
        }
    }

    @Override
    public Object call(EvaluationEnvironment evaluationEnvironment) throws Exception {
        return this.evaluate(evaluationEnvironment.getDatagraph(), evaluationEnvironment.getGreqlEnvironment());
    }
}

