/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphStructureChangedListener;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEvaluatorImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.greql.optimizer.NullOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.parser.GreqlParser;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.UndefinedLiteral;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.impl.std.GraphImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.pcollections.PSet;

public class GreqlQueryImpl
extends GreqlQuery
implements GraphStructureChangedListener {
    private final String queryText;
    private GreqlGraph queryGraph;
    private PSet<String> usedVariables;
    private PSet<String> storedVariables;
    private final Optimizer optimizer;
    private GreqlExpression rootExpression;
    private static Logger logger = JGraLab.getLogger(GreqlQueryImpl.class);
    public static boolean DEBUG_OPTIMIZATION = Boolean.parseBoolean(System.getProperty("greqlDebugOptimization", "false"));
    private GraphMarker<VertexEvaluator<? extends GreqlVertex>> vertexEvaluators;
    private static SoftReference<Object> tg2DotReference;
    private static Class<?> tg2DotClass;

    public GreqlQueryImpl(String string) {
        this(string, new DefaultOptimizer(new DefaultOptimizerInfo()));
    }

    public GreqlQueryImpl(String string, Optimizer optimizer) {
        this.queryText = string;
        this.optimizer = optimizer == null ? NullOptimizer.instance() : optimizer;
        this.initializeQueryGraph();
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    public GreqlGraph getQueryGraph() {
        return this.queryGraph;
    }

    public <V extends GreqlVertex> VertexEvaluator<V> getVertexEvaluator(V v) {
        return (VertexEvaluator)this.vertexEvaluators.get(v);
    }

    private void initializeQueryGraph() {
        long l;
        if (this.queryGraph != null) {
            return;
        }
        long l2 = System.currentTimeMillis();
        this.queryGraph = GreqlParserWithVertexEvaluatorUpdates.parse(this.queryText, this, new HashSet<String>());
        if (this.queryGraph.getVCount() == 0) {
            GreqlExpression greqlExpression = this.queryGraph.createGreqlExpression();
            UndefinedLiteral undefinedLiteral = this.queryGraph.createUndefinedLiteral();
            greqlExpression.add_queryExpr(undefinedLiteral);
        }
        long l3 = System.currentTimeMillis();
        logger.fine("GReQL parser: " + (l3 - l2) + " ms, v/eCount=" + this.queryGraph.getVCount() + "/" + this.queryGraph.getECount() + ", v/eMax=" + ((GraphImpl)((Object)this.queryGraph)).getMaxVCount() + "/" + ((GraphImpl)((Object)this.queryGraph)).getMaxECount());
        if (this.optimizer != null && !(this.optimizer instanceof NullOptimizer)) {
            Object object;
            if (DEBUG_OPTIMIZATION) {
                String string = System.getProperty("java.io.tmpdir");
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                try {
                    this.queryGraph.save(string + "greql-query-unoptimized.tg");
                }
                catch (GraphIOException graphIOException) {
                    graphIOException.printStackTrace();
                }
                this.printGraphAsDot(this.queryGraph, string + "greql-query-unoptimized.dot");
            }
            l = System.currentTimeMillis();
            this.optimizer.optimize(this);
            if (!DEBUG_OPTIMIZATION) {
                BooleanGraphMarker booleanGraphMarker = new BooleanGraphMarker(this.queryGraph);
                LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
                linkedList.offer(this.queryGraph.getFirstGreqlExpression());
                while (!linkedList.isEmpty()) {
                    object = (Vertex)linkedList.poll();
                    booleanGraphMarker.mark((GraphElement<?, ?>)object);
                    for (Edge graphElement : object.incidences()) {
                        Vertex vertex = graphElement.getThat();
                        if (booleanGraphMarker.isMarked(vertex)) continue;
                        linkedList.offer(vertex);
                    }
                }
                object = new ArrayList<Vertex>();
                for (Vertex vertex : this.queryGraph.vertices()) {
                    if (booleanGraphMarker.isMarked(vertex)) continue;
                    object.add(vertex);
                }
                Iterator<GraphElement<VertexClass, Vertex>> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Vertex vertex = (Vertex)iterator.next();
                    vertex.delete();
                }
            }
            long l4 = System.currentTimeMillis();
            if (DEBUG_OPTIMIZATION) {
                object = System.getProperty("java.io.tmpdir");
                if (!((String)object).endsWith(File.separator)) {
                    object = (String)object + File.separator;
                }
                try {
                    this.queryGraph.save((String)object + "greql-query-optimized.tg");
                }
                catch (GraphIOException graphIOException) {
                    graphIOException.printStackTrace();
                }
                this.printGraphAsDot(this.queryGraph, object + "greql-query-optimized.dot");
                logger.info("Stored query graphs to " + object + "greql-query*");
            }
            logger.fine("GReQL optimizer: " + (l4 - l) + " ms");
        }
        this.initializeVertexEvaluatorsMarker(this.queryGraph);
        l = System.currentTimeMillis();
        logger.fine("GReQL total: " + (l - l2) + " ms");
        this.rootExpression = this.queryGraph.getFirstGreqlExpression();
    }

    private void printGraphAsDot(Graph graph, String string) {
        Object object = null;
        if (tg2DotReference != null) {
            object = tg2DotReference.get();
        }
        try {
            if (object == null) {
                if (tg2DotClass == null) {
                    tg2DotClass = Class.forName("de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot");
                }
                object = tg2DotClass.newInstance();
                tg2DotReference = new SoftReference<Object>(object);
            }
            tg2DotClass.getMethod("setGraph", Graph.class).invoke(object, graph);
            tg2DotClass.getMethod("setOutputFile", String.class).invoke(object, string);
            tg2DotClass.getMethod("setReversedEdges", Boolean.TYPE).invoke(object, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initializeVertexEvaluatorsMarker(GreqlGraph greqlGraph) {
        if (this.vertexEvaluators == null) {
            this.vertexEvaluators = new GraphMarker(greqlGraph);
        }
    }

    void resetVertexEvaluators(InternalGreqlEvaluator internalGreqlEvaluator) {
        GreqlGraph greqlGraph = this.getQueryGraph();
        for (GreqlVertex greqlVertex = (GreqlVertex)greqlGraph.getFirstVertex(); greqlVertex != null; greqlVertex = (GreqlVertex)greqlVertex.getNextVertex()) {
            VertexEvaluator vertexEvaluator = (VertexEvaluator)this.vertexEvaluators.getMark(greqlVertex);
            if (vertexEvaluator == null) continue;
            vertexEvaluator.resetToInitialState(internalGreqlEvaluator);
        }
    }

    @Override
    public Set<String> getUsedVariables() {
        if (this.usedVariables == null) {
            this.usedVariables = JGraLab.set();
            GreqlExpression greqlExpression = this.getRootExpression();
            if (greqlExpression != null) {
                for (Variable variable : greqlExpression.get_boundVar()) {
                    this.usedVariables = this.usedVariables.plus(variable.get_name());
                }
            }
        }
        return this.usedVariables;
    }

    @Override
    public Set<String> getStoredVariables() {
        if (this.storedVariables == null) {
            Identifier identifier;
            this.storedVariables = JGraLab.set();
            GreqlExpression greqlExpression = this.getRootExpression();
            if (greqlExpression != null && (identifier = greqlExpression.get_identifier()) != null) {
                this.storedVariables = this.storedVariables.plus(identifier.get_name());
            }
        }
        return this.storedVariables;
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    @Override
    public GreqlExpression getRootExpression() {
        return this.rootExpression;
    }

    @Override
    public void vertexAdded(Vertex vertex) {
        block2: {
            try {
                this.vertexEvaluators.mark(vertex, VertexEvaluator.createVertexEvaluator((GreqlVertex)vertex, this));
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getCause() instanceof ClassNotFoundException) break block2;
                throw runtimeException;
            }
        }
    }

    @Override
    public void vertexDeleted(Vertex vertex) {
        this.vertexEvaluators.removeMark(vertex);
    }

    @Override
    public void edgeAdded(Edge edge) {
    }

    @Override
    public void edgeDeleted(Edge edge) {
    }

    @Override
    public void maxEdgeCountIncreased(int n) {
    }

    @Override
    public void maxVertexCountIncreased(int n) {
    }

    @Override
    public Object evaluate(Graph graph, GreqlEnvironment greqlEnvironment, ProgressFunction progressFunction) {
        return new GreqlEvaluatorImpl(this, graph, greqlEnvironment, progressFunction).getResult();
    }

    public String toString() {
        return this.queryText;
    }

    private static class GreqlParserWithVertexEvaluatorUpdates
    extends GreqlParser {
        public GreqlParserWithVertexEvaluatorUpdates(String string, Set<String> set, GreqlQueryImpl greqlQueryImpl) {
            super(string, set);
            if (greqlQueryImpl != null) {
                this.graph.addGraphStructureChangedListener(greqlQueryImpl);
                greqlQueryImpl.initializeVertexEvaluatorsMarker(this.graph);
            }
        }

        public static GreqlGraph parse(String string, GreqlQueryImpl greqlQueryImpl, Set<String> set) {
            return GreqlParserWithVertexEvaluatorUpdates.parse(string, set, greqlQueryImpl);
        }

        public static GreqlGraph parse(String string, Set<String> set, GreqlQueryImpl greqlQueryImpl) {
            GreqlParserWithVertexEvaluatorUpdates greqlParserWithVertexEvaluatorUpdates = new GreqlParserWithVertexEvaluatorUpdates(string, set, greqlQueryImpl);
            greqlParserWithVertexEvaluatorUpdates.parse();
            return greqlParserWithVertexEvaluatorUpdates.getGraph();
        }
    }
}

