/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class FiniteAutomaton {
    private static Logger logger = Logger.getLogger(FiniteAutomaton.class.getPackage().getName());
    public State initialState;
    public ArrayList<State> finalStates = new ArrayList();
    public ArrayList<State> stateList = new ArrayList();
    public ArrayList<Transition> transitionList = new ArrayList();

    public abstract DFA getDFA();

    public void printAscii() {
        logger.info("|||||||||||||||||||||||  Automaton: |||||||||||||||||||||||||");
        for (State state : this.stateList) {
            logger.info("[" + this.stateList.indexOf(state) + "]");
            for (Transition transition : state.outTransitions) {
                int n = this.stateList.indexOf(transition.endState);
                if (this.finalStates.contains(transition.endState)) {
                    logger.info("      ----" + transition.edgeString() + "--->    [[" + n + "]]");
                    continue;
                }
                logger.info("      ----" + transition.edgeString() + "--->    [" + n + "]");
            }
            logger.info("\n--------------------------");
        }
        logger.info("||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| ");
    }

    public void printAscii2() {
        for (State state : this.stateList) {
            if (state.isFinal) {
                System.out.println("State: [[" + state.number + "]]");
            } else {
                System.out.println("State: [" + state.number + "]");
            }
            for (Transition transition : state.outTransitions) {
                int n = transition.endState.number;
                if (this.finalStates.contains(transition.endState)) {
                    System.out.println("      ----" + transition.edgeString() + "--->    [[" + n + "]]");
                    continue;
                }
                System.out.println("      ----" + transition.edgeString() + "--->    [" + n + "]");
            }
            System.out.println("\n--------------------------");
        }
    }

    public boolean isFinal(State state) {
        return this.finalStates.contains(state);
    }

    protected void updateStateAttributes() {
        Iterator<State> iterator = this.stateList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            State state = iterator.next();
            state.isFinal = false;
            state.number = n++;
        }
        iterator = this.finalStates.iterator();
        while (iterator.hasNext()) {
            iterator.next().isFinal = true;
        }
    }
}

