/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.DeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.SimpleDeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class VariableEvaluator<V extends Variable>
extends VertexEvaluator<V> {
    private List<VertexEvaluator<? extends Expression>> dependingExpressions;
    private long estimatedAssignments = Long.MIN_VALUE;

    public void setValue(Object object, InternalGreqlEvaluator internalGreqlEvaluator) {
        if (this.dependingExpressions == null) {
            this.dependingExpressions = this.calculateDependingExpressions();
        }
        int n = this.dependingExpressions.size();
        for (int i = 0; i < n; ++i) {
            this.dependingExpressions.get(i).clear(internalGreqlEvaluator);
        }
        internalGreqlEvaluator.setLocalEvaluationResult(this.vertex, object);
    }

    public Object getValue(InternalGreqlEvaluator internalGreqlEvaluator) {
        return internalGreqlEvaluator.getLocalEvaluationResult(this.vertex);
    }

    public VariableEvaluator(V v, GreqlQueryImpl greqlQueryImpl) {
        super(v, greqlQueryImpl);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        return this.getValue(internalGreqlEvaluator);
    }

    @Override
    public Object getResult(InternalGreqlEvaluator internalGreqlEvaluator) {
        return this.getValue(internalGreqlEvaluator);
    }

    @Override
    public Set<Variable> getNeededVariables() {
        if (this.neededVariables == null) {
            this.neededVariables = new HashSet();
            this.neededVariables.add(this.vertex);
        }
        return this.neededVariables;
    }

    @Override
    public Set<Variable> getDefinedVariables() {
        if (this.definedVariables == null) {
            this.definedVariables = new HashSet();
        }
        return this.definedVariables;
    }

    public List<VertexEvaluator<? extends Expression>> calculateDependingExpressions() {
        GreqlVertex greqlVertex;
        LinkedList<GreqlVertex> linkedList = new LinkedList<GreqlVertex>();
        ArrayList<VertexEvaluator<? extends Expression>> arrayList = new ArrayList<VertexEvaluator<? extends Expression>>();
        ArrayList<Vertex> arrayList2 = new ArrayList<Vertex>();
        SimpleDeclaration simpleDeclaration = null;
        if (((Variable)this.vertex).getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT) != null) {
            simpleDeclaration = (SimpleDeclaration)((Variable)this.vertex).getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getThat();
        }
        if (simpleDeclaration != null) {
            arrayList2.add(simpleDeclaration);
            greqlVertex = (Declaration)simpleDeclaration.getFirstIsSimpleDeclOfIncidence().getThat();
            if (greqlVertex.getFirstIsCompDeclOfIncidence(EdgeDirection.OUT) != null) {
                arrayList2.add(greqlVertex.getFirstIsCompDeclOfIncidence(EdgeDirection.OUT).getThat());
            } else {
                arrayList2.add(greqlVertex.getFirstIsQuantifiedDeclOfIncidence(EdgeDirection.OUT).getThat());
            }
        }
        linkedList.add(this.vertex);
        while (!linkedList.isEmpty()) {
            greqlVertex = (GreqlVertex)linkedList.poll();
            VertexEvaluator<Declaration> vertexEvaluator = this.query.getVertexEvaluator(greqlVertex);
            if (!(vertexEvaluator == null || arrayList.contains(vertexEvaluator) || vertexEvaluator instanceof PathDescriptionEvaluator || vertexEvaluator instanceof DeclarationEvaluator || vertexEvaluator instanceof SimpleDeclarationEvaluator)) {
                arrayList.add(vertexEvaluator);
            }
            for (GreqlAggregation greqlAggregation = greqlVertex.getFirstGreqlAggregationIncidence(EdgeDirection.OUT); greqlAggregation != null; greqlAggregation = greqlAggregation.getNextGreqlAggregationIncidence(EdgeDirection.OUT)) {
                GreqlVertex greqlVertex2 = (GreqlVertex)greqlAggregation.getThat();
                if (arrayList2.contains(greqlVertex2)) continue;
                linkedList.add(greqlVertex2);
            }
        }
        return arrayList;
    }

    @Override
    public void calculateNeededAndDefinedVariables() {
    }

    @Override
    public long getVariableCombinations() {
        if (this.estimatedAssignments == Long.MIN_VALUE) {
            this.estimatedAssignments = this.calculateEstimatedAssignments();
        }
        return this.estimatedAssignments;
    }

    public long calculateEstimatedAssignments() {
        Variable variable = (Variable)this.getVertex();
        IsDeclaredVarOf isDeclaredVarOf = variable.getFirstIsDeclaredVarOfIncidence();
        if (isDeclaredVarOf != null) {
            SimpleDeclaration simpleDeclaration = isDeclaredVarOf.getOmega();
            VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(simpleDeclaration.getFirstIsTypeExprOfIncidence().getAlpha());
            return vertexEvaluator.getEstimatedCardinality();
        }
        return 1L;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        return new VertexCosts(1L, 1L, 1L);
    }
}

