/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import java.util.ArrayList;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PVector;

public class Get
extends Function {
    public Get() {
        super(2L, 1L, 1.0);
    }

    @Description(params={"v", "i"}, description="Returns the value stored in v at index i. Short notation: v[i]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> T evaluate(PVector<T> pVector, Integer n) {
        return n < 0 || n >= pVector.size() ? null : (T)pVector.get(n);
    }

    @Description(params={"s", "i"}, description="Returns the value stored in s at index i. Short notation: s[i].", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> T evaluate(POrderedSet<T> pOrderedSet, Integer n) {
        return n < 0 || n >= pOrderedSet.size() ? null : (T)pOrderedSet.get(n);
    }

    @Description(params={"t", "i"}, description="Returns the value stored in t at index i. Short notation: t[i]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> T evaluate(Table<T> table, Integer n) {
        return n < 0 || n >= table.size() ? null : (T)table.get(n);
    }

    @Description(params={"t", "i"}, description="Returns the i-th of tuple t. Short notation: t[i]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public Object evaluate(Tuple tuple, Integer n) {
        return n < 0 || n >= tuple.size() ? null : tuple.get(n);
    }

    @Description(params={"map", "key"}, description="Returns the map value associated with key. Short notation: map[key]", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <K, V> V evaluate(PMap<K, V> pMap, K k) {
        return pMap.get(k);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return arrayList.get(0);
    }

    @Override
    public long getEstimatedCardinality(int n) {
        return n;
    }
}

