/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.IterativeDepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.topological_order.TopologicalOrderWithDFS;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;

@NeedsGraphArgument
public class IsAcyclic
extends Function {
    @Description(params={"g"}, description="Returns true, iff the graph is acyclic.", categories={Function.Category.GRAPH})
    public IsAcyclic() {
        super(100L, 1L, 0.1);
    }

    public Boolean evaluate(Graph graph) {
        IterativeDepthFirstSearch iterativeDepthFirstSearch = new IterativeDepthFirstSearch(graph);
        TopologicalOrderWithDFS topologicalOrderWithDFS = new TopologicalOrderWithDFS(graph, iterativeDepthFirstSearch);
        try {
            topologicalOrderWithDFS.execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            throw new RuntimeException(algorithmTerminatedException.getMessage(), algorithmTerminatedException.getCause());
        }
        return topologicalOrderWithDFS.isAcyclic();
    }
}

