/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSearchQueueEntry;
import java.util.LinkedList;

@NeedsEvaluatorArgument
public class IsReachable
extends Function {
    public static boolean PRINT_STOP_VERTICES = false;

    @Description(params={"internal", "u", "v", "dfa"}, description="Returns true, iff there is a path from vertex given as first argument to vertex given as second argument that matches the path description given as second argument. Usually invoked like so: myVertex (--> | <>--)+ myOtherVertex.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public IsReachable() {
        super(50L, 1L, 0.01);
    }

    public Boolean evaluate(InternalGreqlEvaluator internalGreqlEvaluator, Vertex vertex, Vertex vertex2, DFA dFA) {
        Object object2;
        if (vertex.getGraph() != vertex2.getGraph()) {
            throw new IllegalArgumentException("The vertices are in different graphs, but must be in the same graph.");
        }
        BooleanGraphMarker[] booleanGraphMarkerArray = new BooleanGraphMarker[dFA.stateList.size()];
        for (Object object2 : dFA.stateList) {
            booleanGraphMarkerArray[((State)object2).number] = new BooleanGraphMarker(vertex.getGraph());
        }
        LinkedList linkedList = new LinkedList();
        object2 = new PathSearchQueueEntry(vertex, dFA.initialState);
        booleanGraphMarkerArray[((PathSearchQueueEntry)object2).state.number].mark(((PathSearchQueueEntry)object2).vertex);
        linkedList.add(object2);
        while (!linkedList.isEmpty()) {
            object2 = (PathSearchQueueEntry)linkedList.poll();
            if (((PathSearchQueueEntry)object2).vertex == vertex2 && ((PathSearchQueueEntry)object2).state.isFinal) {
                return true;
            }
            for (Edge edge : ((PathSearchQueueEntry)object2).vertex.incidences()) {
                for (Transition transition : ((PathSearchQueueEntry)object2).state.outTransitions) {
                    Vertex vertex3 = transition.getNextVertex(((PathSearchQueueEntry)object2).vertex, edge);
                    boolean bl = booleanGraphMarkerArray[transition.endState.number].isMarked(vertex3);
                    boolean bl2 = transition.accepts(((PathSearchQueueEntry)object2).vertex, edge, internalGreqlEvaluator);
                    if (bl || !bl2) continue;
                    PathSearchQueueEntry pathSearchQueueEntry = new PathSearchQueueEntry(vertex3, transition.endState);
                    booleanGraphMarkerArray[pathSearchQueueEntry.state.number].mark(vertex3);
                    linkedList.add(pathSearchQueueEntry);
                }
            }
        }
        return false;
    }
}

