/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.IterativeDepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.topological_order.TopologicalOrderWithDFS;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import org.pcollections.PVector;

@NeedsGraphArgument
public class TopologicalSort
extends Function {
    @Description(params={"g"}, description="Returns a list of vertices in topological order, iff the graph $g$ is acyclic. Otherwise, the result is undefined.", categories={Function.Category.GRAPH})
    public TopologicalSort() {
        super(100L, 1L, 0.1);
    }

    public PVector<? extends Vertex> evaluate(Graph graph) {
        IterativeDepthFirstSearch iterativeDepthFirstSearch = new IterativeDepthFirstSearch(graph);
        TopologicalOrderWithDFS topologicalOrderWithDFS = new TopologicalOrderWithDFS(graph, iterativeDepthFirstSearch);
        try {
            topologicalOrderWithDFS.execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            throw new RuntimeException(algorithmTerminatedException.getMessage(), algorithmTerminatedException.getCause());
        }
        if (!topologicalOrderWithDFS.isAcyclic()) {
            return null;
        }
        PVector<Object> pVector = JGraLab.vector();
        Permutation<Vertex> permutation = topologicalOrderWithDFS.getTopologicalOrder();
        for (Vertex vertex : permutation.getRangeElements()) {
            pVector = pVector.plus(vertex);
        }
        return pVector;
    }

    @Override
    public long getEstimatedCardinality(int n) {
        return n;
    }
}

