/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

@NeedsGraphArgument
public class VertexTypeSubgraph
extends Function {
    @Description(params={"graph", "typeCollection"}, description="Returns the subgraph induced by the vertex types in typeCollection, i.e. all vertices specified by typeCollection together with all edges between those vertices.", categories={Function.Category.GRAPH})
    public VertexTypeSubgraph() {
        super(7L, 1L, 1.0);
    }

    public SubGraphMarker evaluate(Graph graph, TypeCollection typeCollection) {
        SubGraphMarker subGraphMarker = new SubGraphMarker(graph);
        for (Vertex vertex = graph.getFirstVertex(); vertex != null; vertex = vertex.getNextVertex()) {
            if (!typeCollection.acceptsType(vertex.getAttributedElementClass())) continue;
            subGraphMarker.mark(vertex);
        }
        for (Edge edge = graph.getFirstEdge(); edge != null; edge = edge.getNextEdge()) {
            if (!subGraphMarker.isMarked(edge.getAlpha()) || !subGraphMarker.isMarked(edge.getOmega())) continue;
            subGraphMarker.mark(edge);
        }
        return subGraphMarker;
    }
}

