/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.strings;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import org.pcollections.ArrayPVector;
import org.pcollections.PCollection;
import org.pcollections.PVector;

public class Concat
extends Function {
    public Concat() {
        super(3L, 1L, 1.0);
    }

    @Description(params={"a", "b"}, description="Concatenates strings. Can be used as infix operator: a ++ b.", categories={Function.Category.STRINGS})
    public String evaluate(String string, Object object) {
        return string + object;
    }

    @Description(params={"a", "b"}, description="Concatenates strings. Can be used as infix operator: a ++ b.", categories={Function.Category.STRINGS})
    public String evaluate(Object object, String string) {
        return object + string;
    }

    @Description(params={"a", "b"}, description="Concatenates collections. Can be used as infix operator: a ++ b.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PVector<T> evaluate(PCollection<T> pCollection, PCollection<T> pCollection2) {
        if (pCollection instanceof ArrayPVector) {
            return (PVector)pCollection.plusAll(pCollection2);
        }
        PVector pVector = JGraLab.vector();
        return pVector.plusAll(pCollection).plusAll(pCollection2);
    }
}

