/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.ThisLiteral;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.HashSet;
import java.util.Set;
import org.pcollections.PVector;

public class OptimizerUtility {
    public static boolean isAbove(Vertex vertex, Vertex vertex2) {
        if (vertex == vertex2) {
            return true;
        }
        for (Edge edge : vertex.incidences(EdgeDirection.IN)) {
            if (!OptimizerUtility.isAbove(edge.getAlpha(), vertex2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnd(FunctionApplication functionApplication) {
        return functionApplication.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("and");
    }

    public static boolean isOr(FunctionApplication functionApplication) {
        return functionApplication.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("or");
    }

    public static boolean isXor(FunctionApplication functionApplication) {
        return functionApplication.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("xor");
    }

    public static boolean isNot(FunctionApplication functionApplication) {
        return functionApplication.getFirstIsFunctionIdOfIncidence().getAlpha().get_name().equals("not");
    }

    public static void mergeSourcePositions(GreqlAggregation greqlAggregation, GreqlAggregation greqlAggregation2) {
        PVector<SourcePosition> pVector = greqlAggregation2.get_sourcePositions();
        if (pVector == null) {
            pVector = JGraLab.vector();
        }
        for (SourcePosition sourcePosition : greqlAggregation.get_sourcePositions()) {
            if (pVector.contains(sourcePosition)) continue;
            pVector = pVector.plus(sourcePosition);
        }
        greqlAggregation2.set_sourcePositions(pVector);
    }

    public static FunctionId findOrCreateFunctionId(String string, GreqlGraph greqlGraph) {
        for (FunctionId functionId : greqlGraph.getFunctionIdVertices()) {
            if (!functionId.get_name().equals(string)) continue;
            return functionId;
        }
        FunctionId functionId = greqlGraph.createFunctionId();
        functionId.set_name(string);
        return functionId;
    }

    public static void createMissingSourcePositions(GreqlGraph greqlGraph) {
        for (GreqlAggregation greqlAggregation : greqlGraph.getGreqlAggregationEdges()) {
            if (greqlAggregation.get_sourcePositions() != null) continue;
            PVector<SourcePosition> pVector = JGraLab.vector();
            greqlAggregation.set_sourcePositions(pVector);
        }
    }

    public static Set<Variable> collectVariablesDeclaredBy(SimpleDeclaration simpleDeclaration) {
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (IsDeclaredVarOf isDeclaredVarOf : simpleDeclaration.getIsDeclaredVarOfIncidences(EdgeDirection.IN)) {
            hashSet.add(isDeclaredVarOf.getAlpha());
        }
        return hashSet;
    }

    public static Set<Variable> collectInternallyDeclaredVariablesBelow(Vertex vertex) {
        return OptimizerUtility.collectInternallyDeclaredVariablesBelow(vertex, new HashSet<Variable>());
    }

    private static Set<Variable> collectInternallyDeclaredVariablesBelow(Vertex vertex, Set<Variable> set) {
        if (vertex instanceof Variable && !(vertex instanceof ThisLiteral)) {
            Variable variable = (Variable)vertex;
            if (variable.getFirstIsBoundVarOfIncidence(EdgeDirection.OUT) == null) {
                set.add(variable);
            }
            return set;
        }
        for (Edge edge : vertex.incidences(EdgeDirection.IN)) {
            OptimizerUtility.collectInternallyDeclaredVariablesBelow(edge.getAlpha(), set);
        }
        return set;
    }

    public static void deleteOrphanedVerticesBelow(Vertex vertex, HashSet<Vertex> hashSet) {
        OptimizerUtility.deleteOrphanedVerticesBelow(vertex, hashSet, new HashSet<Vertex>());
    }

    private static void deleteOrphanedVerticesBelow(Vertex vertex, HashSet<Vertex> hashSet, HashSet<Vertex> hashSet2) {
        assert (vertex.isValid());
        if (hashSet2.contains(vertex)) {
            return;
        }
        HashSet<Vertex> hashSet3 = new HashSet<Vertex>();
        for (Edge graphElement : vertex.incidences(EdgeDirection.IN)) {
            hashSet3.add(graphElement.getAlpha());
        }
        if (vertex.getFirstIncidence(EdgeDirection.OUT) == null && !hashSet.contains(vertex)) {
            hashSet2.add(vertex);
            vertex.delete();
            for (Vertex vertex2 : hashSet3) {
                OptimizerUtility.deleteOrphanedVerticesBelow(vertex2, hashSet, hashSet2);
            }
        }
    }
}

