/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.funlib.collections.Intersection;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.EdgePathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsPathDescriptionOf;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PathExpression;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.VertexSetExpression;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;

public class PathExistenceToDirectedPathExpressionOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(PathExistenceToDirectedPathExpressionOptimizer.class);

    public PathExistenceToDirectedPathExpressionOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof PathExistenceToDirectedPathExpressionOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        GreqlGraph greqlGraph = greqlQuery.getQueryGraph();
        if (greqlGraph.getFirstVertex(PathExistence.VC) == null) {
            return false;
        }
        LinkedList<PathExistence> linkedList = new LinkedList<PathExistence>();
        for (PathExistence object : greqlGraph.getPathExistenceVertices()) {
            if (this.isInNot(object)) continue;
            linkedList.add(object);
        }
        Iterator<PathExistence> iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            PathExistence pathExistence = iterator.next();
            boolean bl = this.tryOptimizePathExistence(pathExistence);
            if (bl) continue;
            iterator.remove();
        }
        for (PathExistence pathExistence : linkedList) {
            BoolLiteral boolLiteral = greqlGraph.createBoolLiteral();
            boolLiteral.set_boolValue(true);
            while (pathExistence.getFirstIncidence(EdgeDirection.OUT) != null) {
                Edge edge = pathExistence.getFirstIncidence(EdgeDirection.OUT);
                edge.setAlpha(boolLiteral);
                assert (edge.getAlpha() == boolLiteral);
            }
            pathExistence.delete();
        }
        OptimizerUtility.createMissingSourcePositions(greqlGraph);
        return !linkedList.isEmpty();
    }

    private boolean isInNot(Vertex vertex) {
        Object object;
        if (vertex instanceof FunctionApplication && (object = (FunctionApplication)vertex).get_functionId().get_name().equals("not")) {
            return true;
        }
        for (Edge edge : vertex.incidences(EdgeDirection.OUT)) {
            boolean bl = this.isInNot(edge.getThat());
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    private boolean tryOptimizePathExistence(PathExistence pathExistence) {
        Set<Variable> set;
        GreqlVertex greqlVertex;
        Expression expression = pathExistence.get_startExpr();
        Expression expression2 = pathExistence.get_targetExpr();
        if (!(expression instanceof Variable) || !(expression2 instanceof Variable)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence hasn't form var1 --> var2, skipping...");
            return false;
        }
        Expression expression3 = pathExistence.get_path();
        if (!(expression3 instanceof PathDescription)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence contains an Expression as PathDescription, skipping...");
            return false;
        }
        if (!this.isOptimizablePathDescription((PathDescription)expression3)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence contains an EdgePathDescription, skipping...");
            return false;
        }
        Variable variable = (Variable)expression;
        Variable variable2 = (Variable)expression2;
        if (variable == variable2) {
            logger.finer(this.optimizerHeaderString() + "PathExistence specifies a loop, skipping...");
            return false;
        }
        boolean bl = true;
        if (this.isDeclaredBefore(variable2, variable)) {
            bl = false;
        }
        Object object = null;
        Variable variable3 = null;
        Variable variable4 = null;
        IsBoundVarOf isBoundVarOf = variable.getFirstIsBoundVarOfIncidence();
        IsBoundVarOf isBoundVarOf2 = variable2.getFirstIsBoundVarOfIncidence();
        if (isBoundVarOf != null && isBoundVarOf2 != null) {
            return false;
        }
        if (isBoundVarOf != null && isBoundVarOf2 == null) {
            variable4 = variable;
            variable3 = variable2;
            greqlVertex = variable2.getFirstIsDeclaredVarOfIncidence().getOmega();
            object = greqlVertex.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl((SimpleDeclaration)greqlVertex, variable2) : greqlVertex;
        } else if (isBoundVarOf == null && isBoundVarOf2 != null) {
            variable4 = variable2;
            variable3 = variable;
            greqlVertex = variable.getFirstIsDeclaredVarOfIncidence().getOmega();
            object = greqlVertex.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl((SimpleDeclaration)greqlVertex, variable2) : greqlVertex;
        } else {
            greqlVertex = variable.getFirstIsDeclaredVarOfIncidence().getOmega();
            set = variable2.getFirstIsDeclaredVarOfIncidence().getOmega();
            if (set == greqlVertex) {
                if (bl) {
                    object = this.splitSimpleDecl((SimpleDeclaration)greqlVertex, variable2);
                    variable4 = variable;
                    variable3 = variable2;
                } else {
                    object = this.splitSimpleDecl((SimpleDeclaration)greqlVertex, variable);
                    variable4 = variable2;
                    variable3 = variable;
                }
            } else if (bl) {
                object = set.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl((SimpleDeclaration)((Object)set), variable2) : set;
                variable3 = variable2;
                variable4 = variable;
            } else {
                object = greqlVertex.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl((SimpleDeclaration)greqlVertex, variable) : greqlVertex;
                variable4 = variable2;
                variable3 = variable;
            }
        }
        if (this.isDeclaredBefore(variable3, variable4)) {
            return false;
        }
        if (!this.isConstraintAndTopLevelConjunction(pathExistence, object.getFirstIsSimpleDeclOfIncidence().getOmega())) {
            logger.finer(this.optimizerHeaderString() + pathExistence + " cannot be optimized, cause it's not in an constraint conjunction...");
            return false;
        }
        greqlVertex = (PathDescription)pathExistence.get_path();
        set = OptimizerUtility.collectInternallyDeclaredVariablesBelow(greqlVertex);
        if (set.contains(variable3)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence path contains declared var, so skipping...");
            return false;
        }
        for (Variable attributedElement2 : set) {
            if (!this.isDeclaredBefore(variable3, attributedElement2)) continue;
            logger.finer(this.optimizerHeaderString() + "PathExistence path contains a previously declared var, so skipping...");
            return false;
        }
        Expression expression4 = object.get_typeExpr();
        if (expression4 instanceof VertexSetExpression) {
            VertexSetExpression vertexSetExpression = (VertexSetExpression)expression4;
            this.optimizeVertexSetExpression(pathExistence, (SimpleDeclaration)object, variable4, vertexSetExpression);
            return true;
        }
        object.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN).delete();
        GreqlGraph greqlGraph = (GreqlGraph)expression4.getGraph();
        FunctionApplication functionApplication = greqlGraph.createFunctionApplication();
        greqlGraph.createIsFunctionIdOf(OptimizerUtility.findOrCreateFunctionId(Intersection.class.getSimpleName().toLowerCase(), greqlGraph), functionApplication);
        functionApplication.add_argument(expression4);
        object.add_typeExpr(functionApplication);
        boolean bl2 = true;
        if (pathExistence.get_targetExpr() == variable4) {
            bl2 = false;
        }
        PathExpression pathExpression = this.createForwardOrBackwardVertexSet(bl2, variable4, (PathDescription)greqlVertex, null);
        functionApplication.add_argument(pathExpression);
        return true;
    }

    private boolean isOptimizablePathDescription(PathDescription pathDescription) {
        if (pathDescription instanceof EdgePathDescription) {
            return false;
        }
        for (IsPathDescriptionOf isPathDescriptionOf : pathDescription.getIsPathDescriptionOfIncidences(EdgeDirection.IN)) {
            boolean bl = this.isOptimizablePathDescription((PathDescription)isPathDescriptionOf.getThat());
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean isConstraintAndTopLevelConjunction(Vertex vertex, Declaration declaration) {
        if (vertex == declaration) {
            return true;
        }
        if (vertex instanceof FunctionApplication && OptimizerUtility.isOr((FunctionApplication)vertex)) {
            return false;
        }
        for (Edge edge : vertex.incidences(EdgeDirection.OUT)) {
            Vertex vertex2 = edge.getOmega();
            if (!this.isConstraintAndTopLevelConjunction(vertex2, declaration)) continue;
            return true;
        }
        return false;
    }

    private PathExpression createForwardOrBackwardVertexSet(boolean bl, Variable variable, PathDescription pathDescription, Iterable<? extends TypeId> iterable) {
        GreqlGraph greqlGraph = (GreqlGraph)pathDescription.getGraph();
        PathExpression pathExpression = null;
        if (bl) {
            pathExpression = greqlGraph.createForwardVertexSet();
            pathExpression.add_path(pathDescription);
            if (iterable != null) {
                for (TypeId typeId : iterable) {
                    pathDescription.add_goalRestr(typeId);
                }
            }
            pathExpression.add_startExpr(variable);
        } else {
            pathExpression = greqlGraph.createBackwardVertexSet();
            pathExpression.add_path(pathDescription);
            if (iterable != null) {
                for (TypeId typeId : iterable) {
                    pathDescription.add_startRestr(typeId);
                }
            }
            pathExpression.add_targetExpr(variable);
        }
        return pathExpression;
    }

    private boolean optimizeVertexSetExpression(PathExistence pathExistence, SimpleDeclaration simpleDeclaration, Variable variable, VertexSetExpression vertexSetExpression) {
        boolean bl = true;
        if (pathExistence.get_targetExpr() == variable) {
            bl = false;
        }
        GreqlGraph greqlGraph = (GreqlGraph)pathExistence.getGraph();
        PathExpression pathExpression = this.createForwardOrBackwardVertexSet(bl, variable, (PathDescription)pathExistence.get_path(), vertexSetExpression.get_typeRestr());
        if (vertexSetExpression.getDegree(EdgeDirection.OUT) < 2) {
            vertexSetExpression.delete();
        } else {
            simpleDeclaration.getFirstIsTypeExprOfDeclarationIncidence().delete();
        }
        greqlGraph.createIsTypeExprOfDeclaration(pathExpression, simpleDeclaration);
        logger.finer(this.optimizerHeaderString() + "Created " + pathExpression + " as optimization...");
        return true;
    }

    private SimpleDeclaration splitSimpleDecl(SimpleDeclaration simpleDeclaration, Variable variable) {
        HashSet<Variable> hashSet = new HashSet<Variable>(1);
        hashSet.add(variable);
        return this.splitSimpleDeclaration(simpleDeclaration, hashSet);
    }
}

